/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.wifiservice;

import android.content.Context;
import com.whereabout.common.WifiScanner;
import com.whereabout.wifiservice.LocalWifiLocalizer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalWifiLocalizerDebugger
extends LocalWifiLocalizer {
    private FileWriter writer = null;
    private FileWriter detailwriter = null;

    public LocalWifiLocalizerDebugger(Context ct, WifiScanner scanner) {
        super(ct, scanner);
        this.dataStore = scanner.getDataStore();
    }

    @Override
    protected double compareScans(HashMap<String, Double> expected, HashMap<String, Double> actual) {
        boolean numMatchingKeys = false;
        this.debug(this.detailwriter, "*** Location: " + this.locationCurrentlyMatchingWith + "\n");
        for (String key : actual.keySet()) {
            if (expected.containsKey(key)) {
                this.debug(this.detailwriter, String.valueOf(key) + " : actual = " + actual.get(key) + " : expected = " + expected.get(key) + "\n");
                continue;
            }
            this.debug(this.detailwriter, "- " + key + " : " + actual.get(key) + "\n");
        }
        for (String mackey : expected.keySet()) {
            if (actual.containsKey(mackey)) continue;
            this.debug(this.detailwriter, "+ " + mackey + " : " + expected.get(mackey) + "\n");
        }
        double matchScore = super.compareScans(expected, actual);
        this.debug(this.detailwriter, "*** MatchScore: " + matchScore + "\n---------------------\n\n");
        return matchScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void computeMatch(String expectedLocation) {
        WifiScanner wifiScanner = this.wifiScanner;
        synchronized (wifiScanner) {
            try {
                this.initDebug(expectedLocation);
                for (String key : this.wifiStrengthTable.keySet()) {
                    double strength = (Double)this.wifiStrengthTable.get(key) / (double)((Integer)this.wifiCountTable.get(key)).intValue();
                    this.debug(this.writer, String.valueOf(key) + " " + strength + "\n");
                }
                this.debug(this.detailwriter, "- : Currently seeing but not expected.\n");
                this.debug(this.detailwriter, "+ : Currently not seeing but expected.\n\n");
                super.computeMatch(expectedLocation);
                int i = 0;
                while (i < this.matchingLocations.size()) {
                    this.debug(this.writer, String.valueOf(i) + " : " + (String)this.matchingLocations.get(i) + " : " + this.matchingLocScores.get(i) + "\n");
                    ++i;
                }
                this.debug(this.writer, "Expected location: " + expectedLocation + "\n");
                this.writer.close();
                this.detailwriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initDebug(String fileName) throws IOException {
        File dirFile = new File("/sdcard/wifiscans/debug");
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        File debugFile = new File("/sdcard/wifiscans/debug/" + System.currentTimeMillis() + "-" + fileName);
        File debugDetailFile = new File("/sdcard/wifiscans/debug/" + System.currentTimeMillis() + "-" + fileName + "-details");
        if (!debugFile.exists()) {
            debugFile.createNewFile();
        }
        this.writer = new FileWriter(debugFile);
        this.detailwriter = new FileWriter(debugDetailFile);
    }

    private void debug(FileWriter writer, String str) {
        try {
            if (writer != null) {
                writer.write(str);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

