/*
 * Decompiled with CFR 0.152.
 */
package com.android.ocr.client;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.ocr.client.Config;
import com.android.ocr.client.IOcr;
import com.android.ocr.client.IOcrCallback;
import com.android.ocr.client.Language;
import com.android.ocr.client.Result;
import com.android.ocr.client.VersionAlert;

public class Ocr {
    private static final int MIN_VER = 1;
    private static final String TAG = "Ocr";
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_MISSING = 2;
    private int mVersion = -1;
    private IOcr mIOcr;
    private ServiceConnection mServiceConnection;
    private Activity mContext;
    private Language[] mSupportedLang;

    public Ocr(Activity context, InitCallback init) {
        this.mContext = context;
        this.connectOcrService(init);
    }

    protected void finalize() {
        this.release();
    }

    public boolean recognizeText(Config config, final ResultCallback onResult, final CompletionCallback onCompleted) {
        if (this.mIOcr == null) {
            Log.e((String)TAG, (String)"Attempted to enqueue job with null interface.");
            return false;
        }
        IOcrCallback.Stub callback = new IOcrCallback.Stub(){

            @Override
            public void onCompleted(Result[] results) {
                Log.i((String)Ocr.TAG, (String)"onCompleted()");
                if (onCompleted != null) {
                    onCompleted.onCompleted(results);
                }
            }

            @Override
            public void onResult(Result result) {
                Log.i((String)Ocr.TAG, (String)"onResult()");
                if (onResult != null) {
                    onResult.onResult(result);
                }
            }
        };
        Log.i((String)TAG, (String)"Enqueuing job...");
        try {
            this.mIOcr.enqueueJob(config, callback);
        }
        catch (DeadObjectException e) {
            Log.e((String)TAG, (String)("Exception caught in recognizeText(): " + e.toString()));
            return false;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Exception caught in recognizeText(): " + e.toString()));
            return false;
        }
        Log.e((String)TAG, (String)"Successfully enqueued job.");
        return true;
    }

    public int getProgress() {
        if (this.mIOcr == null) {
            Log.e((String)TAG, (String)"Attempted to call getProgress() without a connection to Ocr service.");
            return -1;
        }
        int progress = 0;
        try {
            progress = this.mIOcr.getProgress();
        }
        catch (DeadObjectException e) {
            Log.e((String)TAG, (String)("Exception caught in getProgress(): " + e.toString()));
            progress = -1;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Exception caught in getProgress(): " + e.toString()));
            progress = -1;
        }
        return progress;
    }

    public void release() {
        try {
            this.mContext.unbindService(this.mServiceConnection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mIOcr = null;
    }

    private void connectOcrService(final InitCallback init) {
        Log.i((String)TAG, (String)"Connecting to OCR service...");
        this.mServiceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                Log.i((String)Ocr.TAG, (String)"onServiceConnected()");
                Ocr.this.mIOcr = IOcr.Stub.asInterface(service);
                try {
                    Ocr.this.mVersion = Ocr.this.mIOcr.getVersion();
                    if (Ocr.this.mVersion < 1) {
                        Log.e((String)Ocr.TAG, (String)("OCR service too old (version " + Ocr.this.mVersion + " < " + 1 + ")"));
                        VersionAlert.createUpdateAlert((Context)Ocr.this.mContext, null).show();
                        if (init != null) {
                            init.onInitialized(2);
                        }
                        return;
                    }
                    Ocr.this.mSupportedLang = Ocr.this.mIOcr.getLanguages();
                    if (Ocr.this.mSupportedLang == null || Ocr.this.mSupportedLang.length == 0) {
                        DialogInterface.OnClickListener onClick = new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                if (init != null) {
                                    init.onInitialized(2);
                                }
                            }
                        };
                        VersionAlert.createLanguagesAlert(Ocr.this.mContext, onClick, onClick, -1).show();
                        return;
                    }
                }
                catch (RemoteException e) {
                    Log.e((String)Ocr.TAG, (String)("Exception caught in onServiceConnected(): " + e.toString()));
                    if (init != null) {
                        init.onInitialized(1);
                    }
                    return;
                }
                Log.i((String)Ocr.TAG, (String)"Connected to OCR service.");
                if (init != null) {
                    init.onInitialized(0);
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                Log.e((String)Ocr.TAG, (String)"Disconnected from OCR service.");
                Ocr.this.mIOcr = null;
            }
        };
        Intent intent = new Intent("com.android.ocr.intent.SERVICE");
        intent.addCategory("android.intent.category.DEFAULT");
        if (!this.mContext.bindService(intent, this.mServiceConnection, 1)) {
            Log.e((String)TAG, (String)"Cannot bind to OCR service, assuming not installed.");
            VersionAlert.createInstallAlert((Context)this.mContext, null).show();
            if (init != null) {
                init.onInitialized(2);
            }
        }
    }

    public Language[] getLanguages() {
        return this.mSupportedLang;
    }

    public void reloadLanguages() {
        if (this.mIOcr == null) {
            Log.e((String)TAG, (String)"Attempted to call reloadLanguages() without a connection to Ocr service.");
            return;
        }
        try {
            this.mIOcr.reloadLanguages();
            this.mSupportedLang = this.mIOcr.getLanguages();
        }
        catch (DeadObjectException e) {
            Log.e((String)TAG, (String)("Exception caught in reloadLanguages(): " + e.toString()));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Exception caught in reloadLanguages(): " + e.toString()));
        }
    }

    public void stop() {
        if (this.mIOcr == null) {
            Log.e((String)TAG, (String)"Attempted to call stop() without a connection to Ocr service.");
            return;
        }
        try {
            this.mIOcr.cancel();
        }
        catch (DeadObjectException e) {
            Log.e((String)TAG, (String)("Exception caught in stop(): " + e.toString()));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Exception caught in stop(): " + e.toString()));
        }
    }

    public int getVersion() {
        return this.mVersion;
    }

    public static boolean isInstalled(Context ctx) {
        PackageManager pm = ctx.getPackageManager();
        Intent intent = new Intent("com.android.ocr.SERVICE");
        intent.addCategory("android.intent.category.DEFAULT");
        ResolveInfo info = pm.resolveService(intent, 0);
        return info != null;
    }

    public static interface CompletionCallback {
        public void onCompleted(Result[] var1);
    }

    public static interface InitCallback {
        public void onInitialized(int var1);
    }

    public static interface ResultCallback {
        public void onResult(Result var1);
    }
}

