/*
 * Decompiled with CFR 0.152.
 */
package com.google.tts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.tts.ConfigurationManager;
import com.google.tts.ITTS;
import com.google.tts.ITTSCallback;
import com.google.tts.TTSEarcon;
import com.google.tts.TTSEngine;
import com.google.tts.TTSVersionAlert;

public class TTS {
    private static final int MIN_VER = 10;
    private ServiceConnection serviceConnection;
    private ITTS itts;
    private Context ctx;
    private InitListener cb = null;
    private int version = -1;
    private boolean started = false;
    private boolean showInstaller = false;
    private TTSVersionAlert versionAlert = null;
    private ITTSCallback ittscallback;
    private SpeechCompletedListener speechCompletedCallback = null;

    public TTS(Context context, InitListener callback, boolean displayInstallMessage) {
        this.showInstaller = displayInstallMessage;
        this.ctx = context;
        this.cb = callback;
        if (this.dataFilesCheck()) {
            this.initTts();
        }
    }

    public TTS(Context context, InitListener callback, TTSVersionAlert alert) {
        this.showInstaller = true;
        this.versionAlert = alert;
        this.ctx = context;
        this.cb = callback;
        if (this.dataFilesCheck()) {
            this.initTts();
        }
    }

    public void setOnSpeechCompletedListener(SpeechCompletedListener listener) {
        this.speechCompletedCallback = listener;
    }

    private boolean dataFilesCheck() {
        if (!ConfigurationManager.allFilesExist()) {
            if (!this.showInstaller) {
                return false;
            }
            try {
                int flags = 3;
                Context myContext = this.ctx.createPackageContext("com.google.tts", flags);
                Class<?> appClass = myContext.getClassLoader().loadClass("com.google.tts.ConfigurationManager");
                Intent intent = new Intent(myContext, appClass);
                this.ctx.startActivity(intent);
                return false;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void initTts() {
        this.started = false;
        this.serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                TTS.this.itts = ITTS.Stub.asInterface(service);
                try {
                    TTS.this.version = TTS.this.itts.getVersion();
                    if (TTS.this.version < 10) {
                        if (TTS.this.showInstaller) {
                            if (TTS.this.versionAlert != null) {
                                TTS.this.versionAlert.show();
                            } else {
                                new TTSVersionAlert(TTS.this.ctx, null, null, null).show();
                            }
                        }
                        return;
                    }
                    TTS.this.ittscallback = new ITTSCallback.Stub(){

                        @Override
                        public void markReached(String mark) throws RemoteException {
                            if (TTS.this.speechCompletedCallback != null) {
                                TTS.this.speechCompletedCallback.onSpeechCompleted();
                            }
                        }
                    };
                    TTS.this.itts.registerCallback(TTS.this.ittscallback);
                }
                catch (RemoteException e) {
                    TTS.this.initTts();
                    return;
                }
                TTS.this.started = true;
                if (TTS.this.cb != null) {
                    TTS.this.cb.onInit(TTS.this.version);
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                TTS.this.itts = null;
                TTS.this.cb = null;
                TTS.this.started = false;
            }
        };
        Intent intent = new Intent("android.intent.action.USE_TTS");
        intent.addCategory("android.intent.category.TTS");
        if (!this.ctx.bindService(intent, this.serviceConnection, 1) && this.showInstaller) {
            if (this.versionAlert != null) {
                this.versionAlert.show();
            } else {
                new TTSVersionAlert(this.ctx, null, null, null).show();
            }
        }
    }

    public void shutdown() {
        try {
            this.ctx.unbindService(this.serviceConnection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void addSpeech(String text, String packagename, int resourceId) {
        if (!this.started) {
            return;
        }
        try {
            this.itts.addSpeech(text, packagename, resourceId);
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
        catch (NullPointerException e) {
            this.started = false;
            this.initTts();
        }
        catch (IllegalStateException e) {
            this.started = false;
            this.initTts();
        }
    }

    public void addSpeech(String text, String filename) {
        if (!this.started) {
            return;
        }
        try {
            this.itts.addSpeechFile(text, filename);
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
        catch (NullPointerException e) {
            this.started = false;
            this.initTts();
        }
        catch (IllegalStateException e) {
            this.started = false;
            this.initTts();
        }
    }

    public void speak(String text, int queueMode, String[] params) {
        Log.i((String)"TTS received: ", (String)text);
        if (!this.started) {
            return;
        }
        try {
            this.itts.speak(text, queueMode, params);
        }
        catch (RemoteException e) {
            Log.e((String)"TTS", (String)"RemoteException error.");
            this.started = false;
            this.initTts();
        }
        catch (NullPointerException e) {
            Log.e((String)"TTS", (String)"NullPointerException error.");
            this.started = false;
            this.initTts();
        }
        catch (IllegalStateException e) {
            Log.e((String)"TTS", (String)"IllegalStateException error.");
            this.started = false;
            this.initTts();
        }
    }

    public void playEarcon(String earcon, int queueMode, String[] params) {
        if (!this.started) {
            return;
        }
        try {
            this.itts.playEarcon(earcon, queueMode, params);
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
        catch (NullPointerException e) {
            this.started = false;
            this.initTts();
        }
        catch (IllegalStateException e) {
            this.started = false;
            this.initTts();
        }
    }

    public void playEarcon(TTSEarcon earcon, int queueMode, String[] params) {
        this.playEarcon(earcon.name(), queueMode, params);
    }

    public boolean isSpeaking() {
        if (!this.started) {
            return false;
        }
        try {
            return this.itts.isSpeaking();
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
        catch (NullPointerException e) {
            this.started = false;
            this.initTts();
        }
        catch (IllegalStateException e) {
            this.started = false;
            this.initTts();
        }
        return false;
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            this.itts.stop();
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
        catch (NullPointerException e) {
            this.started = false;
            this.initTts();
        }
        catch (IllegalStateException e) {
            this.started = false;
            this.initTts();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setEngine(TTSEngine selectedEngine) {
        if (!this.started) {
            return;
        }
        try {
            this.itts.setEngine(selectedEngine.toString());
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
    }

    public void setEngine(String ttsEngineBinary) {
        if (!this.started) {
            return;
        }
        try {
            this.itts.setEngine(ttsEngineBinary);
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
    }

    public void setSpeechRate(int speechRate) {
        if (!this.started) {
            return;
        }
        try {
            this.itts.setSpeechRate(speechRate);
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
    }

    public void setLanguage(String language) {
        if (!this.started) {
            return;
        }
        try {
            this.itts.setLanguage(language);
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
    }

    public boolean synthesizeToFile(String text, String[] params, String filename) {
        if (!this.started) {
            return false;
        }
        try {
            return this.itts.synthesizeToFile(text, params, filename);
        }
        catch (RemoteException e) {
            this.started = false;
            this.initTts();
        }
        catch (NullPointerException e) {
            this.started = false;
            this.initTts();
        }
        catch (IllegalStateException e) {
            this.started = false;
            this.initTts();
        }
        return false;
    }

    public void showVersionAlert() {
        if (!this.started) {
            return;
        }
        if (this.versionAlert != null) {
            this.versionAlert.show();
        } else {
            new TTSVersionAlert(this.ctx, null, null, null).show();
        }
    }

    public static boolean isInstalled(Context ctx) {
        PackageManager pm = ctx.getPackageManager();
        Intent intent = new Intent("android.intent.action.USE_TTS");
        intent.addCategory("android.intent.category.TTS");
        ResolveInfo info = pm.resolveService(intent, 0);
        return info != null;
    }

    public static interface InitListener {
        public void onInit(int var1);
    }

    public static interface SpeechCompletedListener {
        public void onSpeechCompleted();
    }
}

