/*
 * Decompiled with CFR 0.152.
 */
package com.google.tts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;
import android.speech.tts.TextToSpeech;
import android.util.Log;
import com.google.tts.ITtsBeta;
import com.google.tts.ITtsCallbackBeta;
import java.util.HashMap;
import java.util.Locale;

public class TextToSpeechBeta
extends TextToSpeech {
    public static final String USING_PLATFORM_TTS = "TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for ";
    public static final String NOT_ON_PLATFORM_TTS = "TextToSpeechBeta not installed - basic platform TextToSpeech does not support ";
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int QUEUE_FLUSH = 0;
    public static final int QUEUE_ADD = 1;
    public static final int LANG_COUNTRY_VAR_AVAILABLE = 2;
    public static final int LANG_COUNTRY_AVAILABLE = 1;
    public static final int LANG_AVAILABLE = 0;
    public static final int LANG_MISSING_DATA = -1;
    public static final int LANG_NOT_SUPPORTED = -2;
    public static final String ACTION_TTS_QUEUE_PROCESSING_COMPLETED = "android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED";
    private ServiceConnection mServiceConnection;
    private ITtsBeta mITts = null;
    private ITtsCallbackBeta mITtscallback = null;
    private Context mContext = null;
    private String mPackageName = "";
    private static OnInitListener mInitListener = null;
    private boolean mStarted = false;
    private final Object mStartLock = new Object();
    private String[] mCachedParams;
    static boolean ttsBetaInstalled = false;
    static TextToSpeech.OnInitListener platformOnInitListener = new TextToSpeech.OnInitListener(){

        public void onInit(int status) {
            if (!ttsBetaInstalled && mInitListener != null) {
                mInitListener.onInit(status, -1);
            }
        }
    };

    public TextToSpeechBeta(Context context, OnInitListener listener) {
        super(context, platformOnInitListener);
        ttsBetaInstalled = TextToSpeechBeta.isInstalled(context);
        mInitListener = listener;
        if (ttsBetaInstalled) {
            super.shutdown();
            this.mContext = context;
            this.mPackageName = this.mContext.getPackageName();
            this.mCachedParams = new String[12];
            this.mCachedParams[0] = "rate";
            this.mCachedParams[2] = "language";
            this.mCachedParams[4] = "country";
            this.mCachedParams[6] = "variant";
            this.mCachedParams[8] = "streamType";
            this.mCachedParams[10] = "utteranceId";
            this.mCachedParams[1] = String.valueOf(100);
            Locale defaultLoc = Locale.getDefault();
            this.mCachedParams[3] = defaultLoc.getISO3Language();
            this.mCachedParams[5] = defaultLoc.getISO3Country();
            this.mCachedParams[7] = defaultLoc.getVariant();
            this.mCachedParams[9] = String.valueOf(3);
            this.mCachedParams[11] = "";
            this.initTts();
        }
    }

    private void initTts() {
        this.mStarted = false;
        this.mServiceConnection = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName name, IBinder service) {
                Object object = TextToSpeechBeta.this.mStartLock;
                synchronized (object) {
                    TextToSpeechBeta.this.mITts = ITtsBeta.Stub.asInterface(service);
                    TextToSpeechBeta.this.mStarted = true;
                    if (mInitListener != null) {
                        try {
                            PackageManager pm = TextToSpeechBeta.this.mContext.getPackageManager();
                            PackageInfo info = pm.getPackageInfo("com.google.tts", 0);
                            mInitListener.onInit(0, info.versionCode);
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName name) {
                Object object = TextToSpeechBeta.this.mStartLock;
                synchronized (object) {
                    TextToSpeechBeta.this.mITts = null;
                    mInitListener = null;
                    TextToSpeechBeta.this.mStarted = false;
                }
            }
        };
        Intent intent = new Intent("com.google.intent.action.START_TTS_SERVICE_BETA");
        intent.addCategory("com.google.intent.category.TTS_BETA");
        this.mContext.bindService(intent, this.mServiceConnection, 1);
    }

    public void shutdown() {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for shutdown");
            super.shutdown();
            return;
        }
        try {
            this.mContext.unbindService(this.mServiceConnection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(String text, String packagename, int resourceId) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for addSpeech");
            return super.addSpeech(text, packagename, resourceId);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                if (!this.mStarted) {
                    return -1;
                }
                this.mITts.addSpeech(this.mPackageName, text, packagename, resourceId);
                return 0;
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(String text, String filename) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for addSpeech");
            return super.addSpeech(text, filename);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                if (!this.mStarted) {
                    return -1;
                }
                this.mITts.addSpeechFile(this.mPackageName, text, filename);
                return 0;
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEarcon(String earcon, String packagename, int resourceId) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for addEarcon");
            return super.addEarcon(earcon, packagename, resourceId);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                if (!this.mStarted) {
                    return -1;
                }
                this.mITts.addEarcon(this.mPackageName, earcon, packagename, resourceId);
                return 0;
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEarcon(String earcon, String filename) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for addEarcon");
            return super.addEarcon(earcon, filename);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                if (!this.mStarted) {
                    return -1;
                }
                this.mITts.addEarconFile(this.mPackageName, earcon, filename);
                return 0;
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int speak(String text, int queueMode, HashMap<String, String> params) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for speak");
            return super.speak(text, queueMode, params);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            Log.i((String)"TTS received: ", (String)text);
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    if (params != null && !params.isEmpty()) {
                        String extra = params.get("streamType");
                        if (extra != null) {
                            this.mCachedParams[9] = extra;
                        }
                        if ((extra = params.get("utteranceId")) != null) {
                            this.mCachedParams[11] = extra;
                        }
                    }
                    result = this.mITts.speak(this.mPackageName, text, queueMode, this.mCachedParams);
                }
                catch (RemoteException e) {
                    Log.e((String)"TextToSpeech.java - speak", (String)"RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (NullPointerException e) {
                    Log.e((String)"TextToSpeech.java - speak", (String)"NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (IllegalStateException e) {
                    Log.e((String)"TextToSpeech.java - speak", (String)"IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
            }
            catch (Throwable throwable) {}
            this.resetCachedParams();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playEarcon(String earcon, int queueMode, HashMap<String, String> params) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for playEarcon");
            return super.playEarcon(earcon, queueMode, params);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    if (params != null && !params.isEmpty()) {
                        String extra = params.get("streamType");
                        if (extra != null) {
                            this.mCachedParams[9] = extra;
                        }
                        if ((extra = params.get("utteranceId")) != null) {
                            this.mCachedParams[11] = extra;
                        }
                    }
                    result = this.mITts.playEarcon(this.mPackageName, earcon, queueMode, null);
                }
                catch (RemoteException e) {
                    Log.e((String)"TextToSpeech.java - playEarcon", (String)"RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (NullPointerException e) {
                    Log.e((String)"TextToSpeech.java - playEarcon", (String)"NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (IllegalStateException e) {
                    Log.e((String)"TextToSpeech.java - playEarcon", (String)"IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
            }
            catch (Throwable throwable) {}
            this.resetCachedParams();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playSilence(long durationInMs, int queueMode, HashMap<String, String> params) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for playSilence");
            return super.playSilence(durationInMs, queueMode, params);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    String extra;
                    if (params != null && !params.isEmpty() && (extra = params.get("utteranceId")) != null) {
                        this.mCachedParams[11] = extra;
                    }
                    result = this.mITts.playSilence(this.mPackageName, durationInMs, queueMode, this.mCachedParams);
                }
                catch (RemoteException e) {
                    Log.e((String)"TextToSpeech.java - playSilence", (String)"RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (NullPointerException e) {
                    Log.e((String)"TextToSpeech.java - playSilence", (String)"NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (IllegalStateException e) {
                    Log.e((String)"TextToSpeech.java - playSilence", (String)"IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
            }
            catch (Throwable throwable) {}
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSpeaking() {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for isSpeaking");
            return super.isSpeaking();
        }
        Object object = this.mStartLock;
        synchronized (object) {
            block9: {
                if (this.mStarted) break block9;
                return false;
            }
            try {
                return this.mITts.isSpeaking();
            }
            catch (RemoteException e) {
                Log.e((String)"TextToSpeech.java - isSpeaking", (String)"RemoteException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (NullPointerException e) {
                Log.e((String)"TextToSpeech.java - isSpeaking", (String)"NullPointerException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (IllegalStateException e) {
                Log.e((String)"TextToSpeech.java - isSpeaking", (String)"IllegalStateException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stop() {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for stop");
            return super.stop();
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    result = this.mITts.stop(this.mPackageName);
                }
                catch (RemoteException e) {
                    Log.e((String)"TextToSpeech.java - stop", (String)"RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (NullPointerException e) {
                    Log.e((String)"TextToSpeech.java - stop", (String)"NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (IllegalStateException e) {
                    Log.e((String)"TextToSpeech.java - stop", (String)"IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
            }
            catch (Throwable throwable) {}
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setSpeechRate(float speechRate) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech");
            return super.setSpeechRate(speechRate);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result;
            block11: {
                result = -1;
                if (!this.mStarted) {
                    return result;
                }
                try {
                    try {
                        if (!(speechRate > 0.0f)) break block11;
                        int rate = (int)(speechRate * 100.0f);
                        this.mCachedParams[1] = String.valueOf(rate);
                        if (speechRate > 0.0f) {
                            result = 0;
                            break block11;
                        }
                        result = -1;
                    }
                    catch (NullPointerException e) {
                        Log.e((String)"TextToSpeech.java - setSpeechRate", (String)"NullPointerException");
                        e.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                    }
                    catch (IllegalStateException e) {
                        Log.e((String)"TextToSpeech.java - setSpeechRate", (String)"IllegalStateException");
                        e.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                    }
                }
                catch (Throwable throwable) {}
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPitch(float pitch) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech");
            return super.setPitch(pitch);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    if (pitch > 0.0f) {
                        result = this.mITts.setPitch(this.mPackageName, (int)(pitch * 100.0f));
                    }
                }
                catch (RemoteException e) {
                    Log.e((String)"TextToSpeech.java - setPitch", (String)"RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (NullPointerException e) {
                    Log.e((String)"TextToSpeech.java - setPitch", (String)"NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (IllegalStateException e) {
                    Log.e((String)"TextToSpeech.java - setPitch", (String)"IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
            }
            catch (Throwable throwable) {}
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setLanguage(Locale loc) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for setLanguage");
            return super.setLanguage(loc);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -2;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    this.mCachedParams[3] = loc.getISO3Language();
                    this.mCachedParams[5] = loc.getISO3Country();
                    this.mCachedParams[7] = loc.getVariant();
                    result = this.mITts.isLanguageAvailable(this.mCachedParams[3], this.mCachedParams[5], this.mCachedParams[7]);
                }
                catch (RemoteException e) {
                    Log.e((String)"TextToSpeech.java - setLanguage", (String)"RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (NullPointerException e) {
                    Log.e((String)"TextToSpeech.java - setLanguage", (String)"NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (IllegalStateException e) {
                    Log.e((String)"TextToSpeech.java - setLanguage", (String)"IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
            }
            catch (Throwable throwable) {}
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLanguage() {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for getLanguage");
            return super.getLanguage();
        }
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                if (!this.mStarted) {
                    return null;
                }
                String[] locStrings = this.mITts.getLanguage();
                if (locStrings != null && locStrings.length == 3) {
                    return new Locale(locStrings[0], locStrings[1], locStrings[2]);
                }
                return null;
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isLanguageAvailable(Locale loc) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for isLanguageAvailable");
            return super.isLanguageAvailable(loc);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -2;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    result = this.mITts.isLanguageAvailable(loc.getISO3Language(), loc.getISO3Country(), loc.getVariant());
                }
                catch (RemoteException e) {
                    Log.e((String)"TextToSpeech.java - isLanguageAvailable", (String)"RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (NullPointerException e) {
                    Log.e((String)"TextToSpeech.java - isLanguageAvailable", (String)"NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (IllegalStateException e) {
                    Log.e((String)"TextToSpeech.java - isLanguageAvailable", (String)"IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
            }
            catch (Throwable throwable) {}
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int synthesizeToFile(String text, HashMap<String, String> params, String filename) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for synthesizeToFile");
            return super.synthesizeToFile(text, params, filename);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    String extra;
                    if (params != null && !params.isEmpty() && (extra = params.get("utteranceId")) != null) {
                        this.mCachedParams[11] = extra;
                    }
                    if (this.mITts.synthesizeToFile(this.mPackageName, text, this.mCachedParams, filename)) {
                        result = 0;
                    }
                }
                catch (RemoteException e) {
                    Log.e((String)"TextToSpeech.java - synthesizeToFile", (String)"RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (NullPointerException e) {
                    Log.e((String)"TextToSpeech.java - synthesizeToFile", (String)"NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (IllegalStateException e) {
                    Log.e((String)"TextToSpeech.java - synthesizeToFile", (String)"IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
            }
            catch (Throwable throwable) {}
            this.resetCachedParams();
            return result;
        }
    }

    private void resetCachedParams() {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - basic platform TextToSpeech does not support resetCachedParams");
            return;
        }
        this.mCachedParams[9] = String.valueOf(3);
        this.mCachedParams[11] = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setOnUtteranceCompletedListener(final OnUtteranceCompletedListener listener) {
        if (!ttsBetaInstalled) {
            Log.d((String)"TextToSpeechBeta", (String)"TextToSpeechBeta not installed - defaulting to basic platform TextToSpeech for setOnUtteranceCompletedListener");
            TextToSpeech.OnUtteranceCompletedListener platformUtteranceCompletedListener = new TextToSpeech.OnUtteranceCompletedListener(){

                public void onUtteranceCompleted(String utteranceId) {
                    listener.onUtteranceCompleted(utteranceId);
                }
            };
            return super.setOnUtteranceCompletedListener(platformUtteranceCompletedListener);
        }
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            this.mITtscallback = new ITtsCallbackBeta.Stub(){

                @Override
                public void utteranceCompleted(String utteranceId) throws RemoteException {
                    if (listener != null) {
                        listener.onUtteranceCompleted(utteranceId);
                    }
                }
            };
            try {
                try {
                    result = this.mITts.registerCallback(this.mPackageName, this.mITtscallback);
                }
                catch (RemoteException e) {
                    Log.e((String)"TextToSpeech.java - registerCallback", (String)"RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (NullPointerException e) {
                    Log.e((String)"TextToSpeech.java - registerCallback", (String)"NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                catch (IllegalStateException e) {
                    Log.e((String)"TextToSpeech.java - registerCallback", (String)"IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
            }
            catch (Throwable throwable) {}
            return result;
        }
    }

    public static boolean isInstalled(Context ctx) {
        PackageManager pm = ctx.getPackageManager();
        Intent intent = new Intent("com.google.intent.action.START_TTS_SERVICE_BETA");
        intent.addCategory("com.google.intent.category.TTS_BETA");
        ResolveInfo info = pm.resolveService(intent, 0);
        return info != null;
    }

    public class Engine {
        public static final int DEFAULT_RATE = 100;
        public static final int DEFAULT_PITCH = 100;
        public static final int USE_DEFAULTS = 0;
        public static final String DEFAULT_SYNTH = "com.svox.pico";
        public static final int DEFAULT_STREAM = 3;
        public static final int CHECK_VOICE_DATA_PASS = 1;
        public static final int CHECK_VOICE_DATA_FAIL = 0;
        public static final int CHECK_VOICE_DATA_BAD_DATA = -1;
        public static final int CHECK_VOICE_DATA_MISSING_DATA = -2;
        public static final int CHECK_VOICE_DATA_MISSING_VOLUME = -3;
        public static final String ACTION_INSTALL_TTS_DATA = "android.speech.tts.engine.INSTALL_TTS_DATA";
        public static final String ACTION_TTS_DATA_INSTALLED = "android.speech.tts.engine.TTS_DATA_INSTALLED";
        public static final String ACTION_CHECK_TTS_DATA = "android.speech.tts.engine.CHECK_TTS_DATA";
        public static final String EXTRA_VOICE_DATA_ROOT_DIRECTORY = "dataRoot";
        public static final String EXTRA_VOICE_DATA_FILES = "dataFiles";
        public static final String EXTRA_VOICE_DATA_FILES_INFO = "dataFilesInfo";
        public static final String EXTRA_TTS_DATA_INSTALLED = "dataInstalled";
        public static final String KEY_PARAM_RATE = "rate";
        public static final String KEY_PARAM_LANGUAGE = "language";
        public static final String KEY_PARAM_COUNTRY = "country";
        public static final String KEY_PARAM_VARIANT = "variant";
        public static final String KEY_PARAM_STREAM = "streamType";
        public static final String KEY_PARAM_UTTERANCE_ID = "utteranceId";
        protected static final int PARAM_POSITION_RATE = 0;
        protected static final int PARAM_POSITION_LANGUAGE = 2;
        protected static final int PARAM_POSITION_COUNTRY = 4;
        protected static final int PARAM_POSITION_VARIANT = 6;
        protected static final int PARAM_POSITION_STREAM = 8;
        protected static final int PARAM_POSITION_UTTERANCE_ID = 10;
        protected static final int NB_CACHED_PARAMS = 6;
    }

    public static interface OnInitListener {
        public void onInit(int var1, int var2);
    }

    public static interface OnUtteranceCompletedListener {
        public void onUtteranceCompleted(String var1);
    }
}

