// Copyright 2008 Google Inc. All Rights Reserved.

/**
 * AIDL for the Wifi Location Service
 * IWifiLocationService.java is autogenerated from this
 * 
 * @author chaitanyag@google.com (Chaitanya Gharpure)
 */
 
package com.whereabout.wifiservice;

// Declare the interface.
interface IWifiLocationService {
  boolean setRoot(String root, String area);
  boolean isRefreshingData();
  boolean refreshData(String url, in String[] maps, String root, boolean async);
  boolean isReady();
  boolean isScanningWifi();
  void startScanningForLocation(int freq, boolean voting, int samples);
  void stopScanningForLocation(String expectedLocation);
  void startContinuousPositioning(int wifiScanFrequency, long wifiScanInterval);
  void stopContinuousPositioning();
  String[] getAllLocationsByPrefix(String area, String prefix);
  String getXYForLocation(String area, String loc);
  String getLatLonForLocation(String area, String loc);
  String[] getLocations();
  double[] getProximities();
  int[] getXCoordinates();
  int[] getYCoordinates();
  double[] getLatitudes();
  double[] getLongitudes();
  int getX();
  int getY();
  double getLatitude();
  double getLongitude();
  void flushWifiScans();
  boolean isFlushing();
  boolean isLocationUpdated();
  String testAccuracy(String testDir, String file);
}