unit Drucker;

interface

    function  PrintDocument(apphandle:integer; const documentToPrint : string; printerItemIndex :integer; var msg:String) :integer;

implementation


uses shellapi, printers, sysutils, windows;



// > 32 => return = handle
function  PrintDocument(apphandle:integer; const documentToPrint : string; printerItemIndex :integer; var msg:String) :integer;
var       printCommand,
          printerInfo  :string;
          Device, Driver, Port: array[0..255] of Char;
          hDeviceMode: THandle;
          erg : integer;

begin
    msg:= '';

    printCommand := 'printto';
    Printer.PrinterIndex := printerItemIndex;
    Printer.GetPrinter(Device, Driver, Port, hDeviceMode) ;
    printerInfo := Format('"%s" "%s" "%s"', [Device, Driver, Port]) ;

    erg:= ShellExecute( apphandle, PChar(printCommand), PChar(documentToPrint), PChar(printerInfo), nil, SW_HIDE);

    case erg of
        SE_ERR_NOASSOC:      msg:= 'There is no application associated with the given file name extension. This error will also be returned if you attempt to print a file that is not printable.';
        SE_ERR_ACCESSDENIED: msg:= 'The operating system denied access to the specified file.';
        SE_ERR_OOM         : msg:= 'There was not enough memory to complete the operation.';
        //...
    end;

    if erg > 32 then begin
        msg:= 'Ok, printing started.';
    end;

    // attach type of printer to message
    msg:= msg +#10+ 'Printer: '+ printer.Printers[printerItemIndex];

    Result:= erg;
end;


begin
end.