// for MobilePrint
//
Unit Komponenten_Einstellungen;


interface

  uses forms, classes, sysutils, Buttons,
  StdCtrls,
  Dialogs,
  comctrls,
  controls,
  windows
  ;

  PROCEDURE SAVEALLCOMPONENTSTATES(IniFileName :string;  Form :TForm;   App :TApplication);
  function LOADALLCOMPONENTSTATES(IniFileName :string;  Form :TForm;   App :TApplication) :boolean;

implementation



//////////////////////////////////////////////////////
//  Text, checkcox, Position... save most components
//
PROCEDURE SAVEALLCOMPONENTSTATES(IniFileName :string;  Form :TForm;  App :TApplication);
VAR   i:integer;  comp:TCOMPONENT;   s, save_text:string; t:text;
BEGIN
  assignfile(t, {s +} IniFileName);
  {$I-} Rewrite(t); {$I+}
  if IoResult <> 0 then Exit;

  {$I-}
  with form do begin

    for i:= 0 to componentcount-1 do begin
      comp:= Components[i];
      Save_text:= '<'#255#255#255'>';  // place holder

      if comp is TSpeedButton then
        with comp as TSpeedButton do
          if down then save_text:= 'TRUE' else save_text:= 'FALSE';

      if comp is TCheckBox then
        with comp as TCheckBox do
          if checked then save_text:= 'TRUE' else save_text:= 'FALSE';

      if comp is TRadioButton then
        with comp as TRadioButton do
          if Checked then save_text:= 'TRUE' else save_text:= 'FALSE';

      if comp is TEdit then
        with comp as TEdit do
          save_text:= Text;

      if comp is TScrollBar then
        with comp as TScrollBar do
          save_text:= InttoStr(Position);

      if comp is TTrackBar then
        with comp as TTrackBar do
          save_text:= InttoStr(Position);

      if comp is TComboBox then
        with comp as TComboBox do
          save_text:= text;

      // save...
      Writeln(t, save_text);
    end;

  end;
  {$I+}
  if ioresult<>0 then messagebox(0,'Fehler beim Speichern der Einstellungen','Fehler',mb_ok);

  Closefile(t);
END;



//////////////////////////////////////////////////////
//  Text, Checkbox, Position... load most components
//
function LOADALLCOMPONENTSTATES(IniFileName :string;  Form :TForm; App :TApplication) :boolean;
VAR   i, zahl:integer;  comp:TCOMPONENT;   s, lade_text:string; t:text;
BEGIN
  result:= true;
  assignfile(t, {s +} IniFileName);
  {$I-} Reset(t); {$I+}
  if IoResult <> 0 then Exit;

  {$I-}
 try

  with form do begin
    for i:= 0 to componentcount-1 do begin
      comp:= Components[i];
      Readln(t, lade_text);

      if lade_text <> '<'#255#255#255'>' then Begin

        if comp is TSpeedButton then
          with comp as TSpeedButton do
            if lade_text = 'TRUE' then down:= true else down:= false;

        if comp is TCheckBox then
          with comp as TCheckBox do begin
            if lade_text <>'TRUE' then checked:= true else checked:= false;
            if lade_text = 'TRUE' then checked:= true else checked:= false;
          end;

        if comp is TRadioButton then
          with comp as TRadioButton do
            if lade_text = 'TRUE' then checked:= true else checked:= false;

        if comp is TEdit then
          with comp as TEdit do
            Text:= lade_text;

        if comp is TScrollBar then
          with comp as TScrollBar do
            position:= Strtoint(lade_text);

        if comp is TTrackBar then
          with comp as TTrackBar do
            position:= Strtoint(lade_text);

        if comp is TComboBox then
          with comp as TComboBox do
            Text:= lade_text;

      End;  // if lade_text <> '<'#255#255#255'>'...

    end;


  end;
  {$I+}
  if ioresult<>0 then result:= false;

 except
    result:= false;
 end;

  Closefile(t);
END;






begin
end.
