unit mobileprint_Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    CBDrucker: TComboBox;
    SpeedButton1: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    m: TMemo;
    SpeedButton2: TSpeedButton;
    cbmin: TCheckBox;
    Button1: TButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label5: TLabel;
    Button5: TButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Edit1Change(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button_print_Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


uses printers, drucker, SpecFTPServer, Komponenten_Einstellungen,
      IdTCPConnection,
      IdSocketHandle
;



Const
       inidatei : String = 'mobileprint.ini';

Var
       SERVER : TFTPServer;
       DIR    : String;            // Program-dir




// print a file to the printer that is selected in the gui
procedure Ausdrucken(Datei :String);
var       printerItemIndex :Integer;
          msg:string;
          status,oo :integer;
          T:Textfile;
begin
    printerItemIndex:= form1.cbDrucker.ItemIndex;
    form1.m.lines.add('trying to print "'+ datei +'" with printer '+ inttostr(printerItemIndex) +' '+ form1.CBDrucker.Items[form1.cbDrucker.ItemIndex]);
    status:= PrintDocument(application.Handle, Datei, printerItemIndex, msg);
    form1.m.lines.add('Return-Msg: '+  msg);

    // create response file for android-application
    assignfile(T, datei + '.printinfo');
    {$I-} rewrite(T); {$I+}
    if ioresult = 0 then begin
        writeln(T, msg);
        closefile(T);
        form1.m.lines.add('Response file written: '+  datei + '.printinfo');
    end;

end;



//--------------------

type waitForFile = class(TThread)             // wait for file to be ready-Thread
public
       constructor Create(CreateSuspended:boolean; datei_:string);
       procedure Execute; override;
       private
        datei :string;
end;


constructor waitForFile.Create(CreateSuspended:boolean; datei_:string);
begin
    inherited Create(CreateSuspended);
    datei:= datei_;
end;


Procedure waitForFile.Execute;

    function testeobdateisichoeffnenlaesst :boolean;
    var   f:file;
    begin
        result:= false;
        // file is still blocked from sertver-thread. wait until file can be accessed
       {$I-}
        assignfile(f, datei);
        reset(f,1);
        closefile(f);
        {$I+}
        if ioresult = 0 then result:= true;
    end;

var     i:integer; L:longint;  timeout:boolean;
begin
    L:= gettickcount;
    timeout:= false;
    repeat
        sleep(64);
        timeout:= (GetTickCount-L)>30000;
    until (Terminated) or (testeobdateisichoeffnenlaesst=true) or (timeout);

    // wait a bit
    i:= 0;
    repeat
        inc(i);
        sleep(100);
        Application.ProcessMessages;
    until i>5; // 0.5 sec

    Application.ProcessMessages;

    if timeout = false then begin
        form1.m.Lines.Add('File received, start printing...');
        Ausdrucken( datei );            // FTP-Root voranstellen, sonst sucht er in akt-dir
    end else begin
        form1.m.Lines.Add('Error receiving file. Timeout after 30 seconds...');
    end;

    FreeOnTerminate:= TRUE;            // beende dich selbst, wenn fertig...
end;

//----------------------------



procedure file_upload_Finished;
var       datei :string;     sr:Tsearchrec;  f:file;
          c:string[6];   warten:boolean;
begin
    datei:= SERVER.CALLBACK_lastuploadedFile;
    form1.m.lines.add( 'printing: '+ datei);

    // file is still blocked from sertver-thread. wait until file can be accessed
    // then print it...
    waitForFile.Create(false, datei);

    form1.Repaint;
end;


procedure getPrinters;     // update printerlist in combobox
begin
    form1.cbDrucker.Items.Assign(printer.Printers);
    //pre-select the default / active printer
    form1.cbDrucker.ItemIndex := printer.PrinterIndex;
end;


procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
    getPrinters;
end;


procedure Restart_Server(port:integer);
begin
    if SERVER <> nil then begin
        try
        SERVER.free;
        except
        end;
    end;

    form1.m.Lines.Add('server stopped.');

    SERVER:= TFTPServer.Create(port);
    SET_CALLBACK_FILEUPLOADFINISHED(@file_upload_Finished);

    form1.m.Lines.Add('server running on port '+ inttostr(port));
end;


procedure TForm1.FormCreate(Sender: TObject);
var       ok: Boolean;    ev :TNotifyEvent;
begin
    DIR:= extractfilepath(Application.ExeName);
    getPrinters;

    ev:= Edit1Change;
    Edit1.OnChange:= nil;

    ok:= LOADALLCOMPONENTSTATES(inidatei, form1, Application);

    if not(ok) then begin
        m.Lines.Add('Error loading settings...')
    end;

    if cbmin.Checked then showwindow(Form1.Handle, SW_MINIMIZE);

    try
        Edit1.OnChange:= ev;
        Edit1Change(Sender);                                         // Restart_Server(port);
    except
        on EIdCanNotBindPortInRange do begin
             m.Lines.Add('Port already in use...')
        end;
    end;

    CBDrucker.ItemIndex:= CBDrucker.Items.IndexOf(CBDrucker.Text);   // set correct printer-index
end;


procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
    try
    if SERVER <> nil then SERVER.free;                               // stop ftp-server
    except
    end;
end;



var  zuletzt :String = '2000';
//
procedure TForm1.Edit1Change(Sender: TObject);
var       port:integer;
begin
    if Edit1.Text = '' then Edit1.Text:= zuletzt;

    try
        port:= StrToInt(Edit1.Text);
    except
        Edit1.Text:= zuletzt;
        exit;
    end;

    if NOT( (port>0) and (port<65536) ) then begin
        Edit1.Text:= zuletzt;
    end;


    if port=0 then begin            // if choosen port was already open, this value can get 0!
        m.lines.add('Please try another port.');
        try
            port:= StrToInt(zuletzt);
        except
        end;
    end;

    Restart_Server(port);
end;


procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
    zuletzt:= Edit1.Text;
    if NOT(key in ['0'..'9',#8]) then key:= #0;
end;


procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    SAVEALLCOMPONENTSTATES(inidatei, form1, Application);
end;


var wartesekunden:integer = 5;
procedure TForm1.Button_Print_click(Sender: TObject);
var       dat, dateiendung:string;
begin
    dateiendung:= TButton(sender).Caption;
    dat:= DIR + 'PrinterTest' + dateiendung;

    if FileExists(dat) = false then m.Lines.Add('Test file for printing not found in program directory. Please create a "'+ dateiendung +'" file called "'+ dat +'".');
    Ausdrucken( dat );
end;


procedure TForm1.Button5Click(Sender: TObject);
begin
    m.Lines.Clear;
end;

end.
