package com.gs.mobileprint;

import java.io.*;
import java.net.*;
import java.util.Enumeration;
import android.app.Activity;
import android.content.*;
import android.os.*;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.*;

import org.apache.commons.net.ftp.*;

import com.gs.mobileprint.R;
import com.h3r3t1c.filechooser.FileChooser;




public class PrintActivity extends Activity {
		
	static private Button buttonChooseFile = null;
	static private Button buttonPrint = null;
    
    static EditText editdatei;										// chosen file
    static EditText log;
	static EditText editserver;
	static EditText editport;
	
   
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        // to show the icon in the title
        requestWindowFeature(Window.FEATURE_LEFT_ICON); 
        
        setContentView(R.layout.print_view);

        // to show the icon in the title
        getWindow().setFeatureDrawableResource(Window.FEATURE_LEFT_ICON, R.drawable.mp);
                   
   
        log = (EditText) findViewById(R.id.editlog);

		// make EditText(log) readOnly
        log.setKeyListener(null);	

        
        editdatei = (EditText) findViewById(R.id.filename);
        editserver = (EditText) findViewById(R.id.editserver);
        editport   = (EditText) findViewById(R.id.editport);
        
        
        load_Settings();		// last state
        
        
        // --------------------------
        buttonChooseFile = (Button) findViewById(R.id.button1);

        buttonChooseFile.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent( /*FirstActivity.this*/ PrintActivity.this, FileChooser.class);
			    startActivityForResult( intent, 1);  // 1: wenn man verschiedene rckgaben in 'onActivityResult' wnscht
			}
		});
        // -------------------------

        
        buttonPrint = (Button) findViewById(R.id.buttonprint);

        buttonPrint.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
					
				String datei = editdatei.getText().toString();
	        	File  sourcefile = new File(datei);
	        	
	        	String strserver   = ((EditText) findViewById(R.id.editserver)).getText().toString();
				String strport     = ((EditText) findViewById(R.id.editport  )).getText().toString();
				String strdestfile = sourcefile.getName().replaceAll(" ", "_");
					
		    	int port = -1;
				try {
					port = Integer.parseInt(strport);
				} catch (NumberFormatException e1) {
					Toast.makeText(null, "port-number is wrong [1..65535].", Toast.LENGTH_LONG).show();
					return;
				}
				
	
				PrintTask task = new PrintTask();
				task.setParameter(strserver, port, strdestfile, sourcefile);  // pass parameters in an easy way
	        	task.execute(0);
			}

		});
        
    }


    // if a file was chosen, then the file will be returned here
    //
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    	//switch(requestCode) { ...  // if there are multiple replies
    
    	if (resultCode == RESULT_OK) {
    		String name = data.getStringExtra("file");
    		editdatei.setText(name);
    	}
    }   
    
    
    
    @Override
    protected void onResume() {
        super.onResume();
    }


    
    
    // -------------- AsyncTask ---------------------
    
    private class PrintTask extends AsyncTask<Integer, Integer, Long> {
    	
    	boolean printOk = false;
    	
    	private String ftpServer           = "127.0.0.1";
    	private int    ftpPort             = 2000;
    	private String destinationFileName = "nil";
    	File    source                     = null;
    	
    	private String msg = "";					// text, that should be displayed
    	
    	protected void setParameter(String _ftpserver, int _ftpport, String _destinationfilename, File _source ) {
    		ftpServer           = _ftpserver;
    		ftpPort             = _ftpport;
    		destinationFileName = _destinationfilename;
    		source 	            = _source;
    	}
    	
    	public String getLocalIpAddress() {
    	    try {
    	        for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements();) {
    	            NetworkInterface intf = en.nextElement();
    	            for (Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses(); enumIpAddr.hasMoreElements();) {
    	                InetAddress inetAddress = enumIpAddr.nextElement();
    	                if (!inetAddress.isLoopbackAddress()) {
    	                    return inetAddress.getHostAddress().toString();
    	                }
    	            }
    	        }
    	    } catch (SocketException ex) {
    	        // not needed
    	    }
    	    return null;
    	}

    	
    	private void mLog (String s) {
    		msg = s;
        	publishProgress(0);										// 0 => print text;   [-1, clear]
        	while (msg.length()>0) {								// wait until it's printed...
        		try { Thread.sleep(16); } catch (Exception e) {}
        	}
    	}
    	
    	
    	// Upload to server, then server will start printing and return the result
    	//
        protected Long doInBackground(Integer... iii) {

        	msg = "clear";
        	publishProgress(-1);									// Clear Text
        	mLog("\n");												// make sure, Text is cleared -> while
        	
        	mLog("your IP: "+ getLocalIpAddress()+ "\n");
        	mLog("connecting to "+ ftpServer +"...\n");
                	
        	
        	
        	FTPClient con = new FTPClient();
        	
        		con.setConnectTimeout(3000); 						// x seconds Timeout
        		try {
    				con.connect(ftpServer, ftpPort);
    				
    				mLog("logging in... ");
    				
    				if (con.login("anonymous", "password"))   {		// user/pw doesn't matter for this ftp, using defaults anyway
    				    mLog("Ok.\n");
    					con.enterLocalPassiveMode();				// important!
    				    con.setFileType(FTP.BINARY_FILE_TYPE);		// Binr !!
    					  
    				    //-------------- delete old infofile if exists --------------------
    				    mLog("removing old info-file... ");
    			    	String infofile = destinationFileName + ".printinfo"; 	        
    					try {
    						con.deleteFile(infofile);				// delete old info-file 
    					} catch (Exception e) {	}					// no messages...
    					mLog("Ok.\n");								// that should be fine...
    				    //-----------------------------------------------------------------
    				    
    					mLog("upload file... ");
    				    BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
    				    boolean result = con.storeFile(destinationFileName, in);
    				    in.close();
    				    if (result==true) { 
    				    	mLog("Ok.\n");
    				    } else {
    				    	mLog("error\n");
    				    	mLog("Status: " + con.getStatus() +"\n");
    				    }
    				    
    				    //--------------- search info file some seconds... if ok, read info file----------
    				    // the server is returning its status via this file
    				    mLog("waiting for status...\n");
    				    boolean info_replied = false;
    				    String info_msg      = "";
    				    for (int wait=0; wait<15; wait++) {
    					    try { Thread.sleep(1000); } catch(Exception e) {};		// wait a bit...
    		    	        ByteArrayOutputStream infostream = new ByteArrayOutputStream();
    		    	        info_replied = con.retrieveFile(infofile, infostream); 
    		    	        info_msg     = infostream.toString();
    		    	        if (info_replied) { break; }
    					}
    				    if (info_replied) {
    				    	info_msg = info_msg.replace("\r", "");           // remove windows #13 from server-reply
    				    	//log.append("\nServer replied: "+ info_msg);
    				    	mLog("Server replied: "+ info_msg +"\n");
    				    	String strState = info_msg.substring(0,2).toUpperCase();  // first two chars of server-reply-msg. if that's "Ok" => printing started
    				    	if (strState.equals("OK")) { printOk = true; }   // server replied ok ?
    				    } else {
    				    	//log.append("\nServer did not reply. Maybe there was an error printing the file.");
    				    	mLog("Server did not reply. Maybe there was an error printing the file.\n");
    				    }
    				    //------------------------------------------------------------------------------
    				    
    				}
    				
    			} catch (SocketException e) {
    				mLog("\nupload error: SocketException:\n"+e.toString()+"\n"+ e.getMessage() +"\n"+ e.getLocalizedMessage());
    			} catch (FileNotFoundException e) {
    				mLog("\nupload error: FileNotFoundException:\n"+e.toString()+"\n"+ e.getMessage() +"\n"+ e.getLocalizedMessage());
    			} catch (IOException e) {
    				mLog("\nupload error: IOException:\n"+e.toString()+"\n"+ e.getMessage() +"\n"+ e.getLocalizedMessage());
    			}
        	

        	try {
        	    con.logout();
        	    con.disconnect();
        	} catch (Exception e) {
        	    //log.append("\nerror logging out=" +e.toString()+"\n");
        	}    	
        	

        	return (long)0;
        }

        // Print Log to TextView;
        // if Parameter = -1 then clear, else print String in "msg"
        protected void onProgressUpdate(Integer... clear) {
        	if (clear[0]==-1) {
        		log.setText("");
        	} else {
        		log.append(msg);
        	}
        	msg = "";
        }

        @Override
		protected void onPreExecute() {	
        	buttonPrint.setEnabled(false);	
    	}
    	
        
        protected void onPostExecute(Long result) {
        	if (printOk) {
        		log.append("\nprint job started.");
        	} else {
        		log.append("\nplease check, if there were errors.");
        	}
        	
        	buttonPrint.setEnabled(true);
        }
    }
    
    
    
   //---------Setings-------------------------------------------
   
    private void load_Settings() {
        SharedPreferences settings = getPreferences(0);
        editserver.setText( settings.getString("server", "192.168.0.1") );
        editport.setText  ( settings.getString("port",   "2000") );
    }
    
    private void save_Settings() {
    	SharedPreferences settings = getPreferences(0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString("server", editserver.getText().toString());
        editor.putString("port",   editport.getText().toString());
        editor.commit();					// save
    }
   
    // ----------------- Auto-Save settings -----------------
    //                   if Destroy / pause / stop
    @Override
    protected void onDestroy() {
        super.onDestroy();
        save_Settings();
    }
    @Override
    protected void onPause() {
        super.onPause();
        save_Settings();
    }
    @Override
    protected void onStop() {
        super.onStop();
        save_Settings();
    }

}
