// adapted version

package com.h3r3t1c.filechooser;

import java.io.File;
import java.util.*;
import com.gs.mobileprint.R;
import android.app.*;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.*;


public class FileChooser extends ListActivity {
	
    private File currentDir;
    private FileArrayAdapter adapter;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //currentDir = new File("/sdcard/");		// If you want to start from sdcard (xcx)
        currentDir = new File("/");					
        fill(currentDir);
    }
    private void fill(File f)
    {
    	File[]dirs = f.listFiles();
		 this.setTitle("Dir "+f.getAbsoluteFile());
		 List<Option>dir = new ArrayList<Option>();
		 List<Option>fls = new ArrayList<Option>();
		 try{
			 for(File ff: dirs)
			 {
				if(ff.isDirectory())
					dir.add(new Option(ff.getName(),"<DIR>",ff.getAbsolutePath()));
				else
				{
					fls.add(new Option(ff.getName(),ff.length() +" Bytes",ff.getAbsolutePath()));
				}
			 }
		 }catch(Exception e)
		 {
			 
		 }
		 Collections.sort(dir);
		 Collections.sort(fls);
		 dir.addAll(fls);
		 if(!f.getName().equalsIgnoreCase("sdcard"))
			 dir.add(0,new Option("..","<DIR UP>",f.getParent()));
		 adapter = new FileArrayAdapter(FileChooser.this,R.layout.file_view,dir);
		 this.setListAdapter(adapter);
    }
    
    
    @Override
	protected void onListItemClick(ListView l, View v, int position, long id) {
		
		super.onListItemClick(l, v, position, id);
		Option o = adapter.getItem(position);
		if(o.getData().equals("<DIR>")||o.getData().equalsIgnoreCase("<DIR UP>")){
				currentDir = new File(o.getPath());
				fill(currentDir);
		}
		else
		{
			onFileClick(o);
		}
	}
    
    private void onFileClick(Option o)
    {
    	// return chosen file
    	//
    	Intent returnIntent = new Intent();
        returnIntent.putExtra("file", o.getPath() );    // "file" is used as id
        setResult(RESULT_OK, returnIntent);             // set result, so that "on.." from caller can receive it, when finish() has finished       
        finish();										// important to get back a result
    }
}