package com.hardcodecoder.pulsemusic.glide;

import android.content.Context;
import android.net.Uri;

import androidx.annotation.NonNull;

import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.data.DataFetcher;
import com.hardcodecoder.pulsemusic.utils.ImageUtil;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class MediaArtFetcher implements DataFetcher<InputStream> {

    private final Context mContext;
    private final MediaArtwork mArtwork;
    private final boolean mIgnoreMediaStore;
    private InputStream stream;

    public MediaArtFetcher(@NonNull Context context, @NonNull MediaArtwork artwork, boolean ignoreMediaStore) {
        mContext = context;
        mArtwork = artwork;
        mIgnoreMediaStore = ignoreMediaStore;
    }

    @Override
    public void loadData(@NonNull Priority priority, @NonNull DataCallback<? super InputStream> callback) {
        try {
            if (mIgnoreMediaStore)
                stream = ImageUtil.getEmbeddedArtwork(mContext, Uri.parse(mArtwork.getMediaUri()));
            else
                stream = mContext.getContentResolver().openInputStream(Uri.parse(mArtwork.getArtworkUri()));
            callback.onDataReady(stream);
        } catch (FileNotFoundException e) {
            callback.onLoadFailed(e);
        }
    }

    @Override
    public void cleanup() {
        if (null == stream) return;
        try {
            stream.close();
        } catch (IOException ignore) {
            // can't help here
        }
    }

    @Override
    public void cancel() {
    }

    @NonNull
    @Override
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @NonNull
    @Override
    public DataSource getDataSource() {
        return DataSource.LOCAL;
    }
}