package com.hardcodecoder.pulsemusic.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.io.Serializable;

public class AlbumTransitionModel implements Serializable {

    private final String mAlbumTitle;
    private final String mMediaSourceUri;
    private final String mAlbumArtUri;
    private final long mAlbumId;

    public AlbumTransitionModel(@NonNull String albumTitle, @Nullable String mediaSourceUri, @NonNull String albumArtUri, long albumId) {
        mAlbumTitle = albumTitle;
        mMediaSourceUri = mediaSourceUri;
        mAlbumArtUri = albumArtUri;
        mAlbumId = albumId;
    }

    public String getAlbumTitle() {
        return mAlbumTitle;
    }

    public String getMediaSourceUri() {
        return mMediaSourceUri;
    }

    public String getAlbumArtUri() {
        return mAlbumArtUri;
    }

    public long getAlbumId() {
        return mAlbumId;
    }

    @NonNull
    @Override
    public String toString() {
        return mMediaSourceUri + ":" + mAlbumArtUri + ":" + mAlbumId;
    }
}