package com.hardcodecoder.pulsemusic.model;

import android.content.ContentUris;
import android.net.Uri;
import android.provider.MediaStore;

import androidx.annotation.NonNull;

public class AudioFileModel {

    private final int mId;
    private final String mDisplayName;
    private final Uri mAudioUri;
    private final String mAbsolutePath;
    private final String mMineType;
    private final TagModel mTagModel;

    public AudioFileModel(int id,
                          @NonNull String displayName,
                          @NonNull String absolutePath,
                          @NonNull String mimeType,
                          @NonNull TagModel tagModel) {
        mId = id;
        mDisplayName = displayName;
        mAudioUri = ContentUris.withAppendedId(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, id);
        mAbsolutePath = absolutePath;
        mMineType = mimeType;
        mTagModel = tagModel;
    }

    public int getId() {
        return mId;
    }

    @NonNull
    public String getDisplayName() {
        return mDisplayName;
    }

    @NonNull
    public Uri getAudioUri() {
        return mAudioUri;
    }

    @NonNull
    public String getAbsolutePath() {
        return mAbsolutePath;
    }

    @NonNull
    public String getMineType() {
        return mMineType;
    }

    @NonNull
    public TagModel getTagModel() {
        return mTagModel;
    }

    @NonNull
    @Override
    public String toString() {
        return "ID: " + mId + "\n" +
                "Display name: " + mDisplayName + "\n" +
                "Display name: " + mDisplayName + "\n" +
                "Uri: " + mAudioUri + "\n" +
                "Absolute path: " + mAbsolutePath + "\n" +
                "Mime type: " + mMineType + "\n" +
                "Tag model: " + mTagModel;
    }
}