/* UtilServices.java -- various utility routines.
   Copyright (C) 2001, 2002, 2003, 2006 Free Software Foundation, Inc.

This file is a part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version.  */

package com.hobbyone.HashDroid;

/**
 * <p>
 * A collection of utility methods used throughout this project.
 * </p>
 */
public class UtilServices {

	// Constants and variables
	// -------------------------------------------------------------------------

	// Hex charset
	private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

	// Constructor(s)
	// -------------------------------------------------------------------------

	/** Trivial constructor to enforce Singleton pattern. */
	private UtilServices() {
		super();
	}

	// Class methods
	// -------------------------------------------------------------------------

	/**
	 * <p>
	 * Returns a string of hexadecimal digits from a byte array. Each byte is
	 * converted to 2 hex symbols; zero(es) included.
	 * </p>
	 * 
	 * <p>
	 * This method calls the method with same name and three arguments as:
	 * </p>
	 * 
	 * <pre>
	 * toString(ba, 0, ba.length);
	 * </pre>
	 * 
	 * @param ba
	 *            the byte array to convert.
	 * @return a string of hexadecimal characters (two for each byte)
	 *         representing the designated input byte array.
	 */
	public static String toString(byte[] ba) {
		return toString(ba, 0, ba.length);
	}

	/**
	 * <p>
	 * Returns a string of hexadecimal digits from a byte array, starting at
	 * <code>offset</code> and consisting of <code>length</code> bytes. Each
	 * byte is converted to 2 hex symbols; zero(es) included.
	 * </p>
	 * 
	 * @param ba
	 *            the byte array to convert.
	 * @param offset
	 *            the index from which to start considering the bytes to
	 *            convert.
	 * @param length
	 *            the count of bytes, starting from the designated offset to
	 *            convert.
	 * @return a string of hexadecimal characters (two for each byte)
	 *         representing the designated input byte sub-array.
	 */
	public static final String toString(byte[] ba, int offset, int length) {
		char[] buf = new char[length * 2];
		for (int i = 0, j = 0, k; i < length;) {
			k = ba[offset + i++];
			buf[j++] = HEX_DIGITS[(k >>> 4) & 0x0F];
			buf[j++] = HEX_DIGITS[k & 0x0F];
		}
		return new String(buf);
	}
}
