/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.osmdroid.ResourceProxy;
import org.osmdroid.views.util.constants.MapViewConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceProxyImpl
implements ResourceProxy,
MapViewConstants {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResourceProxyImpl.class);
    private DisplayMetrics mDisplayMetrics;

    public DefaultResourceProxyImpl(Context pContext) {
        if (pContext != null) {
            this.mDisplayMetrics = pContext.getResources().getDisplayMetrics();
        }
    }

    @Override
    public String getString(ResourceProxy.string pResId) {
        switch (pResId) {
            case osmarender: {
                return "Osmarender";
            }
            case mapnik: {
                return "Mapnik";
            }
            case cyclemap: {
                return "Cycle Map";
            }
            case public_transport: {
                return "Public transport";
            }
            case base: {
                return "OSM base layer";
            }
            case topo: {
                return "Topographic";
            }
            case hills: {
                return "Hills";
            }
            case cloudmade_standard: {
                return "CloudMade (Standard tiles)";
            }
            case cloudmade_small: {
                return "CloudMade (small tiles)";
            }
            case mapquest_osm: {
                return "Mapquest";
            }
            case fiets_nl: {
                return "OpenFietsKaart overlay";
            }
            case base_nl: {
                return "Netherlands base overlay";
            }
            case roads_nl: {
                return "Netherlands roads overlay";
            }
            case unknown: {
                return "Unknown";
            }
            case format_distance_meters: {
                return "%s m";
            }
            case format_distance_kilometers: {
                return "%s km";
            }
            case format_distance_miles: {
                return "%s mi";
            }
            case format_distance_nautical_miles: {
                return "%s nm";
            }
            case format_distance_feet: {
                return "%s ft";
            }
            case online_mode: {
                return "Online mode";
            }
            case offline_mode: {
                return "Offline mode";
            }
            case my_location: {
                return "My location";
            }
            case compass: {
                return "Compass";
            }
            case map_mode: {
                return "Map mode";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getString(ResourceProxy.string pResId, Object ... formatArgs) {
        return String.format(this.getString(pResId), formatArgs);
    }

    @Override
    public Bitmap getBitmap(ResourceProxy.bitmap pResId) {
        InputStream is = null;
        try {
            String resName = pResId.name() + ".png";
            is = this.getClass().getResourceAsStream(resName);
            if (is == null) {
                throw new IllegalArgumentException("Resource not found: " + resName);
            }
            BitmapFactory.Options options = null;
            if (this.mDisplayMetrics != null) {
                options = this.getBitmapOptions();
            }
            Bitmap bitmap2 = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            return bitmap2;
        }
        catch (OutOfMemoryError e) {
            logger.error("OutOfMemoryError getting bitmap resource: " + (Object)((Object)pResId));
            System.gc();
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private BitmapFactory.Options getBitmapOptions() {
        try {
            Field density = DisplayMetrics.class.getDeclaredField("DENSITY_DEFAULT");
            Field inDensity = BitmapFactory.Options.class.getDeclaredField("inDensity");
            Field inTargetDensity = BitmapFactory.Options.class.getDeclaredField("inTargetDensity");
            Field targetDensity = DisplayMetrics.class.getDeclaredField("densityDpi");
            BitmapFactory.Options options = new BitmapFactory.Options();
            inDensity.setInt(options, density.getInt(null));
            inTargetDensity.setInt(options, targetDensity.getInt(this.mDisplayMetrics));
            return options;
        }
        catch (IllegalAccessException ex) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Drawable getDrawable(ResourceProxy.bitmap pResId) {
        return new BitmapDrawable(this.getBitmap(pResId));
    }

    @Override
    public float getDisplayMetricsDensity() {
        return this.mDisplayMetrics.density;
    }
}

