/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osmdroid.tileprovider.LRUMapTileCache;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;

public final class MapTileCache
implements OpenStreetMapTileProviderConstants {
    protected LRUMapTileCache mCachedTiles;
    private final ReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();

    public MapTileCache() {
        this(9);
    }

    public MapTileCache(int aMaximumCacheSize) {
        this.mCachedTiles = new LRUMapTileCache(aMaximumCacheSize);
    }

    public void ensureCapacity(int aCapacity) {
        this.mReadWriteLock.readLock().lock();
        this.mCachedTiles.ensureCapacity(aCapacity);
        this.mReadWriteLock.readLock().unlock();
    }

    public Drawable getMapTile(MapTile aTile) {
        this.mReadWriteLock.readLock().lock();
        Drawable result = (Drawable)this.mCachedTiles.get(aTile);
        this.mReadWriteLock.readLock().unlock();
        return result;
    }

    public void putTile(MapTile aTile, Drawable aDrawable) {
        if (aDrawable != null) {
            this.mReadWriteLock.writeLock().lock();
            this.mCachedTiles.put(aTile, aDrawable);
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    public boolean containsTile(MapTile aTile) {
        this.mReadWriteLock.readLock().lock();
        boolean result = this.mCachedTiles.containsKey(aTile);
        this.mReadWriteLock.readLock().unlock();
        return result;
    }

    public void clear() {
        this.mReadWriteLock.writeLock().lock();
        this.mCachedTiles.clear();
        this.mReadWriteLock.writeLock().unlock();
    }
}

