/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.database.sqlite.SQLiteException;
import java.io.File;
import java.io.IOException;
import org.osmdroid.tileprovider.modules.DatabaseFileArchive;
import org.osmdroid.tileprovider.modules.GEMFFileArchive;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.modules.ZipFileArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveFileFactory {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveFileFactory.class);

    public static IArchiveFile getArchiveFile(File pFile) {
        if (pFile.getName().endsWith(".zip")) {
            try {
                return ZipFileArchive.getZipFileArchive(pFile);
            }
            catch (IOException e) {
                logger.error("Error opening ZIP file", (Throwable)e);
            }
        }
        if (pFile.getName().endsWith(".sqlite")) {
            try {
                return DatabaseFileArchive.getDatabaseFileArchive(pFile);
            }
            catch (SQLiteException e) {
                logger.error("Error opening SQL file", (Throwable)e);
            }
        }
        if (pFile.getName().endsWith(".gemf")) {
            try {
                return GEMFFileArchive.getGEMFFileArchive(pFile);
            }
            catch (IOException e) {
                logger.error("Error opening GEMF file", (Throwable)e);
            }
        }
        return null;
    }
}

