/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.ArchiveFileFactory;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTileFileArchiveProvider
extends MapTileFileStorageProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(MapTileFileArchiveProvider.class);
    private final ArrayList<IArchiveFile> mArchiveFiles = new ArrayList();
    protected ITileSource mTileSource;

    public MapTileFileArchiveProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource) {
        super(pRegisterReceiver, 8, 40);
        this.mTileSource = pTileSource;
        this.findArchiveFiles();
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "File Archive Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "filearchive";
    }

    @Override
    protected Runnable getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        return this.mTileSource != null ? this.mTileSource.getMinimumZoomLevel() : 22;
    }

    @Override
    public int getMaximumZoomLevel() {
        return this.mTileSource != null ? this.mTileSource.getMaximumZoomLevel() : 0;
    }

    @Override
    protected void onMediaMounted() {
        this.findArchiveFiles();
    }

    @Override
    protected void onMediaUnmounted() {
        this.findArchiveFiles();
    }

    @Override
    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource = pTileSource;
    }

    private void findArchiveFiles() {
        this.mArchiveFiles.clear();
        if (!this.getSdCardAvailable()) {
            return;
        }
        File[] files = OSMDROID_PATH.listFiles();
        if (files != null) {
            for (File file : files) {
                IArchiveFile archiveFile = ArchiveFileFactory.getArchiveFile(file);
                if (archiveFile == null) continue;
                this.mArchiveFiles.add(archiveFile);
            }
        }
    }

    private synchronized InputStream getInputStream(MapTile pTile) {
        for (IArchiveFile archiveFile : this.mArchiveFiles) {
            InputStream in = archiveFile.getInputStream(this.mTileSource, pTile);
            if (in == null) continue;
            return in;
        }
        return null;
    }

    private class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        private TileLoader() {
            super(MapTileFileArchiveProvider.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Drawable loadTile(MapTileRequestState pState) {
            if (MapTileFileArchiveProvider.this.mTileSource == null) {
                return null;
            }
            MapTile pTile = pState.getMapTile();
            if (!MapTileFileArchiveProvider.this.getSdCardAvailable()) {
                return null;
            }
            InputStream inputStream = null;
            try {
                inputStream = MapTileFileArchiveProvider.this.getInputStream(pTile);
                if (inputStream != null) {
                    Drawable drawable;
                    Drawable drawable2 = drawable = MapTileFileArchiveProvider.this.mTileSource.getDrawable(inputStream);
                    return drawable2;
                }
            }
            catch (Throwable e) {
                logger.error("Error loading tile", e);
            }
            finally {
                if (inputStream != null) {
                    StreamUtils.closeStream(inputStream);
                }
            }
            return null;
        }
    }
}

