/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileWriter
implements IFilesystemCache,
OpenStreetMapTileProviderConstants {
    private static final Logger logger = LoggerFactory.getLogger(TileWriter.class);
    private static long mUsedCacheSpace;

    public TileWriter() {
        Thread t = new Thread(){

            @Override
            public void run() {
                TileWriter.this.calculateDirectorySize(OpenStreetMapTileProviderConstants.TILE_PATH_BASE);
                if (mUsedCacheSpace > 629145600L) {
                    TileWriter.this.cutCurrentCache();
                }
            }
        };
        t.setPriority(1);
        t.start();
    }

    public static long getUsedCacheSpace() {
        return mUsedCacheSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean saveFile(ITileSource pTileSource, MapTile pTile, InputStream pStream) {
        File file = new File(TILE_PATH_BASE, pTileSource.getTileRelativeFilenameString(pTile) + ".tile");
        File parent = file.getParentFile();
        if (!parent.exists() && !this.createFolderAndCheckIfExists(parent)) {
            return false;
        }
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file.getPath()), 8192);
            long length = StreamUtils.copy(pStream, outputStream);
            if ((mUsedCacheSpace += length) > 629145600L) {
                this.cutCurrentCache();
            }
            if (outputStream == null) return true;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (outputStream != null) {
                StreamUtils.closeStream(outputStream);
            }
        }
        StreamUtils.closeStream(outputStream);
        return true;
    }

    private boolean createFolderAndCheckIfExists(File pFile) {
        if (pFile.mkdirs()) {
            return true;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pFile.exists();
    }

    private void calculateDirectorySize(File aDirectory) {
        File[] z = aDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    mUsedCacheSpace += file.length();
                }
                if (!file.isDirectory()) continue;
                this.calculateDirectorySize(file);
            }
        }
    }

    private List<File> getDirectoryFileList(File aDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] z = aDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    files.add(file);
                }
                if (!file.isDirectory()) continue;
                files.addAll(this.getDirectoryFileList(file));
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cutCurrentCache() {
        File file = TILE_PATH_BASE;
        synchronized (file) {
            if (mUsedCacheSpace > 524288000L) {
                logger.info("Trimming tile cache from " + mUsedCacheSpace + " to " + 524288000L);
                List<File> z = this.getDirectoryFileList(TILE_PATH_BASE);
                File[] files = z.toArray(new File[0]);
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                    }
                });
                for (File file2 : files) {
                    if (mUsedCacheSpace <= 524288000L) break;
                    long length = file2.length();
                    if (!file2.delete()) continue;
                    mUsedCacheSpace -= length;
                }
                logger.info("Finished trimming tile cache");
            }
        }
    }
}

