/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.preference.PreferenceManager;
import android.provider.Settings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudmadeUtil
implements OpenStreetMapTileProviderConstants {
    private static final Logger logger = LoggerFactory.getLogger(CloudmadeUtil.class);
    private static final String CLOUDMADE_KEY = "CLOUDMADE_KEY";
    private static final String CLOUDMADE_ID = "CLOUDMADE_ID";
    private static final String CLOUDMADE_TOKEN = "CLOUDMADE_TOKEN";
    private static String mAndroidId = "android_id";
    private static String mKey = "";
    private static String mToken = "";
    private static SharedPreferences.Editor mPreferenceEditor;

    public static void retrieveCloudmadeKey(Context pContext) {
        mAndroidId = Settings.Secure.getString((ContentResolver)pContext.getContentResolver(), (String)"android_id");
        PackageManager pm = pContext.getPackageManager();
        try {
            ApplicationInfo info = pm.getApplicationInfo(pContext.getPackageName(), 128);
            if (info.metaData == null) {
                logger.info("Cloudmade key not found in manifest");
            } else {
                String key = info.metaData.getString(CLOUDMADE_KEY);
                if (key != null) {
                    mKey = key.trim();
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            logger.info("Cloudmade key not found in manifest", (Throwable)e);
        }
        SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)pContext);
        mPreferenceEditor = pref.edit();
        String id = pref.getString(CLOUDMADE_ID, "");
        if (id.equals(mAndroidId)) {
            mToken = pref.getString(CLOUDMADE_TOKEN, "");
            if (mToken.length() > 0) {
                mPreferenceEditor = null;
            }
        } else {
            mPreferenceEditor.putString(CLOUDMADE_ID, mAndroidId);
            mPreferenceEditor.commit();
        }
    }

    public static String getCloudmadeKey() {
        return mKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCloudmadeToken() {
        if (mToken.length() == 0) {
            String string2 = mToken;
            synchronized (string2) {
                if (mToken.length() == 0) {
                    String url = "http://auth.cloudmade.com/token/" + mKey + "?userid=" + mAndroidId;
                    DefaultHttpClient httpClient = new DefaultHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    try {
                        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()), 8192);
                            String line = br.readLine();
                            mToken = line.trim();
                            if (mToken.length() > 0) {
                                mPreferenceEditor.putString(CLOUDMADE_TOKEN, mToken);
                                mPreferenceEditor.commit();
                                mPreferenceEditor = null;
                            } else {
                                logger.error("No authorization token received from Cloudmade");
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error("No authorization token received from Cloudmade: " + e);
                    }
                }
            }
        }
        return mToken;
    }
}

