/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.Scroller;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import microsoft.mappoint.TileSystem;
import net.wigle.wigleandroid.ZoomButtonsController;
import org.metalev.multitouch.controller.MultiTouchController;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IMapView;
import org.osmdroid.api.IProjection;
import org.osmdroid.events.MapListener;
import org.osmdroid.events.ScrollEvent;
import org.osmdroid.events.ZoomEvent;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.MapTileProviderBasic;
import org.osmdroid.tileprovider.tilesource.IStyledTileSource;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.tileprovider.util.SimpleInvalidationHandler;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.constants.GeoConstants;
import org.osmdroid.views.MapController;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.OverlayManager;
import org.osmdroid.views.overlay.TilesOverlay;
import org.osmdroid.views.util.constants.MapViewConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapView
extends ViewGroup
implements IMapView,
MapViewConstants,
MultiTouchController.MultiTouchObjectCanvas<Object> {
    private static final Logger logger = LoggerFactory.getLogger(MapView.class);
    private static final double ZOOM_SENSITIVITY = 1.3;
    private static final double ZOOM_LOG_BASE_INV = 1.0 / Math.log(1.5384615384615383);
    private int mZoomLevel = 0;
    private final OverlayManager mOverlayManager;
    private Projection mProjection;
    private final TilesOverlay mMapOverlay;
    private final GestureDetector mGestureDetector;
    private final Scroller mScroller;
    private final ScaleAnimation mZoomInAnimation;
    private final ScaleAnimation mZoomOutAnimation;
    private final MyAnimationListener mAnimationListener = new MyAnimationListener();
    private final MapController mController;
    private final ZoomButtonsController mZoomController;
    private boolean mEnableZoomController = false;
    private final ResourceProxy mResourceProxy;
    private MultiTouchController<Object> mMultiTouchController;
    private float mMultiTouchScale = 1.0f;
    protected MapListener mListener;
    private final Matrix mMatrix = new Matrix();
    private final MapTileProviderBase mTileProvider;
    private final Handler mTileRequestCompleteHandler;
    private final Point mPoint = new Point();

    private MapView(Context context, int tileSizePixels, ResourceProxy resourceProxy, MapTileProviderBase tileProvider, Handler tileRequestCompleteHandler, AttributeSet attrs) {
        super(context, attrs);
        this.mResourceProxy = resourceProxy;
        this.mController = new MapController(this);
        this.mScroller = new Scroller(context);
        TileSystem.setTileSize(tileSizePixels);
        if (tileProvider == null) {
            ITileSource tileSource = this.getTileSourceFromAttributes(attrs);
            tileProvider = new MapTileProviderBasic(context, tileSource);
        }
        this.mTileRequestCompleteHandler = tileRequestCompleteHandler == null ? new SimpleInvalidationHandler((View)this) : tileRequestCompleteHandler;
        this.mTileProvider = tileProvider;
        this.mTileProvider.setTileRequestCompleteHandler(this.mTileRequestCompleteHandler);
        this.mMapOverlay = new TilesOverlay(this.mTileProvider, this.mResourceProxy);
        this.mOverlayManager = new OverlayManager(this.mMapOverlay);
        this.mZoomController = new ZoomButtonsController((View)this);
        this.mZoomController.setOnZoomListener(new MapViewZoomListener());
        this.mZoomInAnimation = new ScaleAnimation(1.0f, 2.0f, 1.0f, 2.0f, 1, 0.5f, 1, 0.5f);
        this.mZoomOutAnimation = new ScaleAnimation(1.0f, 0.5f, 1.0f, 0.5f, 1, 0.5f, 1, 0.5f);
        this.mZoomInAnimation.setDuration(500L);
        this.mZoomOutAnimation.setDuration(500L);
        this.mZoomInAnimation.setAnimationListener((Animation.AnimationListener)this.mAnimationListener);
        this.mZoomOutAnimation.setAnimationListener((Animation.AnimationListener)this.mAnimationListener);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MapViewGestureDetectorListener());
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new MapViewDoubleClickListener());
    }

    public MapView(Context context, AttributeSet attrs) {
        this(context, 256, new DefaultResourceProxyImpl(context), null, null, attrs);
    }

    public MapView(Context context, int tileSizePixels) {
        this(context, tileSizePixels, new DefaultResourceProxyImpl(context));
    }

    public MapView(Context context, int tileSizePixels, ResourceProxy resourceProxy) {
        this(context, tileSizePixels, resourceProxy, null);
    }

    public MapView(Context context, int tileSizePixels, ResourceProxy resourceProxy, MapTileProviderBase aTileProvider) {
        this(context, tileSizePixels, resourceProxy, aTileProvider, null);
    }

    public MapView(Context context, int tileSizePixels, ResourceProxy resourceProxy, MapTileProviderBase aTileProvider, Handler tileRequestCompleteHandler) {
        this(context, tileSizePixels, resourceProxy, aTileProvider, tileRequestCompleteHandler, null);
    }

    @Override
    public MapController getController() {
        return this.mController;
    }

    public List<Overlay> getOverlays() {
        return this.mOverlayManager;
    }

    public OverlayManager getOverlayManager() {
        return this.mOverlayManager;
    }

    public MapTileProviderBase getTileProvider() {
        return this.mTileProvider;
    }

    public Scroller getScroller() {
        return this.mScroller;
    }

    public Handler getTileRequestCompleteHandler() {
        return this.mTileRequestCompleteHandler;
    }

    @Override
    public int getLatitudeSpan() {
        return this.getBoundingBox().getLatitudeSpanE6();
    }

    @Override
    public int getLongitudeSpan() {
        return this.getBoundingBox().getLongitudeSpanE6();
    }

    public BoundingBoxE6 getBoundingBox() {
        return this.getBoundingBox(this.getWidth(), this.getHeight());
    }

    public BoundingBoxE6 getBoundingBox(int pViewWidth, int pViewHeight) {
        int world_2 = TileSystem.MapSize(this.mZoomLevel) / 2;
        Rect screenRect = this.getScreenRect(null);
        screenRect.offset(world_2, world_2);
        GeoPoint neGeoPoint = TileSystem.PixelXYToLatLong(screenRect.right, screenRect.top, this.mZoomLevel, null);
        GeoPoint swGeoPoint = TileSystem.PixelXYToLatLong(screenRect.left, screenRect.bottom, this.mZoomLevel, null);
        return new BoundingBoxE6(neGeoPoint.getLatitudeE6(), neGeoPoint.getLongitudeE6(), swGeoPoint.getLatitudeE6(), swGeoPoint.getLongitudeE6());
    }

    public Rect getScreenRect(Rect reuse) {
        Rect out = reuse == null ? new Rect() : reuse;
        out.set(this.getScrollX() - this.getWidth() / 2, this.getScrollY() - this.getHeight() / 2, this.getScrollX() + this.getWidth() / 2, this.getScrollY() + this.getHeight() / 2);
        return out;
    }

    @Override
    public Projection getProjection() {
        if (this.mProjection == null) {
            this.mProjection = new Projection();
        }
        return this.mProjection;
    }

    void setMapCenter(GeoPoint aCenter) {
        this.setMapCenter(aCenter.getLatitudeE6(), aCenter.getLongitudeE6());
    }

    void setMapCenter(int aLatitudeE6, int aLongitudeE6) {
        Point coords = TileSystem.LatLongToPixelXY((double)aLatitudeE6 / 1000000.0, (double)aLongitudeE6 / 1000000.0, this.getZoomLevel(), null);
        int worldSize_2 = TileSystem.MapSize(this.mZoomLevel) / 2;
        if (this.getAnimation() == null || this.getAnimation().hasEnded()) {
            logger.debug("StartScroll");
            this.mScroller.startScroll(this.getScrollX(), this.getScrollY(), coords.x - worldSize_2 - this.getScrollX(), coords.y - worldSize_2 - this.getScrollY(), 500);
            this.postInvalidate();
        }
    }

    public void setTileSource(ITileSource aTileSource) {
        this.mTileProvider.setTileSource(aTileSource);
        TileSystem.setTileSize(aTileSource.getTileSizePixels());
        this.checkZoomButtons();
        this.setZoomLevel(this.mZoomLevel);
        this.postInvalidate();
    }

    int setZoomLevel(int aZoomLevel) {
        int minZoomLevel = this.getMinZoomLevel();
        int maxZoomLevel = this.getMaxZoomLevel();
        int newZoomLevel = Math.max(minZoomLevel, Math.min(maxZoomLevel, aZoomLevel));
        int curZoomLevel = this.mZoomLevel;
        this.mZoomLevel = newZoomLevel;
        this.checkZoomButtons();
        if (newZoomLevel > curZoomLevel) {
            this.scrollTo(this.getScrollX() << newZoomLevel - curZoomLevel, this.getScrollY() << newZoomLevel - curZoomLevel);
        } else if (newZoomLevel < curZoomLevel) {
            this.scrollTo(this.getScrollX() >> curZoomLevel - newZoomLevel, this.getScrollY() >> curZoomLevel - newZoomLevel);
        }
        Point snapPoint = new Point();
        this.mProjection = new Projection();
        if (this.mOverlayManager.onSnapToItem(this.getScrollX(), this.getScrollY(), snapPoint, this)) {
            this.scrollTo(snapPoint.x, snapPoint.y);
        }
        if (newZoomLevel != curZoomLevel && this.mListener != null) {
            ZoomEvent event = new ZoomEvent(this, newZoomLevel);
            this.mListener.onZoom(event);
        }
        return this.mZoomLevel;
    }

    @Override
    public int getZoomLevel() {
        return this.getZoomLevel(true);
    }

    public int getZoomLevel(boolean aPending) {
        if (aPending && this.mAnimationListener.isAnimating()) {
            return this.mAnimationListener.targetZoomLevel;
        }
        return this.mZoomLevel;
    }

    public int getMinZoomLevel() {
        return this.mMapOverlay.getMinimumZoomLevel();
    }

    @Override
    public int getMaxZoomLevel() {
        return this.mMapOverlay.getMaximumZoomLevel();
    }

    public boolean canZoomIn() {
        int maxZoomLevel = this.getMaxZoomLevel();
        if (this.mZoomLevel >= maxZoomLevel) {
            return false;
        }
        return !this.mAnimationListener.isAnimating() || this.mAnimationListener.targetZoomLevel < maxZoomLevel;
    }

    public boolean canZoomOut() {
        int minZoomLevel = this.getMinZoomLevel();
        if (this.mZoomLevel <= minZoomLevel) {
            return false;
        }
        return !this.mAnimationListener.isAnimating() || this.mAnimationListener.targetZoomLevel > minZoomLevel;
    }

    boolean zoomIn() {
        if (this.canZoomIn()) {
            if (this.mAnimationListener.isAnimating()) {
                return false;
            }
            this.mAnimationListener.targetZoomLevel = this.mZoomLevel + 1;
            this.startAnimation((Animation)this.mZoomInAnimation);
            return true;
        }
        return false;
    }

    boolean zoomInFixing(GeoPoint point) {
        this.setMapCenter(point);
        return this.zoomIn();
    }

    boolean zoomInFixing(int xPixel, int yPixel) {
        this.setMapCenter(xPixel, yPixel);
        return this.zoomIn();
    }

    boolean zoomOut() {
        if (this.canZoomOut()) {
            if (this.mAnimationListener.isAnimating()) {
                return false;
            }
            this.mAnimationListener.targetZoomLevel = this.mZoomLevel - 1;
            this.startAnimation((Animation)this.mZoomOutAnimation);
            return true;
        }
        return false;
    }

    boolean zoomOutFixing(GeoPoint point) {
        this.setMapCenter(point);
        return this.zoomOut();
    }

    boolean zoomOutFixing(int xPixel, int yPixel) {
        this.setMapCenter(xPixel, yPixel);
        return this.zoomOut();
    }

    @Override
    public GeoPoint getMapCenter() {
        int world_2 = TileSystem.MapSize(this.mZoomLevel) / 2;
        Rect screenRect = this.getScreenRect(null);
        screenRect.offset(world_2, world_2);
        return TileSystem.PixelXYToLatLong(screenRect.centerX(), screenRect.centerY(), this.mZoomLevel, null);
    }

    public ResourceProxy getResourceProxy() {
        return this.mResourceProxy;
    }

    public boolean useDataConnection() {
        return this.mMapOverlay.useDataConnection();
    }

    public void setUseDataConnection(boolean aMode) {
        this.mMapOverlay.setUseDataConnection(aMode);
    }

    public boolean isAnimating() {
        return this.mAnimationListener.isAnimating();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2, null, 8, 0, 0);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            this.getProjection().toMapPixels(lp.geoPoint, this.mPoint);
            int x = this.mPoint.x + this.getWidth() / 2;
            int y = this.mPoint.y + this.getHeight() / 2;
            int childRight = x;
            int childBottom = y;
            switch (lp.alignment) {
                case 1: {
                    childRight = x + childWidth;
                    childBottom = y;
                    break;
                }
                case 2: {
                    childRight = x + childWidth / 2;
                    childBottom = y;
                    break;
                }
                case 3: {
                    childRight = x;
                    childBottom = y;
                    break;
                }
                case 4: {
                    childRight = x + childWidth;
                    childBottom = y + childHeight / 2;
                    break;
                }
                case 5: {
                    childRight = x + childWidth / 2;
                    childBottom = y + childHeight / 2;
                    break;
                }
                case 6: {
                    childRight = x;
                    childBottom = y + childHeight / 2;
                    break;
                }
                case 7: {
                    childRight = x + childWidth;
                    childBottom = y + childHeight;
                    break;
                }
                case 8: {
                    childRight = x + childWidth / 2;
                    childBottom = y + childHeight;
                    break;
                }
                case 9: {
                    childRight = x;
                    childBottom = y + childHeight;
                }
            }
            maxWidth = Math.max(maxWidth, childRight += lp.offsetX);
            maxHeight = Math.max(maxHeight, childBottom += lp.offsetY);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(MapView.resolveSize((int)maxWidth, (int)widthMeasureSpec), MapView.resolveSize((int)maxHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            this.getProjection().toMapPixels(lp.geoPoint, this.mPoint);
            int x = this.mPoint.x + this.getWidth() / 2;
            int y = this.mPoint.y + this.getHeight() / 2;
            int childLeft = x;
            int childTop = y;
            switch (lp.alignment) {
                case 1: {
                    childLeft = this.getPaddingLeft() + x;
                    childTop = this.getPaddingTop() + y;
                    break;
                }
                case 2: {
                    childLeft = this.getPaddingLeft() + x - childWidth / 2;
                    childTop = this.getPaddingTop() + y;
                    break;
                }
                case 3: {
                    childLeft = this.getPaddingLeft() + x - childWidth;
                    childTop = this.getPaddingTop() + y;
                    break;
                }
                case 4: {
                    childLeft = this.getPaddingLeft() + x;
                    childTop = this.getPaddingTop() + y - childHeight / 2;
                    break;
                }
                case 5: {
                    childLeft = this.getPaddingLeft() + x - childWidth / 2;
                    childTop = this.getPaddingTop() + y - childHeight / 2;
                    break;
                }
                case 6: {
                    childLeft = this.getPaddingLeft() + x - childWidth;
                    childTop = this.getPaddingTop() + y - childHeight / 2;
                    break;
                }
                case 7: {
                    childLeft = this.getPaddingLeft() + x;
                    childTop = this.getPaddingTop() + y - childHeight;
                    break;
                }
                case 8: {
                    childLeft = this.getPaddingLeft() + x - childWidth / 2;
                    childTop = this.getPaddingTop() + y - childHeight;
                    break;
                }
                case 9: {
                    childLeft = this.getPaddingLeft() + x - childWidth;
                    childTop = this.getPaddingTop() + y - childHeight;
                }
            }
            child.layout(childLeft += lp.offsetX, childTop += lp.offsetY, childLeft + childWidth, childTop + childHeight);
        }
    }

    public void onDetach() {
        this.mOverlayManager.onDetach(this);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = this.mOverlayManager.onKeyDown(keyCode, event, this);
        return result || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean result = this.mOverlayManager.onKeyUp(keyCode, event, this);
        return result || super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.mOverlayManager.onTrackballEvent(event, this)) {
            return true;
        }
        this.scrollBy((int)(event.getX() * 25.0f), (int)(event.getY() * 25.0f));
        return super.onTrackballEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mZoomController.isVisible() && this.mZoomController.onTouch((View)this, event)) {
            return true;
        }
        if (this.mOverlayManager.onTouchEvent(event, this)) {
            return true;
        }
        if (this.mMultiTouchController != null && this.mMultiTouchController.onTouchEvent(event)) {
            return true;
        }
        boolean r = super.dispatchTouchEvent(event);
        if (this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        if (r) {
            // empty if block
        }
        return r;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScroller.isFinished()) {
                this.setZoomLevel(this.mZoomLevel);
            } else {
                this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            }
            this.postInvalidate();
        }
    }

    public void scrollTo(int x, int y) {
        int worldSize_2 = TileSystem.MapSize(this.mZoomLevel) / 2;
        while (x < -worldSize_2) {
            x += worldSize_2 * 2;
        }
        while (x > worldSize_2) {
            x -= worldSize_2 * 2;
        }
        while (y < -worldSize_2) {
            y += worldSize_2 * 2;
        }
        while (y > worldSize_2) {
            y -= worldSize_2 * 2;
        }
        super.scrollTo(x, y);
        if (this.mListener != null) {
            ScrollEvent event = new ScrollEvent(this, x, y);
            this.mListener.onScroll(event);
        }
    }

    @Override
    public void setBackgroundColor(int pColor) {
        this.mMapOverlay.setLoadingBackgroundColor(pColor);
        this.invalidate();
    }

    protected void dispatchDraw(Canvas c) {
        long startMs = System.currentTimeMillis();
        this.mProjection = new Projection();
        c.save();
        if (this.mMultiTouchScale == 1.0f) {
            c.translate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        } else {
            c.getMatrix(this.mMatrix);
            this.mMatrix.postTranslate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            this.mMatrix.preScale(this.mMultiTouchScale, this.mMultiTouchScale, (float)this.getScrollX(), (float)this.getScrollY());
            c.setMatrix(this.mMatrix);
        }
        this.mOverlayManager.onDraw(c, this);
        c.restore();
        super.dispatchDraw(c);
        long endMs = System.currentTimeMillis();
    }

    protected void onDetachedFromWindow() {
        this.mZoomController.setVisible(false);
        this.onDetach();
        super.onDetachedFromWindow();
    }

    @Override
    public Object getDraggableObjectAtPoint(MultiTouchController.PointInfo pt) {
        return this;
    }

    @Override
    public void getPositionAndScale(Object obj, MultiTouchController.PositionAndScale objPosAndScaleOut) {
        objPosAndScaleOut.set(0.0f, 0.0f, true, this.mMultiTouchScale, false, 0.0f, 0.0f, false, 0.0f);
    }

    @Override
    public void selectObject(Object obj, MultiTouchController.PointInfo pt) {
        if (obj == null && this.mMultiTouchScale != 1.0f) {
            float scaleDiffFloat = (float)(Math.log(this.mMultiTouchScale) * ZOOM_LOG_BASE_INV);
            int scaleDiffInt = Math.round(scaleDiffFloat);
            this.setZoomLevel(this.mZoomLevel + scaleDiffInt);
        }
        this.mMultiTouchScale = 1.0f;
    }

    @Override
    public boolean setPositionAndScale(Object obj, MultiTouchController.PositionAndScale aNewObjPosAndScale, MultiTouchController.PointInfo aTouchPoint) {
        float multiTouchScale = aNewObjPosAndScale.getScale();
        if (multiTouchScale > 1.0f && !this.canZoomIn()) {
            multiTouchScale = 1.0f;
        }
        if (multiTouchScale < 1.0f && !this.canZoomOut()) {
            multiTouchScale = 1.0f;
        }
        this.mMultiTouchScale = multiTouchScale;
        this.invalidate();
        return true;
    }

    public void setMapListener(MapListener ml) {
        this.mListener = ml;
    }

    private void checkZoomButtons() {
        this.mZoomController.setZoomInEnabled(this.canZoomIn());
        this.mZoomController.setZoomOutEnabled(this.canZoomOut());
    }

    public void setBuiltInZoomControls(boolean on) {
        this.mEnableZoomController = on;
        this.checkZoomButtons();
    }

    public void setMultiTouchControls(boolean on) {
        this.mMultiTouchController = on ? new MultiTouchController<Object>(this, false) : null;
    }

    private ITileSource getTileSourceFromAttributes(AttributeSet aAttributeSet) {
        String tileSourceAttr;
        ITileSource tileSource = TileSourceFactory.DEFAULT_TILE_SOURCE;
        if (aAttributeSet != null && (tileSourceAttr = aAttributeSet.getAttributeValue(null, "tilesource")) != null) {
            try {
                ITileSource r = TileSourceFactory.getTileSource(tileSourceAttr);
                logger.info("Using tile source specified in layout attributes: " + r);
                tileSource = r;
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid tile souce specified in layout attributes: " + tileSource);
            }
        }
        if (aAttributeSet != null && tileSource instanceof IStyledTileSource) {
            String style = aAttributeSet.getAttributeValue(null, "style");
            if (style == null) {
                style = aAttributeSet.getAttributeValue(null, "cloudmadeStyle");
            }
            if (style == null) {
                logger.info("Using default style: 1");
            } else {
                logger.info("Using style specified in layout attributes: " + style);
                ((IStyledTileSource)((Object)tileSource)).setStyle(style);
            }
        }
        logger.info("Using tile source: " + tileSource);
        return tileSource;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public static final int TOP_LEFT = 1;
        public static final int TOP_CENTER = 2;
        public static final int TOP_RIGHT = 3;
        public static final int CENTER_LEFT = 4;
        public static final int CENTER = 5;
        public static final int CENTER_RIGHT = 6;
        public static final int BOTTOM_LEFT = 7;
        public static final int BOTTOM_CENTER = 8;
        public static final int BOTTOM_RIGHT = 9;
        public GeoPoint geoPoint;
        public int alignment;
        public int offsetX;
        public int offsetY;

        public LayoutParams(int width, int height, GeoPoint geoPoint, int alignment, int offsetX, int offsetY) {
            super(width, height);
            this.geoPoint = geoPoint != null ? geoPoint : new GeoPoint(0, 0);
            this.alignment = alignment;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.geoPoint = new GeoPoint(0, 0);
            this.alignment = 8;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    private class MyAnimationListener
    implements Animation.AnimationListener {
        private int targetZoomLevel;
        private AtomicBoolean animating = new AtomicBoolean(false);

        private MyAnimationListener() {
        }

        public void onAnimationEnd(Animation aAnimation) {
            this.animating.set(false);
            MapView.this.post(new Runnable(){

                @Override
                public void run() {
                    MapView.this.clearAnimation();
                    MapView.this.setZoomLevel(MyAnimationListener.this.targetZoomLevel);
                }
            });
        }

        public void onAnimationRepeat(Animation aAnimation) {
        }

        public void onAnimationStart(Animation aAnimation) {
            this.animating.set(true);
        }

        public boolean isAnimating() {
            return this.animating.get();
        }
    }

    private class MapViewZoomListener
    implements ZoomButtonsController.OnZoomListener {
        private MapViewZoomListener() {
        }

        @Override
        public void onZoom(boolean zoomIn) {
            if (zoomIn) {
                MapView.this.getController().zoomIn();
            } else {
                MapView.this.getController().zoomOut();
            }
        }

        @Override
        public void onVisibilityChanged(boolean visible) {
        }
    }

    private class MapViewDoubleClickListener
    implements GestureDetector.OnDoubleTapListener {
        private MapViewDoubleClickListener() {
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (MapView.this.mOverlayManager.onDoubleTap(e, MapView.this)) {
                return true;
            }
            GeoPoint center = MapView.this.getProjection().fromPixels(e.getX(), e.getY());
            return MapView.this.zoomInFixing(center);
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return MapView.this.mOverlayManager.onDoubleTapEvent(e, MapView.this);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            return MapView.this.mOverlayManager.onSingleTapConfirmed(e, MapView.this);
        }
    }

    private class MapViewGestureDetectorListener
    implements GestureDetector.OnGestureListener {
        private MapViewGestureDetectorListener() {
        }

        public boolean onDown(MotionEvent e) {
            if (MapView.this.mOverlayManager.onDown(e, MapView.this)) {
                return true;
            }
            MapView.this.mZoomController.setVisible(MapView.this.mEnableZoomController);
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (MapView.this.mOverlayManager.onFling(e1, e2, velocityX, velocityY, MapView.this)) {
                return true;
            }
            int worldSize = TileSystem.MapSize(MapView.this.mZoomLevel);
            MapView.this.mScroller.fling(MapView.this.getScrollX(), MapView.this.getScrollY(), (int)(-velocityX), (int)(-velocityY), -worldSize, worldSize, -worldSize, worldSize);
            return true;
        }

        public void onLongPress(MotionEvent e) {
            MapView.this.mOverlayManager.onLongPress(e, MapView.this);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (MapView.this.mOverlayManager.onScroll(e1, e2, distanceX, distanceY, MapView.this)) {
                return true;
            }
            MapView.this.scrollBy((int)distanceX, (int)distanceY);
            return true;
        }

        public void onShowPress(MotionEvent e) {
            MapView.this.mOverlayManager.onShowPress(e, MapView.this);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return MapView.this.mOverlayManager.onSingleTapUp(e, MapView.this);
        }
    }

    public class Projection
    implements IProjection,
    GeoConstants {
        private final int viewWidth_2;
        private final int viewHeight_2;
        private final int worldSize_2;
        private final int offsetX;
        private final int offsetY;
        private final BoundingBoxE6 mBoundingBoxProjection;
        private final int mZoomLevelProjection;
        private final Rect mScreenRectProjection;

        private Projection() {
            this.viewWidth_2 = MapView.this.getWidth() / 2;
            this.viewHeight_2 = MapView.this.getHeight() / 2;
            this.worldSize_2 = TileSystem.MapSize(MapView.this.mZoomLevel) / 2;
            this.offsetX = -this.worldSize_2;
            this.offsetY = -this.worldSize_2;
            this.mZoomLevelProjection = MapView.this.mZoomLevel;
            this.mBoundingBoxProjection = MapView.this.getBoundingBox();
            this.mScreenRectProjection = MapView.this.getScreenRect(null);
        }

        public int getZoomLevel() {
            return this.mZoomLevelProjection;
        }

        public BoundingBoxE6 getBoundingBox() {
            return this.mBoundingBoxProjection;
        }

        public Rect getScreenRect() {
            return this.mScreenRectProjection;
        }

        public int getTileSizePixels() {
            return TileSystem.getTileSize();
        }

        public Point getCenterMapTileCoords() {
            Rect rect = this.getScreenRect();
            return TileSystem.PixelXYToTileXY(rect.centerX(), rect.centerY(), null);
        }

        public Point getUpperLeftCornerOfCenterMapTile() {
            Point centerMapTileCoords = this.getCenterMapTileCoords();
            return TileSystem.TileXYToPixelXY(centerMapTileCoords.x, centerMapTileCoords.y, null);
        }

        public GeoPoint fromPixels(float x, float y) {
            Rect screenRect = this.getScreenRect();
            return TileSystem.PixelXYToLatLong(screenRect.left + (int)x + this.worldSize_2, screenRect.top + (int)y + this.worldSize_2, this.mZoomLevelProjection, null);
        }

        public Point fromMapPixels(int x, int y, Point reuse) {
            Point out = reuse != null ? reuse : new Point();
            out.set(x - this.viewWidth_2, y - this.viewHeight_2);
            out.offset(MapView.this.getScrollX(), MapView.this.getScrollY());
            return out;
        }

        public Point toMapPixels(IGeoPoint in, Point reuse) {
            Point out = reuse != null ? reuse : new Point();
            Point coords = TileSystem.LatLongToPixelXY((double)in.getLatitudeE6() / 1000000.0, (double)in.getLongitudeE6() / 1000000.0, this.getZoomLevel(), null);
            out.set(coords.x, coords.y);
            out.offset(this.offsetX, this.offsetY);
            return out;
        }

        public Point toMapPixelsProjected(int latituteE6, int longitudeE6, Point reuse) {
            Point out = reuse != null ? reuse : new Point();
            TileSystem.LatLongToPixelXY((double)latituteE6 / 1000000.0, (double)longitudeE6 / 1000000.0, 22, out);
            return out;
        }

        public Point toMapPixelsTranslated(Point in, Point reuse) {
            Point out = reuse != null ? reuse : new Point();
            int zoomDifference = 22 - this.getZoomLevel();
            out.set((in.x >> zoomDifference) + this.offsetX, (in.y >> zoomDifference) + this.offsetY);
            return out;
        }

        public Rect fromPixelsToProjected(Rect in) {
            Rect result = new Rect();
            int zoomDifference = 22 - this.getZoomLevel();
            int x0 = in.left - this.offsetX << zoomDifference;
            int x1 = in.right - this.offsetX << zoomDifference;
            int y0 = in.bottom - this.offsetY << zoomDifference;
            int y1 = in.top - this.offsetY << zoomDifference;
            result.set(Math.min(x0, x1), Math.min(y0, y1), Math.max(x0, x1), Math.max(y0, y1));
            return result;
        }

        public Point toPixels(Point tileCoords, Point reuse) {
            return this.toPixels(tileCoords.x, tileCoords.y, reuse);
        }

        public Point toPixels(int tileX, int tileY, Point reuse) {
            return TileSystem.TileXYToPixelXY(tileX, tileY, reuse);
        }

        public Rect toPixels(BoundingBoxE6 pBoundingBoxE6) {
            Rect rect = new Rect();
            Point reuse = new Point();
            this.toMapPixels(new GeoPoint(pBoundingBoxE6.getLatNorthE6(), pBoundingBoxE6.getLonWestE6()), reuse);
            rect.left = reuse.x;
            rect.top = reuse.y;
            this.toMapPixels(new GeoPoint(pBoundingBoxE6.getLatSouthE6(), pBoundingBoxE6.getLonEastE6()), reuse);
            rect.right = reuse.x;
            rect.bottom = reuse.y;
            return rect;
        }

        @Override
        public float metersToEquatorPixels(float meters) {
            return meters / (float)TileSystem.GroundResolution(0.0, this.mZoomLevelProjection);
        }

        @Override
        public Point toPixels(GeoPoint in, Point out) {
            return this.toMapPixels(in, out);
        }

        @Override
        public GeoPoint fromPixels(int x, int y) {
            return this.fromPixels((float)x, (float)y);
        }
    }
}

