/*
 * Decompiled with CFR 0.152.
 */
package de.keyboardsurfer.android.widget.crouton;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import de.keyboardsurfer.android.widget.crouton.Configuration;
import de.keyboardsurfer.android.widget.crouton.DefaultAnimationsBuilder;
import de.keyboardsurfer.android.widget.crouton.LifecycleCallback;
import de.keyboardsurfer.android.widget.crouton.Manager;
import de.keyboardsurfer.android.widget.crouton.Style;

public final class Crouton {
    private static final int IMAGE_ID = 256;
    private static final int TEXT_ID = 257;
    private final CharSequence text;
    private final Style style;
    private Configuration configuration = null;
    private final View customView;
    private View.OnClickListener onClickListener;
    private Activity activity;
    private ViewGroup viewGroup;
    private FrameLayout croutonView;
    private Animation inAnimation;
    private Animation outAnimation;
    private LifecycleCallback lifecycleCallback = null;

    private Crouton(Activity activity, CharSequence text, Style style) {
        if (activity == null || text == null || style == null) {
            throw new IllegalArgumentException("Null parameters are not accepted");
        }
        this.activity = activity;
        this.viewGroup = null;
        this.text = text;
        this.style = style;
        this.customView = null;
    }

    private Crouton(Activity activity, CharSequence text, Style style, ViewGroup viewGroup) {
        if (activity == null || text == null || style == null) {
            throw new IllegalArgumentException("Null parameters are not accepted");
        }
        this.activity = activity;
        this.text = text;
        this.style = style;
        this.viewGroup = viewGroup;
        this.customView = null;
    }

    private Crouton(Activity activity, View customView) {
        if (activity == null || customView == null) {
            throw new IllegalArgumentException("Null parameters are not accepted");
        }
        this.activity = activity;
        this.viewGroup = null;
        this.customView = customView;
        this.style = new Style.Builder().build();
        this.text = null;
    }

    private Crouton(Activity activity, View customView, ViewGroup viewGroup) {
        this(activity, customView, viewGroup, Configuration.DEFAULT);
    }

    private Crouton(Activity activity, View customView, ViewGroup viewGroup, Configuration configuration) {
        if (activity == null || customView == null) {
            throw new IllegalArgumentException("Null parameters are not accepted");
        }
        this.activity = activity;
        this.customView = customView;
        this.viewGroup = viewGroup;
        this.style = new Style.Builder().build();
        this.text = null;
        this.configuration = configuration;
    }

    public static Crouton makeText(Activity activity, CharSequence text, Style style) {
        return new Crouton(activity, text, style);
    }

    public static Crouton makeText(Activity activity, CharSequence text, Style style, ViewGroup viewGroup) {
        return new Crouton(activity, text, style, viewGroup);
    }

    public static Crouton makeText(Activity activity, CharSequence text, Style style, int viewGroupResId) {
        return new Crouton(activity, text, style, (ViewGroup)activity.findViewById(viewGroupResId));
    }

    public static Crouton makeText(Activity activity, int textResourceId, Style style) {
        return Crouton.makeText(activity, activity.getString(textResourceId), style);
    }

    public static Crouton makeText(Activity activity, int textResourceId, Style style, ViewGroup viewGroup) {
        return Crouton.makeText(activity, (CharSequence)activity.getString(textResourceId), style, viewGroup);
    }

    public static Crouton makeText(Activity activity, int textResourceId, Style style, int viewGroupResId) {
        return Crouton.makeText(activity, (CharSequence)activity.getString(textResourceId), style, (ViewGroup)activity.findViewById(viewGroupResId));
    }

    public static Crouton make(Activity activity, View customView) {
        return new Crouton(activity, customView);
    }

    public static Crouton make(Activity activity, View customView, ViewGroup viewGroup) {
        return new Crouton(activity, customView, viewGroup);
    }

    public static Crouton make(Activity activity, View customView, int viewGroupResId) {
        return new Crouton(activity, customView, (ViewGroup)activity.findViewById(viewGroupResId));
    }

    public static Crouton make(Activity activity, View customView, int viewGroupResId, Configuration configuration) {
        return new Crouton(activity, customView, (ViewGroup)activity.findViewById(viewGroupResId), configuration);
    }

    public static void showText(Activity activity, CharSequence text, Style style) {
        Crouton.makeText(activity, text, style).show();
    }

    public static void showText(Activity activity, CharSequence text, Style style, ViewGroup viewGroup) {
        Crouton.makeText(activity, text, style, viewGroup).show();
    }

    public static void showText(Activity activity, CharSequence text, Style style, int viewGroupResId) {
        Crouton.makeText(activity, text, style, (ViewGroup)activity.findViewById(viewGroupResId)).show();
    }

    public static void showText(Activity activity, CharSequence text, Style style, int viewGroupResId, Configuration configuration) {
        Crouton.makeText(activity, text, style, (ViewGroup)activity.findViewById(viewGroupResId)).setConfiguration(configuration).show();
    }

    public static void show(Activity activity, View customView) {
        Crouton.make(activity, customView).show();
    }

    public static void show(Activity activity, View customView, ViewGroup viewGroup) {
        Crouton.make(activity, customView, viewGroup).show();
    }

    public static void show(Activity activity, View customView, int viewGroupResId) {
        Crouton.make(activity, customView, viewGroupResId).show();
    }

    public static void showText(Activity activity, int textResourceId, Style style) {
        Crouton.showText(activity, activity.getString(textResourceId), style);
    }

    public static void showText(Activity activity, int textResourceId, Style style, ViewGroup viewGroup) {
        Crouton.showText(activity, (CharSequence)activity.getString(textResourceId), style, viewGroup);
    }

    public static void showText(Activity activity, int textResourceId, Style style, int viewGroupResId) {
        Crouton.showText(activity, (CharSequence)activity.getString(textResourceId), style, viewGroupResId);
    }

    public static void hide(Crouton crouton) {
        Manager.getInstance().removeCrouton(crouton);
    }

    public static void cancelAllCroutons() {
        Manager.getInstance().clearCroutonQueue();
    }

    public static void clearCroutonsForActivity(Activity activity) {
        Manager.getInstance().clearCroutonsForActivity(activity);
    }

    public void cancel() {
        Manager manager = Manager.getInstance();
        manager.removeCroutonImmediately(this);
    }

    public void show() {
        Manager.getInstance().add(this);
    }

    public Animation getInAnimation() {
        if (null == this.inAnimation && null != this.activity) {
            if (this.getConfiguration().inAnimationResId > 0) {
                this.inAnimation = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)this.getConfiguration().inAnimationResId);
            } else {
                this.measureCroutonView();
                this.inAnimation = DefaultAnimationsBuilder.buildDefaultSlideInDownAnimation(this.getView());
            }
        }
        return this.inAnimation;
    }

    public Animation getOutAnimation() {
        if (null == this.outAnimation && null != this.activity) {
            this.outAnimation = this.getConfiguration().outAnimationResId > 0 ? AnimationUtils.loadAnimation((Context)this.getActivity(), (int)this.getConfiguration().outAnimationResId) : DefaultAnimationsBuilder.buildDefaultSlideOutUpAnimation(this.getView());
        }
        return this.outAnimation;
    }

    public void setLifecycleCallback(LifecycleCallback lifecycleCallback) {
        this.lifecycleCallback = lifecycleCallback;
    }

    public Crouton setOnClickListener(View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
        return this;
    }

    public Crouton setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public String toString() {
        return "Crouton{text=" + this.text + ", style=" + this.style + ", configuration=" + this.configuration + ", customView=" + this.customView + ", onClickListener=" + this.onClickListener + ", activity=" + this.activity + ", viewGroup=" + this.viewGroup + ", croutonView=" + this.croutonView + ", inAnimation=" + this.inAnimation + ", outAnimation=" + this.outAnimation + ", lifecycleCallback=" + this.lifecycleCallback + '}';
    }

    public static String getLicenseText() {
        return "This application uses the Crouton library.\n\nCopyright 2012 - 2013 Benjamin Weiss \nCopyright 2012 Neofonie Mobile GmbH\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n   http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.";
    }

    boolean isShowing() {
        return null != this.activity && (this.isCroutonViewNotNull() || this.isCustomViewNotNull());
    }

    private boolean isCroutonViewNotNull() {
        return null != this.croutonView && null != this.croutonView.getParent();
    }

    private boolean isCustomViewNotNull() {
        return null != this.customView && null != this.customView.getParent();
    }

    void detachActivity() {
        this.activity = null;
    }

    void detachViewGroup() {
        this.viewGroup = null;
    }

    void detachLifecycleCallback() {
        this.lifecycleCallback = null;
    }

    LifecycleCallback getLifecycleCallback() {
        return this.lifecycleCallback;
    }

    Style getStyle() {
        return this.style;
    }

    Configuration getConfiguration() {
        if (null == this.configuration) {
            this.configuration = this.getStyle().configuration;
        }
        return this.configuration;
    }

    Activity getActivity() {
        return this.activity;
    }

    ViewGroup getViewGroup() {
        return this.viewGroup;
    }

    CharSequence getText() {
        return this.text;
    }

    View getView() {
        if (null != this.customView) {
            return this.customView;
        }
        if (null == this.croutonView) {
            this.initializeCroutonView();
        }
        return this.croutonView;
    }

    private void measureCroutonView() {
        View view = this.getView();
        int widthSpec = this.viewGroup != null ? View.MeasureSpec.makeMeasureSpec((int)this.viewGroup.getMeasuredWidth(), (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)this.activity.getWindow().getDecorView().getMeasuredWidth(), (int)Integer.MIN_VALUE);
        view.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
    }

    private void initializeCroutonView() {
        Resources resources = this.activity.getResources();
        this.croutonView = this.initializeCroutonViewGroup(resources);
        RelativeLayout contentView = this.initializeContentView(resources);
        this.croutonView.addView((View)contentView);
    }

    private FrameLayout initializeCroutonViewGroup(Resources resources) {
        FrameLayout croutonView = new FrameLayout((Context)this.activity);
        if (null != this.onClickListener) {
            croutonView.setOnClickListener(this.onClickListener);
        }
        int height = this.style.heightDimensionResId > 0 ? resources.getDimensionPixelSize(this.style.heightDimensionResId) : this.style.heightInPixels;
        int width = this.style.widthDimensionResId > 0 ? resources.getDimensionPixelSize(this.style.widthDimensionResId) : this.style.widthInPixels;
        croutonView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width != 0 ? width : -1, height));
        if (this.style.backgroundColorValue != -1) {
            croutonView.setBackgroundColor(this.style.backgroundColorValue);
        } else {
            croutonView.setBackgroundColor(resources.getColor(this.style.backgroundColorResourceId));
        }
        if (this.style.backgroundDrawableResourceId != 0) {
            Bitmap background = BitmapFactory.decodeResource((Resources)resources, (int)this.style.backgroundDrawableResourceId);
            BitmapDrawable drawable = new BitmapDrawable(resources, background);
            if (this.style.isTileEnabled) {
                drawable.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
            }
            croutonView.setBackgroundDrawable((Drawable)drawable);
        }
        return croutonView;
    }

    private RelativeLayout initializeContentView(Resources resources) {
        RelativeLayout contentView = new RelativeLayout((Context)this.activity);
        contentView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        int padding = this.style.paddingInPixels;
        if (this.style.paddingDimensionResId > 0) {
            padding = resources.getDimensionPixelSize(this.style.paddingDimensionResId);
        }
        contentView.setPadding(padding, padding, padding, padding);
        ImageView image = null;
        if (null != this.style.imageDrawable || 0 != this.style.imageResId) {
            image = this.initializeImageView();
            contentView.addView((View)image, image.getLayoutParams());
        }
        TextView text = this.initializeTextView(resources);
        RelativeLayout.LayoutParams textParams = new RelativeLayout.LayoutParams(-1, -2);
        if (null != image) {
            textParams.addRule(1, image.getId());
        }
        contentView.addView((View)text, (ViewGroup.LayoutParams)textParams);
        return contentView;
    }

    private TextView initializeTextView(Resources resources) {
        TextView text = new TextView((Context)this.activity);
        text.setId(257);
        text.setText(this.text);
        text.setTypeface(Typeface.DEFAULT_BOLD);
        text.setGravity(this.style.gravity);
        if (this.style.textColorResourceId != 0) {
            text.setTextColor(resources.getColor(this.style.textColorResourceId));
        }
        if (this.style.textSize != 0) {
            text.setTextSize(2, (float)this.style.textSize);
        }
        if (this.style.textShadowColorResId != 0) {
            this.initializeTextViewShadow(resources, text);
        }
        if (this.style.textAppearanceResId != 0) {
            text.setTextAppearance((Context)this.activity, this.style.textAppearanceResId);
        }
        return text;
    }

    private void initializeTextViewShadow(Resources resources, TextView text) {
        int textShadowColor = resources.getColor(this.style.textShadowColorResId);
        float textShadowRadius = this.style.textShadowRadius;
        float textShadowDx = this.style.textShadowDx;
        float textShadowDy = this.style.textShadowDy;
        text.setShadowLayer(textShadowRadius, textShadowDx, textShadowDy, textShadowColor);
    }

    private ImageView initializeImageView() {
        ImageView image = new ImageView((Context)this.activity);
        image.setId(256);
        image.setAdjustViewBounds(true);
        image.setScaleType(this.style.imageScaleType);
        if (null != this.style.imageDrawable) {
            image.setImageDrawable(this.style.imageDrawable);
        }
        if (this.style.imageResId != 0) {
            image.setImageResource(this.style.imageResId);
        }
        RelativeLayout.LayoutParams imageParams = new RelativeLayout.LayoutParams(-2, -2);
        imageParams.addRule(9, -1);
        imageParams.addRule(15, -1);
        image.setLayoutParams((ViewGroup.LayoutParams)imageParams);
        return image;
    }
}

