/*
 * Decompiled with CFR 0.152.
 */
package de.keyboardsurfer.android.widget.crouton;

import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import de.keyboardsurfer.android.widget.crouton.Configuration;

public class Style {
    public static final int holoRedLight = -48060;
    public static final int holoGreenLight = -6697984;
    public static final int holoBlueLight = -13388315;
    public static final Style ALERT = new Builder().setBackgroundColorValue(-48060).build();
    public static final Style CONFIRM = new Builder().setBackgroundColorValue(-6697984).build();
    public static final Style INFO = new Builder().setBackgroundColorValue(-13388315).build();
    final Configuration configuration;
    final int backgroundColorResourceId;
    final int backgroundDrawableResourceId;
    final int backgroundColorValue;
    final boolean isTileEnabled;
    final int textColorResourceId;
    final int heightInPixels;
    final int heightDimensionResId;
    final int widthInPixels;
    final int widthDimensionResId;
    final int gravity;
    final Drawable imageDrawable;
    final int imageResId;
    final ImageView.ScaleType imageScaleType;
    final int textSize;
    final int textShadowColorResId;
    final float textShadowRadius;
    final float textShadowDy;
    final float textShadowDx;
    final int textAppearanceResId;
    final int paddingInPixels;
    final int paddingDimensionResId;

    private Style(Builder builder) {
        this.configuration = builder.configuration;
        this.backgroundColorResourceId = builder.backgroundColorResourceId;
        this.backgroundDrawableResourceId = builder.backgroundDrawableResourceId;
        this.isTileEnabled = builder.isTileEnabled;
        this.textColorResourceId = builder.textColorResourceId;
        this.heightInPixels = builder.heightInPixels;
        this.heightDimensionResId = builder.heightDimensionResId;
        this.widthInPixels = builder.widthInPixels;
        this.widthDimensionResId = builder.widthDimensionResId;
        this.gravity = builder.gravity;
        this.imageDrawable = builder.imageDrawable;
        this.textSize = builder.textSize;
        this.textShadowColorResId = builder.textShadowColorResId;
        this.textShadowRadius = builder.textShadowRadius;
        this.textShadowDx = builder.textShadowDx;
        this.textShadowDy = builder.textShadowDy;
        this.textAppearanceResId = builder.textAppearanceResId;
        this.imageResId = builder.imageResId;
        this.imageScaleType = builder.imageScaleType;
        this.paddingInPixels = builder.paddingInPixels;
        this.paddingDimensionResId = builder.paddingDimensionResId;
        this.backgroundColorValue = builder.backgroundColorValue;
    }

    public String toString() {
        return "Style{configuration=" + this.configuration + ", backgroundColorResourceId=" + this.backgroundColorResourceId + ", backgroundDrawableResourceId=" + this.backgroundDrawableResourceId + ", backgroundColorValue=" + this.backgroundColorValue + ", isTileEnabled=" + this.isTileEnabled + ", textColorResourceId=" + this.textColorResourceId + ", heightInPixels=" + this.heightInPixels + ", heightDimensionResId=" + this.heightDimensionResId + ", widthInPixels=" + this.widthInPixels + ", widthDimensionResId=" + this.widthDimensionResId + ", gravity=" + this.gravity + ", imageDrawable=" + this.imageDrawable + ", imageResId=" + this.imageResId + ", imageScaleType=" + this.imageScaleType + ", textSize=" + this.textSize + ", textShadowColorResId=" + this.textShadowColorResId + ", textShadowRadius=" + this.textShadowRadius + ", textShadowDy=" + this.textShadowDy + ", textShadowDx=" + this.textShadowDx + ", textAppearanceResId=" + this.textAppearanceResId + ", paddingInPixels=" + this.paddingInPixels + ", paddingDimensionResId=" + this.paddingDimensionResId + '}';
    }

    public static class Builder {
        private Configuration configuration;
        private int backgroundColorValue;
        private int backgroundColorResourceId;
        private int backgroundDrawableResourceId;
        private boolean isTileEnabled;
        private int textColorResourceId;
        private int heightInPixels;
        private int heightDimensionResId;
        private int widthInPixels;
        private int widthDimensionResId;
        private int gravity;
        private Drawable imageDrawable;
        private int textSize;
        private int textShadowColorResId;
        private float textShadowRadius;
        private float textShadowDx;
        private float textShadowDy;
        private int textAppearanceResId;
        private int imageResId;
        private ImageView.ScaleType imageScaleType;
        private int paddingInPixels;
        private int paddingDimensionResId;

        public Builder() {
            this.configuration = Configuration.DEFAULT;
            this.paddingInPixels = 10;
            this.backgroundColorResourceId = 17170450;
            this.backgroundDrawableResourceId = 0;
            this.backgroundColorValue = -1;
            this.isTileEnabled = false;
            this.textColorResourceId = 17170443;
            this.heightInPixels = -2;
            this.widthInPixels = -1;
            this.gravity = 17;
            this.imageDrawable = null;
            this.imageResId = 0;
            this.imageScaleType = ImageView.ScaleType.FIT_XY;
        }

        public Builder(Style baseStyle) {
            this.configuration = baseStyle.configuration;
            this.backgroundColorValue = baseStyle.backgroundColorValue;
            this.backgroundColorResourceId = baseStyle.backgroundColorResourceId;
            this.backgroundDrawableResourceId = baseStyle.backgroundDrawableResourceId;
            this.isTileEnabled = baseStyle.isTileEnabled;
            this.textColorResourceId = baseStyle.textColorResourceId;
            this.heightInPixels = baseStyle.heightInPixels;
            this.heightDimensionResId = baseStyle.heightDimensionResId;
            this.widthInPixels = baseStyle.widthInPixels;
            this.widthDimensionResId = baseStyle.widthDimensionResId;
            this.gravity = baseStyle.gravity;
            this.imageDrawable = baseStyle.imageDrawable;
            this.textSize = baseStyle.textSize;
            this.textShadowColorResId = baseStyle.textShadowColorResId;
            this.textShadowRadius = baseStyle.textShadowRadius;
            this.textShadowDx = baseStyle.textShadowDx;
            this.textShadowDy = baseStyle.textShadowDy;
            this.textAppearanceResId = baseStyle.textAppearanceResId;
            this.imageResId = baseStyle.imageResId;
            this.imageScaleType = baseStyle.imageScaleType;
            this.paddingInPixels = baseStyle.paddingInPixels;
            this.paddingDimensionResId = baseStyle.paddingDimensionResId;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setBackgroundColor(int backgroundColorResourceId) {
            this.backgroundColorResourceId = backgroundColorResourceId;
            return this;
        }

        public Builder setBackgroundColorValue(int backgroundColorValue) {
            this.backgroundColorValue = backgroundColorValue;
            return this;
        }

        public Builder setBackgroundDrawable(int backgroundDrawableResourceId) {
            this.backgroundDrawableResourceId = backgroundDrawableResourceId;
            return this;
        }

        public Builder setHeight(int height) {
            this.heightInPixels = height;
            return this;
        }

        public Builder setHeightDimensionResId(int heightDimensionResId) {
            this.heightDimensionResId = heightDimensionResId;
            return this;
        }

        public Builder setWidth(int width) {
            this.widthInPixels = width;
            return this;
        }

        public Builder setWidthDimensionResId(int widthDimensionResId) {
            this.widthDimensionResId = widthDimensionResId;
            return this;
        }

        public Builder setTileEnabled(boolean isTileEnabled) {
            this.isTileEnabled = isTileEnabled;
            return this;
        }

        public Builder setTextColor(int textColor) {
            this.textColorResourceId = textColor;
            return this;
        }

        public Builder setGravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder setImageDrawable(Drawable imageDrawable) {
            this.imageDrawable = imageDrawable;
            return this;
        }

        public Builder setImageResource(int imageResId) {
            this.imageResId = imageResId;
            return this;
        }

        public Builder setTextSize(int textSize) {
            this.textSize = textSize;
            return this;
        }

        public Builder setTextShadowColor(int textShadowColorResId) {
            this.textShadowColorResId = textShadowColorResId;
            return this;
        }

        public Builder setTextShadowRadius(float textShadowRadius) {
            this.textShadowRadius = textShadowRadius;
            return this;
        }

        public Builder setTextShadowDx(float textShadowDx) {
            this.textShadowDx = textShadowDx;
            return this;
        }

        public Builder setTextShadowDy(float textShadowDy) {
            this.textShadowDy = textShadowDy;
            return this;
        }

        public Builder setTextAppearance(int textAppearanceResId) {
            this.textAppearanceResId = textAppearanceResId;
            return this;
        }

        public Builder setImageScaleType(ImageView.ScaleType imageScaleType) {
            this.imageScaleType = imageScaleType;
            return this;
        }

        public Builder setPaddingInPixels(int padding) {
            this.paddingInPixels = padding;
            return this;
        }

        public Builder setPaddingDimensionResId(int paddingResId) {
            this.paddingDimensionResId = paddingResId;
            return this;
        }

        public Style build() {
            return new Style(this);
        }
    }
}

