/*
 * Copyright (C) 2012 J05HYYY
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.java.SmokeReducer;
import android.app.Application;
import android.content.Context;
import android.media.MediaPlayer;
//import java.io.BufferedReader;
//import java.io.File;
import java.io.*;
import java.util.Date;
//import java.lang.Number;

//Just for testing
import android.widget.Toast;

public class MyGlobals extends Application {

	private static MediaPlayer mPlayer;
	private static int onOff = 1; 
	private static int numberOfCigs = 0;
	private static float average = 0;
	private static long currentMSec;
	private static long previous = -1;
	private static Context globalContext;
	private static int buttonState = 2;
	private static int initMPlayer = 0;
	private static double gain = 0.005;
	private static boolean justSlept = true;
	private static Long publicNextTime = (long)-1;

	static public void setPublicNextTime(Long time){
		publicNextTime = time;
	}

	static public Long getPublicNextTime(){
		return publicNextTime;
	}	

	static public void hasSlept(){
		justSlept = true;
	}

	static public long isItTime(){
		//Date currentDate;
		//currentDate = new Date();
		//long currentMSecTwo = currentDate.getTime();

		long toTest = System.currentTimeMillis() - (long)(average + (average*gain*numberOfCigs));

		//Toast.makeText(globalContext, "Time now           = " + toTest , Toast.LENGTH_LONG).show();

		if (numberOfCigs < 2) //MIGHT BE WRONG!
		{
			buttonState = 2;
			//Toast.makeText(globalContext, "Two2", Toast.LENGTH_LONG).show();
			return -1;
		}
		else if (previous < toTest)
		{
			//Toast.makeText(globalContext, "it's time", Toast.LENGTH_LONG).show();
			//Toast.makeText(globalContext, "previous =" + previous, Toast.LENGTH_LONG).show();
			//Toast.makeText(globalContext, "average =" + average, Toast.LENGTH_LONG).show();
			buttonState = 3;
			return 0;
		}
		else if (previous >= toTest)
		{
			Toast.makeText(globalContext, "It's not time yet!", Toast.LENGTH_LONG).show();
			buttonState = 1;
			return (previous - toTest);
		}

		return 0;
/*
		if (numberOfCigs < 2) //MIGHT BE WRONG!
		{
			buttonState = 2;
			//Toast.makeText(globalContext, "Two2", Toast.LENGTH_LONG).show();
			return -1;
		}
		else if (toTest < 1) // current < suggested, so it's not time
		{
			//Toast.makeText(globalContext, "One1", Toast.LENGTH_LONG).show();
			//Toast.makeText(globalContext, "AAA = " + toTest, Toast.LENGTH_LONG).show();
			buttonState = 1;
			return (0 - toTest);
		}
		else // current > suggested, so it's time
		{
			buttonState = 3;
			//Toast.makeText(globalContext, "BBB = " + toTest, Toast.LENGTH_LONG).show();
			return 0;
		}
*/
	}

	static public void setButtonStateOne(){
		//sleep
		buttonState = 1;
	}

	static public void setButtonStateTwo(){
		//smoke, sleep
		buttonState = 2;
	}

	static public void setButtonStateThree(){
		//smoke, no thanks, sleep
		buttonState = 3;
	}

	static public Integer getButtonState(){
		return buttonState;
	}

	static public void init(Context context){
		mPlayer = MediaPlayer.create(context, R.raw.smoking);
		mPlayer.setLooping(true);
		globalContext = context;
		initMPlayer = 1;
	}

	static public Integer getMPlayerState(){
		return initMPlayer;
	}

	static public void loop(){
		if (!mPlayer.isPlaying()) {
		//Toast.makeText(globalContext, "One One One", Toast.LENGTH_LONG).show();
			////MyGlobals.init(globalContext);
			mPlayer.start();
		}
		else if (mPlayer == null) {
		//Toast.makeText(globalContext, "Two Two Two", Toast.LENGTH_LONG).show();
			MyGlobals.init(globalContext);
			mPlayer.start();
		}
	}

	static public void stop(){
		if (mPlayer.isPlaying()) {
    			mPlayer.pause();
			mPlayer.seekTo(0);
		}
	}

	static public void readTime(){
		try{

			File file=new File("sdcard/smoking.log");
			boolean exists = file.exists();
			if (exists) {

				// Open the file that is the first 
				// command line parameter
				FileInputStream fstream = new FileInputStream("sdcard/smoking.log");
				// Get the object of DataInputStream
				DataInputStream in = new DataInputStream(fstream);
				BufferedReader br = new BufferedReader(new InputStreamReader(in));
				String strLine;
				//Read File Line By Line
				int lineNumber = 1;
					while ((strLine = br.readLine()) != null)   {
						  // Print the content on the console
						  if ( lineNumber == 1 )
						  {
							//numberOfCigs
							numberOfCigs = Integer.parseInt(strLine);
						  }
						  else if (lineNumber == 2)
						  {
							//lastTime
							previous = Long.valueOf(strLine);
						  }
						  else if (lineNumber == 3)
						  {
							//average
							average = new Float(strLine);
						  }
						  else break;
						  ++lineNumber;
					}
				//Close the input stream
				in.close();
			}
			else
			{
				//if it doesn't exist
					int numberOfCigs = 0;
					int average = 0;
					long currentMSec = -1;
			}
		}
		catch (Exception e){
			//Catch exception if any
			System.err.println("Error: " + e.getMessage());
		}
	}

	static public void saveTime(){
			++numberOfCigs;
		// Record smoke in file
		File logFile = new File("sdcard/smoking.log");
		if (!logFile.exists())
		{
			try
			{
				logFile.createNewFile();
			} 
			catch (IOException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		else
		{
			////MyGlobals.readTime();
			logFile.delete();
				try
				{
					logFile.createNewFile();
				} 
				catch (IOException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
		}
		try
		{
			//BufferedWriter for performance, true to set append to file flag
			BufferedWriter buf = new BufferedWriter(new FileWriter(logFile, true)); 
			buf.append(String.valueOf(numberOfCigs));
			buf.newLine();
				//Date currentDate;
				//currentDate = new Date();
				//currentMSec = currentDate.getTime();
				currentMSec = System.currentTimeMillis();
				buf.append(String.valueOf(currentMSec));
			buf.newLine();
				if ( previous == -1 || justSlept == true ){
					previous = currentMSec;
					buf.append(String.valueOf(average));
				}
				//else if ( justSlept == true ){
				//	buf.append(String.valueOf(average));
				//}
				else
				{
					average = ((average * (numberOfCigs-2)) + (currentMSec - previous)) / (numberOfCigs - 1);
					buf.append(String.valueOf(average));
				}
		//Toast.makeText(globalContext, "Avg = " + average, Toast.LENGTH_LONG).show();
			buf.newLine();
			buf.close();
		}
		catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	static public boolean startOrStop(){
		if (mPlayer.isPlaying()) {
    			mPlayer.pause();
			mPlayer.seekTo(0);
			MyGlobals.readTime();
			MyGlobals.saveTime();
			justSlept = false;
			//set alarm
			return false;
		}
		else if (!mPlayer.isPlaying()) {
			////MyGlobals.init(globalContext);
			mPlayer.start();
			return true;
		}
		else if (mPlayer == null) {
			MyGlobals.init(globalContext);
			mPlayer.start();
			return true;
		}
		////else if mPlayer == null
		else return false;
	}

	static public void free(){
		initMPlayer = 0;
		if (mPlayer.isPlaying()) mPlayer.stop();
		mPlayer.release();
	}

	static public int getAverage(){//NextTime(){
		return (int)(average + (average*gain*numberOfCigs));// + (long)average;
	}
}