/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.achartengine.chart.LineChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class TimeChart
extends LineChart {
    public static final String TYPE = "Time";
    public static final long DAY = 86400000L;
    private String mDateFormat;

    TimeChart() {
    }

    public TimeChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    public String getDateFormat() {
        return this.mDateFormat;
    }

    public void setDateFormat(String string) {
        this.mDateFormat = string;
    }

    @Override
    protected void drawXLabels(List<Double> list, Double[] doubleArray, Canvas canvas, Paint paint, int n, int n2, int n3, double d, double d2, double d3) {
        int n4 = list.size();
        if (n4 > 0) {
            boolean bl = this.mRenderer.isShowLabels();
            boolean bl2 = this.mRenderer.isShowGrid();
            DateFormat dateFormat = this.getDateFormat(list.get(0), list.get(n4 - 1));
            for (int i = 0; i < n4; ++i) {
                long l = Math.round(list.get(i));
                float f = (float)((double)n + d * ((double)l - d2));
                if (bl) {
                    paint.setColor(this.mRenderer.getLabelsColor());
                    canvas.drawLine(f, (float)n3, f, (float)n3 + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                    this.drawText(canvas, dateFormat.format(new Date(l)), f, (float)n3 + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f, paint, this.mRenderer.getXLabelsAngle());
                }
                if (!bl2) continue;
                paint.setColor(this.mRenderer.getGridColor());
                canvas.drawLine(f, (float)n3, f, (float)n2, paint);
            }
        }
        this.drawXTextLabels(doubleArray, canvas, paint, true, n, n2, n3, d, d2, d3);
    }

    private DateFormat getDateFormat(double d, double d2) {
        DateFormat dateFormat;
        if (this.mDateFormat != null) {
            dateFormat = null;
            try {
                dateFormat = new SimpleDateFormat(this.mDateFormat);
                return dateFormat;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dateFormat = SimpleDateFormat.getDateInstance(2);
        double d3 = d2 - d;
        if (d3 > 8.64E7 && d3 < 4.32E8) {
            dateFormat = SimpleDateFormat.getDateTimeInstance(3, 3);
        } else if (d3 < 8.64E7) {
            dateFormat = SimpleDateFormat.getTimeInstance(2);
        }
        return dateFormat;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

