/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.renderer;

import android.graphics.Color;
import android.graphics.Paint;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;

public class XYMultipleSeriesRenderer
extends DefaultRenderer {
    private String mXTitle = "";
    private String[] mYTitle;
    private float mAxisTitleTextSize = 12.0f;
    private double[] mMinX;
    private double[] mMaxX;
    private double[] mMinY;
    private double[] mMaxY;
    private int mXLabels = 5;
    private int mYLabels = 5;
    private Orientation mOrientation = Orientation.HORIZONTAL;
    private Map<Double, String> mXTextLabels = new HashMap<Double, String>();
    private Map<Integer, Map<Double, String>> mYTextLabels = new LinkedHashMap<Integer, Map<Double, String>>();
    private boolean mPanXEnabled = true;
    private boolean mPanYEnabled = true;
    private boolean mZoomXEnabled = true;
    private boolean mZoomYEnabled = true;
    private double mBarSpacing = 0.0;
    private int mMarginsColor = 0;
    private double[] mPanLimits;
    private double[] mZoomLimits;
    private float mXLabelsAngle;
    private float mYLabelsAngle;
    private Map<Integer, double[]> initialRange = new LinkedHashMap<Integer, double[]>();
    private float mPointSize = 3.0f;
    private int mGridColor = Color.argb((int)75, (int)200, (int)200, (int)200);
    private int scalesCount;
    private Paint.Align xLabelsAlign = Paint.Align.CENTER;
    private Paint.Align[] yLabelsAlign;
    private Paint.Align[] yAxisAlign;

    public XYMultipleSeriesRenderer() {
        this(1);
    }

    public XYMultipleSeriesRenderer(int n) {
        this.scalesCount = n;
        this.initAxesRange(n);
    }

    public void initAxesRange(int n) {
        this.mYTitle = new String[n];
        this.yLabelsAlign = new Paint.Align[n];
        this.yAxisAlign = new Paint.Align[n];
        this.mMinX = new double[n];
        this.mMaxX = new double[n];
        this.mMinY = new double[n];
        this.mMaxY = new double[n];
        for (int i = 0; i < n; ++i) {
            this.initAxesRangeForScale(i);
        }
    }

    public void initAxesRangeForScale(int n) {
        this.mMinX[n] = Double.MAX_VALUE;
        this.mMaxX[n] = -1.7976931348623157E308;
        this.mMinY[n] = Double.MAX_VALUE;
        this.mMaxY[n] = -1.7976931348623157E308;
        double[] dArray = new double[]{this.mMinX[n], this.mMaxX[n], this.mMinY[n], this.mMaxY[n]};
        this.initialRange.put(n, dArray);
        this.mYTitle[n] = "";
        this.mYTextLabels.put(n, new HashMap());
        this.yLabelsAlign[n] = Paint.Align.CENTER;
        this.yAxisAlign[n] = Paint.Align.LEFT;
    }

    public Orientation getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(Orientation orientation) {
        this.mOrientation = orientation;
    }

    public String getXTitle() {
        return this.mXTitle;
    }

    public void setXTitle(String string) {
        this.mXTitle = string;
    }

    public String getYTitle() {
        return this.getYTitle(0);
    }

    public String getYTitle(int n) {
        return this.mYTitle[n];
    }

    public void setYTitle(String string) {
        this.setYTitle(string, 0);
    }

    public void setYTitle(String string, int n) {
        this.mYTitle[n] = string;
    }

    public float getAxisTitleTextSize() {
        return this.mAxisTitleTextSize;
    }

    public void setAxisTitleTextSize(float f) {
        this.mAxisTitleTextSize = f;
    }

    public double getXAxisMin() {
        return this.getXAxisMin(0);
    }

    public void setXAxisMin(double d) {
        this.setXAxisMin(d, 0);
    }

    public boolean isMinXSet() {
        return this.isMinXSet(0);
    }

    public double getXAxisMax() {
        return this.getXAxisMax(0);
    }

    public void setXAxisMax(double d) {
        this.setXAxisMax(d, 0);
    }

    public boolean isMaxXSet() {
        return this.isMaxXSet(0);
    }

    public double getYAxisMin() {
        return this.getYAxisMin(0);
    }

    public void setYAxisMin(double d) {
        this.setYAxisMin(d, 0);
    }

    public boolean isMinYSet() {
        return this.isMinYSet(0);
    }

    public double getYAxisMax() {
        return this.getYAxisMax(0);
    }

    public void setYAxisMax(double d) {
        this.setYAxisMax(d, 0);
    }

    public boolean isMaxYSet() {
        return this.isMaxYSet(0);
    }

    public double getXAxisMin(int n) {
        return this.mMinX[n];
    }

    public void setXAxisMin(double d, int n) {
        if (!this.isMinXSet(n)) {
            this.initialRange.get((Object)Integer.valueOf((int)n))[0] = d;
        }
        this.mMinX[n] = d;
    }

    public boolean isMinXSet(int n) {
        return this.mMinX[n] != Double.MAX_VALUE;
    }

    public double getXAxisMax(int n) {
        return this.mMaxX[n];
    }

    public void setXAxisMax(double d, int n) {
        if (!this.isMaxXSet(n)) {
            this.initialRange.get((Object)Integer.valueOf((int)n))[1] = d;
        }
        this.mMaxX[n] = d;
    }

    public boolean isMaxXSet(int n) {
        return this.mMaxX[n] != -1.7976931348623157E308;
    }

    public double getYAxisMin(int n) {
        return this.mMinY[n];
    }

    public void setYAxisMin(double d, int n) {
        if (!this.isMinYSet(n)) {
            this.initialRange.get((Object)Integer.valueOf((int)n))[2] = d;
        }
        this.mMinY[n] = d;
    }

    public boolean isMinYSet(int n) {
        return this.mMinY[n] != Double.MAX_VALUE;
    }

    public double getYAxisMax(int n) {
        return this.mMaxY[n];
    }

    public void setYAxisMax(double d, int n) {
        if (!this.isMaxYSet(n)) {
            this.initialRange.get((Object)Integer.valueOf((int)n))[3] = d;
        }
        this.mMaxY[n] = d;
    }

    public boolean isMaxYSet(int n) {
        return this.mMaxY[n] != -1.7976931348623157E308;
    }

    public int getXLabels() {
        return this.mXLabels;
    }

    public void setXLabels(int n) {
        this.mXLabels = n;
    }

    public void addTextLabel(double d, String string) {
        this.addXTextLabel(d, string);
    }

    public void addXTextLabel(double d, String string) {
        this.mXTextLabels.put(d, string);
    }

    public String getXTextLabel(Double d) {
        return this.mXTextLabels.get(d);
    }

    public Double[] getXTextLabelLocations() {
        return this.mXTextLabels.keySet().toArray(new Double[0]);
    }

    public void clearTextLabels() {
        this.clearXTextLabels();
    }

    public void clearXTextLabels() {
        this.mXTextLabels.clear();
    }

    public void addYTextLabel(double d, String string) {
        this.addYTextLabel(d, string, 0);
    }

    public void addYTextLabel(double d, String string, int n) {
        this.mYTextLabels.get(n).put(d, string);
    }

    public String getYTextLabel(Double d) {
        return this.getYTextLabel(d, 0);
    }

    public String getYTextLabel(Double d, int n) {
        return this.mYTextLabels.get(n).get(d);
    }

    public Double[] getYTextLabelLocations() {
        return this.getYTextLabelLocations(0);
    }

    public Double[] getYTextLabelLocations(int n) {
        return this.mYTextLabels.get(n).keySet().toArray(new Double[0]);
    }

    public void clearYTextLabels() {
        this.mYTextLabels.clear();
    }

    public int getYLabels() {
        return this.mYLabels;
    }

    public void setYLabels(int n) {
        this.mYLabels = n;
    }

    public void setDisplayChartValues(boolean bl) {
        SimpleSeriesRenderer[] simpleSeriesRendererArray;
        for (SimpleSeriesRenderer simpleSeriesRenderer : simpleSeriesRendererArray = this.getSeriesRenderers()) {
            simpleSeriesRenderer.setDisplayChartValues(bl);
        }
    }

    public void setChartValuesTextSize(float f) {
        SimpleSeriesRenderer[] simpleSeriesRendererArray;
        for (SimpleSeriesRenderer simpleSeriesRenderer : simpleSeriesRendererArray = this.getSeriesRenderers()) {
            simpleSeriesRenderer.setChartValuesTextSize(f);
        }
    }

    @Override
    public boolean isPanEnabled() {
        return this.isPanXEnabled() || this.isPanYEnabled();
    }

    public boolean isPanXEnabled() {
        return this.mPanXEnabled;
    }

    public boolean isPanYEnabled() {
        return this.mPanYEnabled;
    }

    public void setPanEnabled(boolean bl, boolean bl2) {
        this.mPanXEnabled = bl;
        this.mPanYEnabled = bl2;
    }

    @Override
    public boolean isZoomEnabled() {
        return this.isZoomXEnabled() || this.isZoomYEnabled();
    }

    public boolean isZoomXEnabled() {
        return this.mZoomXEnabled;
    }

    public boolean isZoomYEnabled() {
        return this.mZoomYEnabled;
    }

    public void setZoomEnabled(boolean bl, boolean bl2) {
        this.mZoomXEnabled = bl;
        this.mZoomYEnabled = bl2;
    }

    public double getBarsSpacing() {
        return this.getBarSpacing();
    }

    public double getBarSpacing() {
        return this.mBarSpacing;
    }

    public void setBarSpacing(double d) {
        this.mBarSpacing = d;
    }

    public int getMarginsColor() {
        return this.mMarginsColor;
    }

    public void setMarginsColor(int n) {
        this.mMarginsColor = n;
    }

    public int getGridColor() {
        return this.mGridColor;
    }

    public void setGridColor(int n) {
        this.mGridColor = n;
    }

    public double[] getPanLimits() {
        return this.mPanLimits;
    }

    public void setPanLimits(double[] dArray) {
        this.mPanLimits = dArray;
    }

    public double[] getZoomLimits() {
        return this.mZoomLimits;
    }

    public void setZoomLimits(double[] dArray) {
        this.mZoomLimits = dArray;
    }

    public float getXLabelsAngle() {
        return this.mXLabelsAngle;
    }

    public void setXLabelsAngle(float f) {
        this.mXLabelsAngle = f;
    }

    public float getYLabelsAngle() {
        return this.mYLabelsAngle;
    }

    public void setYLabelsAngle(float f) {
        this.mYLabelsAngle = f;
    }

    public float getPointSize() {
        return this.mPointSize;
    }

    public void setPointSize(float f) {
        this.mPointSize = f;
    }

    public void setRange(double[] dArray) {
        this.setRange(dArray, 0);
    }

    public void setRange(double[] dArray, int n) {
        this.setXAxisMin(dArray[0], n);
        this.setXAxisMax(dArray[1], n);
        this.setYAxisMin(dArray[2], n);
        this.setYAxisMax(dArray[3], n);
    }

    public boolean isInitialRangeSet() {
        return this.isInitialRangeSet(0);
    }

    public boolean isInitialRangeSet(int n) {
        return this.initialRange.get(n) != null;
    }

    public double[] getInitialRange() {
        return this.getInitialRange(0);
    }

    public double[] getInitialRange(int n) {
        return this.initialRange.get(n);
    }

    public void setInitialRange(double[] dArray) {
        this.setInitialRange(dArray, 0);
    }

    public void setInitialRange(double[] dArray, int n) {
        this.initialRange.put(n, dArray);
    }

    public Paint.Align getXLabelsAlign() {
        return this.xLabelsAlign;
    }

    public void setXLabelsAlign(Paint.Align align) {
        this.xLabelsAlign = align;
    }

    public Paint.Align getYLabelsAlign(int n) {
        return this.yLabelsAlign[n];
    }

    public void setYLabelsAlign(Paint.Align align) {
        this.setYLabelsAlign(align, 0);
    }

    public Paint.Align getYAxisAlign(int n) {
        return this.yAxisAlign[n];
    }

    public void setYAxisAlign(Paint.Align align, int n) {
        this.yAxisAlign[n] = align;
    }

    public void setYLabelsAlign(Paint.Align align, int n) {
        this.yLabelsAlign[n] = align;
    }

    public int getScalesCount() {
        return this.scalesCount;
    }

    public static enum Orientation {
        HORIZONTAL(0),
        VERTICAL(90);

        private int mAngle = 0;

        private Orientation(int n2) {
            this.mAngle = n2;
        }

        public int getAngle() {
            return this.mAngle;
        }
    }
}

