/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.achartengine.chart.PointStyle;
import org.achartengine.chart.ScatterChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class LineChart
extends XYChart {
    public static final String TYPE = "Line";
    private static final int SHAPE_WIDTH = 30;
    private ScatterChart pointsChart;

    LineChart() {
    }

    public LineChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.pointsChart = new ScatterChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super.setDatasetRenderer(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.pointsChart = new ScatterChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n) {
        int n2 = fArray.length;
        XYSeriesRenderer xYSeriesRenderer = (XYSeriesRenderer)simpleSeriesRenderer;
        float f2 = paint.getStrokeWidth();
        paint.setStrokeWidth(xYSeriesRenderer.getLineWidth());
        if (xYSeriesRenderer.isFillBelowLine()) {
            paint.setColor(xYSeriesRenderer.getFillBelowLineColor());
            int n3 = fArray.length;
            float[] fArray2 = new float[n3 + 4];
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            fArray2[0] = fArray[0] + 1.0f;
            fArray2[n2] = fArray2[n2 - 2];
            fArray2[n2 + 1] = f;
            fArray2[n2 + 2] = fArray2[0];
            fArray2[n2 + 3] = fArray2[n2 + 1];
            paint.setStyle(Paint.Style.FILL);
            this.drawPath(canvas, fArray2, paint, true);
        }
        paint.setColor(simpleSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.STROKE);
        this.drawPath(canvas, fArray, paint, false);
        paint.setStrokeWidth(f2);
    }

    @Override
    protected RectF[] clickableAreasForPoints(float[] fArray, float f, int n) {
        int n2 = fArray.length;
        RectF[] rectFArray = new RectF[n2 / 2];
        for (int i = 0; i < n2; i += 2) {
            int n3 = this.mRenderer.getSelectableBuffer();
            rectFArray[i / 2] = new RectF(fArray[i] - (float)n3, fArray[i + 1] - (float)n3, fArray[i] + (float)n3, fArray[i + 1] + (float)n3);
        }
        return rectFArray;
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return 30;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        canvas.drawLine(f, f2, f + 30.0f, f2, paint);
        if (this.isRenderPoints(simpleSeriesRenderer)) {
            this.pointsChart.drawLegendShape(canvas, simpleSeriesRenderer, f + 5.0f, f2, n, paint);
        }
    }

    @Override
    public boolean isRenderPoints(SimpleSeriesRenderer simpleSeriesRenderer) {
        return ((XYSeriesRenderer)simpleSeriesRenderer).getPointStyle() != PointStyle.POINT;
    }

    @Override
    public ScatterChart getPointsChart() {
        return this.pointsChart;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

