/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine;

import android.content.Context;
import android.content.Intent;
import java.io.Serializable;
import org.achartengine.GraphicalActivity;
import org.achartengine.GraphicalView;
import org.achartengine.chart.BarChart;
import org.achartengine.chart.BubbleChart;
import org.achartengine.chart.CombinedXYChart;
import org.achartengine.chart.CubicLineChart;
import org.achartengine.chart.DialChart;
import org.achartengine.chart.DoughnutChart;
import org.achartengine.chart.LineChart;
import org.achartengine.chart.PieChart;
import org.achartengine.chart.RangeBarChart;
import org.achartengine.chart.ScatterChart;
import org.achartengine.chart.TimeChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.model.MultipleCategorySeries;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.DialRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class ChartFactory {
    public static final String CHART = "chart";
    public static final String TITLE = "title";

    private ChartFactory() {
    }

    public static final GraphicalView getLineChartView(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        LineChart lineChart = new LineChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        return new GraphicalView(context, lineChart);
    }

    public static final GraphicalView getCubeLineChartView(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, float f) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        CubicLineChart cubicLineChart = new CubicLineChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, f);
        return new GraphicalView(context, cubicLineChart);
    }

    public static final GraphicalView getScatterChartView(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        ScatterChart scatterChart = new ScatterChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        return new GraphicalView(context, scatterChart);
    }

    public static final GraphicalView getBubbleChartView(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        BubbleChart bubbleChart = new BubbleChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        return new GraphicalView(context, bubbleChart);
    }

    public static final GraphicalView getTimeChartView(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String string) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        TimeChart timeChart = new TimeChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        timeChart.setDateFormat(string);
        return new GraphicalView(context, timeChart);
    }

    public static final GraphicalView getBarChartView(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, BarChart.Type type) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        BarChart barChart = new BarChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, type);
        return new GraphicalView(context, barChart);
    }

    public static final GraphicalView getRangeBarChartView(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, BarChart.Type type) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        RangeBarChart rangeBarChart = new RangeBarChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, type);
        return new GraphicalView(context, rangeBarChart);
    }

    public static final GraphicalView getCombinedXYChartView(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String[] stringArray) {
        if (xYMultipleSeriesDataset == null || xYMultipleSeriesRenderer == null || stringArray == null || xYMultipleSeriesDataset.getSeriesCount() != stringArray.length) {
            throw new IllegalArgumentException("Dataset, renderer and types should be not null and the datasets series count should be equal to the types length");
        }
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        CombinedXYChart combinedXYChart = new CombinedXYChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, stringArray);
        return new GraphicalView(context, combinedXYChart);
    }

    public static final GraphicalView getPieChartView(Context context, CategorySeries categorySeries, DefaultRenderer defaultRenderer) {
        ChartFactory.checkParameters(categorySeries, defaultRenderer);
        PieChart pieChart = new PieChart(categorySeries, defaultRenderer);
        return new GraphicalView(context, pieChart);
    }

    public static final GraphicalView getDialChartView(Context context, CategorySeries categorySeries, DialRenderer dialRenderer) {
        ChartFactory.checkParameters(categorySeries, (DefaultRenderer)dialRenderer);
        DialChart dialChart = new DialChart(categorySeries, dialRenderer);
        return new GraphicalView(context, dialChart);
    }

    public static final GraphicalView getDoughnutChartView(Context context, MultipleCategorySeries multipleCategorySeries, DefaultRenderer defaultRenderer) {
        ChartFactory.checkParameters(multipleCategorySeries, defaultRenderer);
        DoughnutChart doughnutChart = new DoughnutChart(multipleCategorySeries, defaultRenderer);
        return new GraphicalView(context, doughnutChart);
    }

    public static final Intent getLineChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        return ChartFactory.getLineChartIntent(context, xYMultipleSeriesDataset, xYMultipleSeriesRenderer, "");
    }

    public static final Intent getCubicLineChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, float f) {
        return ChartFactory.getCubicLineChartIntent(context, xYMultipleSeriesDataset, xYMultipleSeriesRenderer, f, "");
    }

    public static final Intent getScatterChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        return ChartFactory.getScatterChartIntent(context, xYMultipleSeriesDataset, xYMultipleSeriesRenderer, "");
    }

    public static final Intent getBubbleChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        return ChartFactory.getBubbleChartIntent(context, xYMultipleSeriesDataset, xYMultipleSeriesRenderer, "");
    }

    public static final Intent getTimeChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String string) {
        return ChartFactory.getTimeChartIntent(context, xYMultipleSeriesDataset, xYMultipleSeriesRenderer, string, "");
    }

    public static final Intent getBarChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, BarChart.Type type) {
        return ChartFactory.getBarChartIntent(context, xYMultipleSeriesDataset, xYMultipleSeriesRenderer, type, "");
    }

    public static final Intent getLineChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String string) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        LineChart lineChart = new LineChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        intent.putExtra(CHART, (Serializable)lineChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    public static final Intent getCubicLineChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, float f, String string) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        CubicLineChart cubicLineChart = new CubicLineChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, f);
        intent.putExtra(CHART, (Serializable)cubicLineChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    public static final Intent getScatterChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String string) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        ScatterChart scatterChart = new ScatterChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        intent.putExtra(CHART, (Serializable)scatterChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    public static final Intent getBubbleChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String string) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        BubbleChart bubbleChart = new BubbleChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        intent.putExtra(CHART, (Serializable)bubbleChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    public static final Intent getTimeChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String string, String string2) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        TimeChart timeChart = new TimeChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        timeChart.setDateFormat(string);
        intent.putExtra(CHART, (Serializable)timeChart);
        intent.putExtra(TITLE, string2);
        return intent;
    }

    public static final Intent getBarChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, BarChart.Type type, String string) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        BarChart barChart = new BarChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, type);
        intent.putExtra(CHART, (Serializable)barChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    public static final Intent getRangeBarChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, BarChart.Type type, String string) {
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        RangeBarChart rangeBarChart = new RangeBarChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, type);
        intent.putExtra(CHART, (Serializable)rangeBarChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    public static final Intent getCombinedXYChartIntent(Context context, XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String[] stringArray, String string) {
        if (xYMultipleSeriesDataset == null || xYMultipleSeriesRenderer == null || stringArray == null || xYMultipleSeriesDataset.getSeriesCount() != stringArray.length) {
            throw new IllegalArgumentException("Datasets, renderers and types should be not null and the datasets series count should be equal to the types length");
        }
        ChartFactory.checkParameters(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        CombinedXYChart combinedXYChart = new CombinedXYChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, stringArray);
        intent.putExtra(CHART, (Serializable)combinedXYChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    public static final Intent getPieChartIntent(Context context, CategorySeries categorySeries, DefaultRenderer defaultRenderer, String string) {
        ChartFactory.checkParameters(categorySeries, defaultRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        PieChart pieChart = new PieChart(categorySeries, defaultRenderer);
        intent.putExtra(CHART, (Serializable)pieChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    public static final Intent getDoughnutChartIntent(Context context, MultipleCategorySeries multipleCategorySeries, DefaultRenderer defaultRenderer, String string) {
        ChartFactory.checkParameters(multipleCategorySeries, defaultRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        DoughnutChart doughnutChart = new DoughnutChart(multipleCategorySeries, defaultRenderer);
        intent.putExtra(CHART, (Serializable)doughnutChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    public static final Intent getDialChartIntent(Context context, CategorySeries categorySeries, DialRenderer dialRenderer, String string) {
        ChartFactory.checkParameters(categorySeries, (DefaultRenderer)dialRenderer);
        Intent intent = new Intent(context, GraphicalActivity.class);
        DialChart dialChart = new DialChart(categorySeries, dialRenderer);
        intent.putExtra(CHART, (Serializable)dialChart);
        intent.putExtra(TITLE, string);
        return intent;
    }

    private static void checkParameters(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        if (xYMultipleSeriesDataset == null || xYMultipleSeriesRenderer == null || xYMultipleSeriesDataset.getSeriesCount() != xYMultipleSeriesRenderer.getSeriesRendererCount()) {
            throw new IllegalArgumentException("Dataset and renderer should be not null and should have the same number of series");
        }
    }

    private static void checkParameters(CategorySeries categorySeries, DefaultRenderer defaultRenderer) {
        if (categorySeries == null || defaultRenderer == null || categorySeries.getItemCount() != defaultRenderer.getSeriesRendererCount()) {
            throw new IllegalArgumentException("Dataset and renderer should be not null and the dataset number of items should be equal to the number of series renderers");
        }
    }

    private static void checkParameters(MultipleCategorySeries multipleCategorySeries, DefaultRenderer defaultRenderer) {
        if (multipleCategorySeries == null || defaultRenderer == null || !ChartFactory.checkMultipleSeriesItems(multipleCategorySeries, defaultRenderer.getSeriesRendererCount())) {
            throw new IllegalArgumentException("Titles and values should be not null and the dataset number of items should be equal to the number of series renderers");
        }
    }

    private static boolean checkMultipleSeriesItems(MultipleCategorySeries multipleCategorySeries, int n) {
        int n2 = multipleCategorySeries.getCategoriesCount();
        boolean bl = true;
        for (int i = 0; i < n2 && bl; ++i) {
            bl = multipleCategorySeries.getValues(i).length == multipleCategorySeries.getTitles(i).length;
        }
        return bl;
    }
}

