/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.tiled;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.tiled.TileSet;
import com.badlogic.gdx.graphics.g2d.tiled.TiledMap;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.IntMap;
import java.util.HashSet;
import java.util.StringTokenizer;

public class TileAtlas
implements Disposable {
    protected IntMap<TextureRegion> regionsMap = new IntMap();
    protected final HashSet<Texture> textures = new HashSet(1);

    protected TileAtlas() {
    }

    public TileAtlas(TiledMap map, FileHandle inputDir) {
        for (TileSet set : map.tileSets) {
            FileHandle packfile = TileAtlas.getRelativeFileHandle(inputDir, TileAtlas.removeExtension(set.imageName) + " packfile");
            TextureAtlas textureAtlas = new TextureAtlas(packfile, packfile.parent(), false);
            Array<TextureAtlas.AtlasRegion> atlasRegions = textureAtlas.findRegions(TileAtlas.removeExtension(TileAtlas.removePath(set.imageName)));
            for (TextureAtlas.AtlasRegion reg : atlasRegions) {
                this.regionsMap.put(reg.index + set.firstgid, reg);
                if (this.textures.contains(reg.getTexture())) continue;
                this.textures.add(reg.getTexture());
            }
        }
    }

    public TextureRegion getRegion(int id) {
        return this.regionsMap.get(id);
    }

    @Override
    public void dispose() {
        for (Texture texture : this.textures) {
            texture.dispose();
        }
        this.textures.clear();
    }

    private static String removeExtension(String s) {
        int extensionIndex = s.lastIndexOf(".");
        if (extensionIndex == -1) {
            return s;
        }
        return s.substring(0, extensionIndex);
    }

    private static String removePath(String s) {
        int index = s.lastIndexOf(92);
        String temp = index != -1 ? s.substring(index + 1) : s;
        index = temp.lastIndexOf(47);
        if (index != -1) {
            return s.substring(index + 1);
        }
        return s;
    }

    private static FileHandle getRelativeFileHandle(FileHandle path, String relativePath) {
        if (relativePath.trim().length() == 0) {
            return path;
        }
        FileHandle child = path;
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "\\/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("..")) {
                child = child.parent();
                continue;
            }
            child = child.child(token);
        }
        return child;
    }

    public void flipRegions(boolean x, boolean y) {
        for (TextureRegion region : this.regionsMap.values()) {
            region.flip(x, y);
        }
    }
}

