/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.materials;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Pool;

public class ColorAttribute
extends MaterialAttribute {
    public static final String diffuse = "diffuseColor";
    public static final String specular = "specularColor";
    public static final String emissive = "emissiveColor";
    public static final String rim = "rimColor";
    public static final String fog = "fogColor";
    public final Color color = new Color();
    private static final Pool<ColorAttribute> pool = new Pool<ColorAttribute>(){

        @Override
        protected ColorAttribute newObject() {
            return new ColorAttribute();
        }
    };

    protected ColorAttribute() {
    }

    public ColorAttribute(Color color, String name) {
        super(name);
        this.color.set(color);
    }

    @Override
    public void bind() {
        if (Gdx.gl10 == null) {
            throw new RuntimeException("Can't call ColorAttribute.bind() in a GL20 context");
        }
        if (diffuse.equals(diffuse)) {
            Gdx.gl10.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        }
    }

    @Override
    public void bind(ShaderProgram program) {
        program.setUniformf(this.name, this.color.r, this.color.g, this.color.b, this.color.a);
    }

    @Override
    public MaterialAttribute copy() {
        return new ColorAttribute(this.color, this.name);
    }

    @Override
    public void set(MaterialAttribute attr) {
        ColorAttribute colAttr = (ColorAttribute)attr;
        this.name = colAttr.name;
        Color c = colAttr.color;
        this.color.r = c.r;
        this.color.g = c.g;
        this.color.b = c.b;
        this.color.a = c.a;
    }

    @Override
    public MaterialAttribute pooledCopy() {
        ColorAttribute attr = pool.obtain();
        attr.set(this);
        return attr;
    }

    @Override
    public void free() {
        if (this.isPooled) {
            pool.free(this);
        }
    }
}

