/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.materials;

import com.badlogic.gdx.graphics.g3d.materials.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.g3d.materials.TextureAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;
import java.util.Iterator;

public class Material
implements Iterable<MaterialAttribute> {
    protected String name;
    private Array<MaterialAttribute> attributes;
    protected boolean needBlending;
    protected boolean hasTexture;
    protected ShaderProgram shader;

    public Material() {
        this.attributes = new Array(2);
    }

    public Material(String name, Array<MaterialAttribute> attributes) {
        this.name = name;
        this.attributes = attributes;
        this.checkAttributes();
    }

    public Material(String name, MaterialAttribute ... attributes) {
        this(name, new Array<MaterialAttribute>(attributes));
    }

    protected void checkAttributes() {
        this.needBlending = false;
        this.hasTexture = false;
        for (int i = 0; i < this.attributes.size; ++i) {
            if (!this.needBlending && this.attributes.get(i) instanceof BlendingAttribute) {
                this.needBlending = true;
                continue;
            }
            if (this.hasTexture || !(this.attributes.get(i) instanceof TextureAttribute)) continue;
            this.hasTexture = true;
        }
    }

    public void bind() {
        for (int i = 0; i < this.attributes.size; ++i) {
            this.attributes.get(i).bind();
        }
    }

    public void bind(ShaderProgram program) {
        for (int i = 0; i < this.attributes.size; ++i) {
            this.attributes.get(i).bind(program);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addAttribute(MaterialAttribute ... attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i] instanceof BlendingAttribute) {
                this.needBlending = true;
            } else if (attributes[i] instanceof TextureAttribute) {
                this.hasTexture = true;
            }
            this.attributes.add(attributes[i]);
        }
    }

    public void removeAttribute(MaterialAttribute ... attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            this.attributes.removeValue(attributes[i], true);
        }
        this.checkAttributes();
    }

    public void clearAttributes() {
        this.attributes.clear();
        this.needBlending = false;
    }

    public MaterialAttribute getAttribute(int index) {
        if (index >= 0 && index < this.attributes.size) {
            return this.attributes.get(index);
        }
        return null;
    }

    public int getNumberOfAttributes() {
        return this.attributes.size;
    }

    public Material copy() {
        Array<MaterialAttribute> attributes = new Array<MaterialAttribute>(this.attributes.size);
        for (int i = 0; i < attributes.size; ++i) {
            attributes.add(this.attributes.get(i).copy());
        }
        Material copy = new Material(this.name, attributes);
        copy.shader = this.shader;
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Material other = (Material)obj;
        if (other.attributes.size != this.attributes.size) {
            return false;
        }
        for (int i = 0; i < this.attributes.size; ++i) {
            if (this.attributes.get(i).equals(other.attributes.get(i))) continue;
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean shaderEquals(Material other) {
        if (this == other) {
            return true;
        }
        int len = this.attributes.size;
        if (len != other.attributes.size) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            String str = this.attributes.get((int)i).name;
            if (str == null) {
                return false;
            }
            boolean matchFound = false;
            for (int j = 0; j < len; ++j) {
                if (!str.equals(other.attributes.get((int)j).name)) continue;
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public void setPooled(Material material) {
        this.name = material.name;
        this.shader = material.shader;
        this.needBlending = material.needBlending;
        this.hasTexture = material.hasTexture;
        this.attributes.clear();
        int len = material.attributes.size;
        for (int i = 0; i < len; ++i) {
            this.attributes.add(material.attributes.get(i).pooledCopy());
        }
    }

    public boolean isNeedBlending() {
        return this.needBlending;
    }

    public boolean hasTexture() {
        return this.hasTexture;
    }

    public ShaderProgram getShader() {
        return this.shader;
    }

    public void setShader(ShaderProgram shader) {
        this.shader = shader;
    }

    public void resetShader() {
        this.shader = null;
    }

    @Override
    public Iterator<MaterialAttribute> iterator() {
        return this.attributes.iterator();
    }
}

