/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer10;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TableToolkit;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;
import com.esotericsoftware.tablelayout.BaseTableLayout;
import com.esotericsoftware.tablelayout.Cell;
import com.esotericsoftware.tablelayout.Toolkit;
import java.util.List;

class TableLayout
extends BaseTableLayout<Actor, Table, TableLayout, TableToolkit> {
    Array<TableToolkit.DebugRect> debugRects;
    private ImmediateModeRenderer debugRenderer;
    boolean round = true;

    public TableLayout() {
        super((TableToolkit)Toolkit.instance);
    }

    public void layout() {
        Actor actor;
        float widgetY;
        float widgetX;
        float widgetHeight;
        float widgetWidth;
        Cell c;
        int i;
        int n;
        Table table = (Table)this.getTable();
        float width = table.getWidth();
        float height = table.getHeight();
        super.layout(0.0f, 0.0f, width, height);
        List<Cell> cells = this.getCells();
        if (this.round) {
            n = cells.size();
            for (i = 0; i < n; ++i) {
                c = cells.get(i);
                if (c.getIgnore()) continue;
                widgetWidth = Math.round(c.getWidgetWidth());
                widgetHeight = Math.round(c.getWidgetHeight());
                widgetX = Math.round(c.getWidgetX());
                widgetY = height - (float)Math.round(c.getWidgetY()) - widgetHeight;
                c.setWidgetX(widgetX);
                c.setWidgetY(widgetY);
                c.setWidgetWidth(widgetWidth);
                c.setWidgetHeight(widgetHeight);
                actor = (Actor)c.getWidget();
                if (actor == null) continue;
                actor.setX(widgetX);
                actor.setY(widgetY);
                if (actor.getWidth() == widgetWidth && actor.getHeight() == widgetHeight) continue;
                actor.setWidth(widgetWidth);
                actor.setHeight(widgetHeight);
                if (!(actor instanceof Layout)) continue;
                ((Layout)((Object)actor)).invalidate();
            }
        } else {
            n = cells.size();
            for (i = 0; i < n; ++i) {
                c = cells.get(i);
                if (c.getIgnore()) continue;
                widgetWidth = c.getWidgetWidth();
                widgetHeight = c.getWidgetHeight();
                widgetX = c.getWidgetX();
                widgetY = height - c.getWidgetY() - widgetHeight;
                c.setWidgetX(widgetX);
                c.setWidgetY(widgetY);
                c.setWidgetWidth(widgetWidth);
                c.setWidgetHeight(widgetHeight);
                actor = (Actor)c.getWidget();
                if (actor == null) continue;
                actor.setX(widgetX);
                actor.setY(widgetY);
                if (actor.getWidth() == widgetWidth && actor.getHeight() == widgetHeight) continue;
                actor.setWidth(widgetWidth);
                actor.setHeight(widgetHeight);
                if (!(actor instanceof Layout)) continue;
                ((Layout)((Object)actor)).invalidate();
            }
        }
        SnapshotArray<Actor> children = table.getChildren();
        int n2 = children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Actor child = (Actor)children.get(i2);
            if (!(child instanceof Layout)) continue;
            ((Layout)((Object)child)).validate();
        }
    }

    @Override
    public void invalidateHierarchy() {
        super.invalidate();
        ((Table)this.getTable()).invalidateHierarchy();
    }

    private void toStageCoordinates(Actor actor, Vector2 point) {
        point.x += actor.getX();
        point.y += actor.getY();
        this.toStageCoordinates(actor.getParent(), point);
    }

    public void drawDebug(SpriteBatch batch) {
        if (this.getDebug() == BaseTableLayout.Debug.none || this.debugRects == null) {
            return;
        }
        if (this.debugRenderer == null) {
            this.debugRenderer = Gdx.graphics.isGL20Available() ? new ImmediateModeRenderer20(64, false, true, 0) : new ImmediateModeRenderer10(64);
        }
        float x = 0.0f;
        float y = 0.0f;
        for (Actor parent = (Actor)this.getTable(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Group)) continue;
            x += parent.getX();
            y += parent.getY();
        }
        this.debugRenderer.begin(batch.getProjectionMatrix(), 1);
        int n = this.debugRects.size;
        for (int i = 0; i < n; ++i) {
            TableToolkit.DebugRect rect = this.debugRects.get(i);
            float x1 = x + rect.x;
            float y1 = y + rect.y - rect.height;
            float x2 = x1 + rect.width;
            float y2 = y1 + rect.height;
            float r = rect.type == BaseTableLayout.Debug.cell ? 1.0f : 0.0f;
            float g = rect.type == BaseTableLayout.Debug.widget ? 1.0f : 0.0f;
            float b = rect.type == BaseTableLayout.Debug.table ? 1.0f : 0.0f;
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y1, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y1, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y1, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y1, 0.0f);
            if (this.debugRenderer.getNumVertices() != 64) continue;
            this.debugRenderer.end();
            this.debugRenderer.begin(batch.getProjectionMatrix(), 1);
        }
        this.debugRenderer.end();
    }
}

