/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ReflectionPool;

public class Pools {
    private static final ObjectMap<Class, ReflectionPool> typePools = new ObjectMap();

    public static <T> Pool<T> get(Class<T> type) {
        ReflectionPool<T> pool = typePools.get(type);
        if (pool == null) {
            pool = new ReflectionPool<T>(type, 4, 100);
            typePools.put(type, pool);
        }
        return pool;
    }

    public static <T> T obtain(Class<T> type) {
        return Pools.get(type).obtain();
    }

    public static void free(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        ReflectionPool pool = typePools.get(object.getClass());
        if (pool == null) {
            throw new IllegalArgumentException("No objects have been obtained of type: " + object.getClass().getName());
        }
        pool.free(object);
    }

    public static void freeAll(Array objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        int n = objects.size;
        for (int i = 0; i < n; ++i) {
            Object object = objects.get(i);
            ReflectionPool pool = typePools.get(object.getClass());
            if (pool == null) {
                throw new IllegalArgumentException("No objects have been obtained of type: " + object.getClass().getName());
            }
            pool.free(object);
        }
    }

    private Pools() {
    }
}

