/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;

public class Timer {
    static final Array<Timer> instances = new Array(1);
    public static final Timer instance;
    private static final int CANCELLED = -1;
    private static final int FOREVER = -2;
    private final Array<Task> tasks = new Array(false, 8);

    public Timer() {
        this.start();
    }

    public void postTask(Task task) {
        this.scheduleTask(task, 0.0f, 0.0f, 0);
    }

    public void scheduleTask(Task task, float delaySeconds) {
        this.scheduleTask(task, delaySeconds, 0.0f, 0);
    }

    public void scheduleTask(Task task, float delaySeconds, float intervalSeconds) {
        this.scheduleTask(task, delaySeconds, intervalSeconds, -2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(Task task, float delaySeconds, float intervalSeconds, int repeatCount) {
        if (task.repeatCount != -1) {
            throw new IllegalArgumentException("The same task may not be scheduled twice.");
        }
        task.executeTime = (float)System.nanoTime() * 1.0E-9f + delaySeconds;
        task.intervalSeconds = intervalSeconds;
        task.repeatCount = repeatCount;
        Array<Task> array = this.tasks;
        synchronized (array) {
            this.tasks.add(task);
        }
        Timer.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Array<Timer> array = instances;
        synchronized (array) {
            instances.removeValue(this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Array<Timer> array = instances;
        synchronized (array) {
            if (instances.contains(this, true)) {
                return;
            }
            instances.add(this);
            Timer.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Array<Task> array = this.tasks;
        synchronized (array) {
            int n = this.tasks.size;
            for (int i = 0; i < n; ++i) {
                this.tasks.get(i).cancel();
            }
            this.tasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float update(float time) {
        float wait = Float.MAX_VALUE;
        Array<Task> array = this.tasks;
        synchronized (array) {
            int n = this.tasks.size;
            for (int i = 0; i < n; ++i) {
                Task task = this.tasks.get(i);
                if (task.executeTime > time) {
                    wait = Math.min(wait, task.executeTime - time);
                    continue;
                }
                if (task.repeatCount != -1) {
                    if (task.repeatCount == 0) {
                        task.repeatCount = -1;
                    }
                    Gdx.app.postRunnable(task);
                }
                if (task.repeatCount == -1) {
                    this.tasks.removeIndex(i);
                    --i;
                    --n;
                    continue;
                }
                task.executeTime = time + task.intervalSeconds;
                wait = Math.min(wait, task.executeTime - time);
                if (task.repeatCount <= 0) continue;
                --task.repeatCount;
            }
        }
        return wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wake() {
        Array<Timer> array = instances;
        synchronized (array) {
            instances.notifyAll();
        }
    }

    public static void post(Task task) {
        instance.postTask(task);
    }

    public static void schedule(Task task, float delaySeconds) {
        instance.scheduleTask(task, delaySeconds);
    }

    public static void schedule(Task task, float delaySeconds, float intervalSeconds) {
        instance.scheduleTask(task, delaySeconds, intervalSeconds);
    }

    public static void schedule(Task task, float delaySeconds, float intervalSeconds, int repeatCount) {
        instance.scheduleTask(task, delaySeconds, intervalSeconds, repeatCount);
    }

    static {
        Thread thread = new Thread("Timer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Array<Timer> array = instances;
                    synchronized (array) {
                        float time = (float)System.nanoTime() * 1.0E-9f;
                        float wait = Float.MAX_VALUE;
                        int n = Timer.instances.size;
                        for (int i = 0; i < n; ++i) {
                            wait = Math.min(wait, instances.get(i).update(time));
                        }
                        long waitMillis = (long)(wait * 1000.0f);
                        try {
                            if (waitMillis > 0L) {
                                instances.wait(waitMillis);
                            }
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        instance = new Timer();
    }

    public static abstract class Task
    implements Runnable {
        float executeTime;
        float intervalSeconds;
        int repeatCount = -1;

        @Override
        public abstract void run();

        public void cancel() {
            this.executeTime = 0.0f;
            this.repeatCount = -1;
        }

        public boolean isScheduled() {
            return this.repeatCount != -1;
        }
    }
}

