/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.utils.Array;

public class AssetLoadingTask {
    AssetManager manager;
    public AssetDescriptor assetDesc;
    AssetLoader loader;
    boolean cancel;
    long startTime;
    boolean dependenciesLoaded;
    Array<AssetDescriptor> dependencies;
    Object asset;

    public AssetLoadingTask(AssetManager manager, AssetDescriptor desc, AssetLoader loader) {
        this.manager = manager;
        this.assetDesc = desc;
        this.loader = loader;
    }

    public boolean update() {
        if (this.loader instanceof AsynchronousAssetLoader) {
            this.handleAsynchLoader((AsynchronousAssetLoader)this.loader);
        } else {
            this.handleSynchLoader((SynchronousAssetLoader)this.loader);
        }
        return this.asset != null;
    }

    private void handleSynchLoader(SynchronousAssetLoader loader) {
        if (!this.dependenciesLoaded) {
            Array dependencies = loader.getDependencies(this.assetDesc.fileName, this.assetDesc.params);
            if (dependencies != null) {
                for (AssetDescriptor desc : dependencies) {
                    this.manager.injectDependency(this.assetDesc.fileName, desc);
                }
                this.dependenciesLoaded = true;
            } else {
                this.asset = loader.load(this.manager, this.assetDesc.fileName, this.assetDesc.params);
            }
        } else {
            this.asset = loader.load(this.manager, this.assetDesc.fileName, this.assetDesc.params);
        }
    }

    private void handleAsynchLoader(AsynchronousAssetLoader loader) {
        if (!this.dependenciesLoaded) {
            Array dependencies = loader.getDependencies(this.assetDesc.fileName, this.assetDesc.params);
            if (dependencies != null) {
                for (AssetDescriptor desc : dependencies) {
                    this.manager.injectDependency(this.assetDesc.fileName, desc);
                }
                this.dependenciesLoaded = true;
            } else {
                loader.loadAsync(this.manager, this.assetDesc.fileName, this.assetDesc.params);
                this.asset = loader.loadSync(this.manager, this.assetDesc.fileName, this.assetDesc.params);
            }
        } else {
            loader.loadAsync(this.manager, this.assetDesc.fileName, this.assetDesc.params);
            this.asset = loader.loadSync(this.manager, this.assetDesc.fileName, this.assetDesc.params);
        }
    }

    public Object getAsset() {
        return this.asset;
    }
}

