/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetErrorListener;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetLoadingTask;
import com.badlogic.gdx.assets.RefCountedContainer;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.BitmapFontLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.MusicLoader;
import com.badlogic.gdx.assets.loaders.PixmapLoader;
import com.badlogic.gdx.assets.loaders.SkinLoader;
import com.badlogic.gdx.assets.loaders.SoundLoader;
import com.badlogic.gdx.assets.loaders.TextureAtlasLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.ArrayList;
import java.util.Stack;

public class AssetManager
implements Disposable {
    final ObjectMap<Class, ObjectMap<String, RefCountedContainer>> assets = new ObjectMap();
    final ObjectMap<String, Class> assetTypes = new ObjectMap();
    final ObjectMap<String, Array<String>> assetDependencies = new ObjectMap();
    final ObjectMap<Class, AssetLoader> loaders = new ObjectMap();
    final ArrayList<AssetDescriptor> loadQueue = new ArrayList();
    Stack<AssetLoadingTask> tasks = new Stack();
    AssetErrorListener listener = null;
    int loaded = 0;
    int toLoad = 0;

    public AssetManager() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    public AssetManager(FileHandleResolver resolver) {
        this.setLoader((Class)BitmapFont.class, (AssetLoader)new BitmapFontLoader(resolver));
        this.setLoader((Class)Music.class, (AssetLoader)new MusicLoader(resolver));
        this.setLoader((Class)Pixmap.class, (AssetLoader)new PixmapLoader(resolver));
        this.setLoader((Class)Sound.class, (AssetLoader)new SoundLoader(resolver));
        this.setLoader((Class)TextureAtlas.class, (AssetLoader)new TextureAtlasLoader(resolver));
        this.setLoader((Class)Texture.class, (AssetLoader)new TextureLoader(resolver));
        this.setLoader((Class)Skin.class, (AssetLoader)new SkinLoader(resolver));
    }

    public synchronized <T> T get(String fileName) {
        Class type = (Class)this.assetTypes.get((Object)fileName);
        ObjectMap assetsByType = (ObjectMap)this.assets.get((Object)type);
        if (assetsByType == null) {
            throw new GdxRuntimeException("Asset not loaded: " + fileName);
        }
        RefCountedContainer assetContainer = (RefCountedContainer)assetsByType.get((Object)fileName);
        if (assetContainer == null) {
            throw new GdxRuntimeException("Asset not loaded: " + fileName);
        }
        Object asset = assetContainer.getObject(type);
        if (asset == null) {
            throw new GdxRuntimeException("Asset not loaded: " + fileName);
        }
        return (T)asset;
    }

    public synchronized <T> T get(String fileName, Class<T> type) {
        ObjectMap assetsByType = (ObjectMap)this.assets.get(type);
        if (assetsByType == null) {
            throw new GdxRuntimeException("Asset not loaded: " + fileName);
        }
        RefCountedContainer assetContainer = (RefCountedContainer)assetsByType.get((Object)fileName);
        if (assetContainer == null) {
            throw new GdxRuntimeException("Asset not loaded: " + fileName);
        }
        Object asset = assetContainer.getObject(type);
        if (asset == null) {
            throw new GdxRuntimeException("Asset not loaded: " + fileName);
        }
        return (T)asset;
    }

    public synchronized void unload(String fileName) {
        Array dependencies;
        Class type;
        int foundIndex = -1;
        for (int i = 0; i < this.loadQueue.size(); ++i) {
            if (!this.loadQueue.get((int)i).fileName.equals(fileName)) continue;
            foundIndex = i;
            break;
        }
        if (foundIndex != -1) {
            this.loadQueue.remove(foundIndex);
            return;
        }
        if (this.tasks.size() > 0) {
            AssetLoadingTask currAsset = (AssetLoadingTask)this.tasks.firstElement();
            if (currAsset.assetDesc.fileName.equals(fileName)) {
                currAsset.cancel = true;
                return;
            }
        }
        if ((type = (Class)this.assetTypes.get((Object)fileName)) == null) {
            throw new GdxRuntimeException("Asset not loaded: " + fileName);
        }
        RefCountedContainer assetRef = (RefCountedContainer)((ObjectMap)this.assets.get((Object)type)).get((Object)fileName);
        assetRef.decRefCount();
        if (assetRef.getRefCount() <= 0) {
            if (assetRef.getObject(Object.class) instanceof Disposable) {
                ((Disposable)assetRef.getObject(Object.class)).dispose();
            }
            this.assetTypes.remove((Object)fileName);
            ((ObjectMap)this.assets.get((Object)type)).remove((Object)fileName);
        }
        if ((dependencies = (Array)this.assetDependencies.get((Object)fileName)) != null) {
            for (String dependency : dependencies) {
                this.unload(dependency);
            }
        }
        if (assetRef.getRefCount() <= 0) {
            this.assetDependencies.remove((Object)fileName);
        }
    }

    public synchronized <T> boolean containsAsset(T asset) {
        ObjectMap typedAssets = (ObjectMap)this.assets.get(asset.getClass());
        if (typedAssets == null) {
            return false;
        }
        for (String fileName : typedAssets.keys()) {
            Object otherAsset = ((RefCountedContainer)typedAssets.get((Object)fileName)).getObject(Object.class);
            if (otherAsset != asset && !asset.equals(otherAsset)) continue;
            return true;
        }
        return false;
    }

    public synchronized <T> String getAssetFileName(T asset) {
        for (Class assetType : this.assets.keys()) {
            ObjectMap typedAssets = (ObjectMap)this.assets.get((Object)assetType);
            for (String fileName : typedAssets.keys()) {
                Object otherAsset = ((RefCountedContainer)typedAssets.get((Object)fileName)).getObject(Object.class);
                if (otherAsset != asset && !asset.equals(otherAsset)) continue;
                return fileName;
            }
        }
        return null;
    }

    public synchronized boolean isLoaded(String fileName) {
        if (fileName == null) {
            return false;
        }
        return this.assetTypes.containsKey((Object)fileName);
    }

    public synchronized boolean isLoaded(String fileName, Class type) {
        ObjectMap assetsByType = (ObjectMap)this.assets.get((Object)type);
        if (assetsByType == null) {
            return false;
        }
        RefCountedContainer assetContainer = (RefCountedContainer)assetsByType.get((Object)fileName);
        if (assetContainer == null) {
            return false;
        }
        return assetContainer.getObject(type) != null;
    }

    public synchronized <T> void load(String fileName, Class<T> type) {
        this.load(fileName, type, null);
    }

    public synchronized <T> void load(String fileName, Class<T> type, AssetLoaderParameters<T> parameter) {
        AssetDescriptor desc;
        int i;
        AssetLoader loader = (AssetLoader)this.loaders.get(type);
        if (loader == null) {
            throw new GdxRuntimeException("No loader for type: " + type.getName());
        }
        if (this.loadQueue.size() == 0) {
            this.loaded = 0;
            this.toLoad = 0;
        }
        for (i = 0; i < this.loadQueue.size(); ++i) {
            desc = this.loadQueue.get(i);
            if (!desc.fileName.equals(fileName) || desc.type.equals(type)) continue;
            throw new GdxRuntimeException("Asset with name '" + fileName + "' already in preload queue, but has different type (expected: " + type.getName() + ", found: " + desc.type.getName());
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            desc = ((AssetLoadingTask)this.tasks.get((int)i)).assetDesc;
            if (!desc.fileName.equals(fileName) || desc.type.equals(type)) continue;
            throw new GdxRuntimeException("Asset with name '" + fileName + "' already in task list, but has different type (expected: " + type.getName() + ", found: " + desc.type.getName());
        }
        Class otherType = (Class)this.assetTypes.get((Object)fileName);
        if (otherType != null && !otherType.equals(type)) {
            throw new GdxRuntimeException("Asset with name '" + fileName + "' already loaded, but has different type (expected: " + type.getName() + ", found: " + otherType.getName());
        }
        ++this.toLoad;
        AssetDescriptor assetDesc = new AssetDescriptor(fileName, type, parameter);
        this.loadQueue.add(assetDesc);
    }

    public synchronized void load(AssetDescriptor desc) {
        this.load(desc.fileName, desc.type, desc.params);
    }

    private void disposeDependencies(String fileName) {
        Class type;
        Object asset;
        Array dependencies = (Array)this.assetDependencies.get((Object)fileName);
        if (dependencies != null) {
            for (String dependency : dependencies) {
                this.disposeDependencies(dependency);
            }
        }
        if ((asset = ((RefCountedContainer)((ObjectMap)this.assets.get((Object)(type = (Class)this.assetTypes.get((Object)fileName)))).get((Object)fileName)).getObject(Object.class)) instanceof Disposable) {
            ((Disposable)asset).dispose();
        }
    }

    public synchronized boolean update() {
        try {
            if (this.tasks.size() == 0) {
                while (this.loadQueue.size() != 0 && this.tasks.size() == 0) {
                    this.nextTask();
                }
                if (this.tasks.size() == 0) {
                    return true;
                }
            }
            return this.updateTask() && this.loadQueue.size() == 0 && this.tasks.size() == 0;
        }
        catch (Throwable t) {
            this.handleTaskError(t);
            return this.loadQueue.size() == 0;
        }
    }

    synchronized void injectDependency(String parentAssetFilename, AssetDescriptor dependendAssetDesc) {
        Array<String> dependencies = (Array<String>)this.assetDependencies.get((Object)parentAssetFilename);
        if (dependencies == null) {
            dependencies = new Array<String>();
            this.assetDependencies.put((Object)parentAssetFilename, dependencies);
        }
        dependencies.add(dependendAssetDesc.fileName);
        if (this.isLoaded(dependendAssetDesc.fileName)) {
            Class type = (Class)this.assetTypes.get((Object)dependendAssetDesc.fileName);
            RefCountedContainer assetRef = (RefCountedContainer)((ObjectMap)this.assets.get((Object)type)).get((Object)dependendAssetDesc.fileName);
            assetRef.incRefCount();
            this.incrementRefCountedDependencies(dependendAssetDesc.fileName);
        } else {
            this.addTask(dependendAssetDesc);
        }
    }

    private void nextTask() {
        AssetDescriptor assetDesc = this.loadQueue.remove(0);
        if (this.isLoaded(assetDesc.fileName)) {
            Class type = (Class)this.assetTypes.get((Object)assetDesc.fileName);
            RefCountedContainer assetRef = (RefCountedContainer)((ObjectMap)this.assets.get((Object)type)).get((Object)assetDesc.fileName);
            assetRef.incRefCount();
            this.incrementRefCountedDependencies(assetDesc.fileName);
            ++this.loaded;
        } else {
            this.addTask(assetDesc);
        }
    }

    private void addTask(AssetDescriptor assetDesc) {
        AssetLoader loader = (AssetLoader)this.loaders.get((Object)assetDesc.type);
        if (loader == null) {
            throw new GdxRuntimeException("No loader for type: " + assetDesc.type.getName());
        }
        this.tasks.push(new AssetLoadingTask(this, assetDesc, loader));
    }

    private boolean updateTask() {
        AssetLoadingTask task = this.tasks.peek();
        if (task.update()) {
            this.assetTypes.put((Object)task.assetDesc.fileName, (Object)task.assetDesc.type);
            ObjectMap typeToAssets = (ObjectMap)this.assets.get((Object)task.assetDesc.type);
            if (typeToAssets == null) {
                typeToAssets = new ObjectMap();
                this.assets.put((Object)task.assetDesc.type, (Object)typeToAssets);
            }
            typeToAssets.put((Object)task.assetDesc.fileName, (Object)new RefCountedContainer(task.getAsset()));
            if (this.tasks.size() == 1) {
                ++this.loaded;
            }
            this.tasks.pop();
            if (task.cancel) {
                this.unload(task.assetDesc.fileName);
            } else if (task.assetDesc.params != null && task.assetDesc.params.loadedCallback != null) {
                task.assetDesc.params.loadedCallback.finishedLoading(this, task.assetDesc.fileName, task.assetDesc.type);
            }
            return true;
        }
        return false;
    }

    private void incrementRefCountedDependencies(String parent) {
        Array dependencies = (Array)this.assetDependencies.get((Object)parent);
        if (dependencies == null) {
            return;
        }
        for (String dependency : dependencies) {
            Class type = (Class)this.assetTypes.get((Object)dependency);
            RefCountedContainer assetRef = (RefCountedContainer)((ObjectMap)this.assets.get((Object)type)).get((Object)dependency);
            assetRef.incRefCount();
            this.incrementRefCountedDependencies(dependency);
        }
    }

    private void handleTaskError(Throwable t) {
        if (this.tasks.isEmpty()) {
            throw new GdxRuntimeException(t);
        }
        AssetLoadingTask task = this.tasks.pop();
        AssetDescriptor assetDesc = task.assetDesc;
        if (task.dependenciesLoaded && task.dependencies != null) {
            for (AssetDescriptor desc : task.dependencies) {
                this.unload(desc.fileName);
            }
        }
        this.tasks.clear();
        if (this.listener == null) {
            throw new GdxRuntimeException(t);
        }
        this.listener.error(assetDesc.fileName, assetDesc.type, t);
    }

    public synchronized <T, P extends AssetLoaderParameters<T>> void setLoader(Class<T> type, AssetLoader<T, P> loader) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null.");
        }
        this.loaders.put(type, loader);
    }

    public synchronized int getLoadedAssets() {
        return this.assetTypes.size;
    }

    public synchronized int getQueuedAssets() {
        return this.loadQueue.size() + this.tasks.size();
    }

    public synchronized float getProgress() {
        if (this.toLoad == 0) {
            return 1.0f;
        }
        return Math.min(1.0f, (float)this.loaded / (float)this.toLoad);
    }

    public synchronized void setErrorListener(AssetErrorListener listener) {
        this.listener = listener;
    }

    public synchronized void dispose() {
        this.clear();
    }

    public synchronized void clear() {
        this.loadQueue.clear();
        while (!this.update()) {
        }
        ObjectIntMap dependencyCount = new ObjectIntMap();
        while (this.assetTypes.size > 0) {
            dependencyCount.clear();
            Array assets = this.assetTypes.keys().toArray();
            for (String asset : assets) {
                dependencyCount.put((Object)asset, 0);
            }
            for (String asset : assets) {
                Array dependencies = (Array)this.assetDependencies.get((Object)asset);
                if (dependencies == null) continue;
                for (String dependency : dependencies) {
                    int count = dependencyCount.get((Object)dependency, 0);
                    dependencyCount.put((Object)dependency, ++count);
                }
            }
            for (String asset : assets) {
                if (dependencyCount.get((Object)asset, 0) != 0) continue;
                this.unload(asset);
            }
        }
        this.assets.clear();
        this.assetTypes.clear();
        this.assetDependencies.clear();
        this.loaded = 0;
        this.toLoad = 0;
        this.loadQueue.clear();
        this.tasks.clear();
    }

    public synchronized int getReferenceCount(String fileName) {
        Class type = (Class)this.assetTypes.get((Object)fileName);
        if (type == null) {
            throw new GdxRuntimeException("Asset not loaded: " + fileName);
        }
        return ((RefCountedContainer)((ObjectMap)this.assets.get((Object)type)).get((Object)fileName)).getRefCount();
    }

    public synchronized void setReferenceCount(String fileName, int refCount) {
        Class type = (Class)this.assetTypes.get((Object)fileName);
        if (type == null) {
            throw new GdxRuntimeException("Asset not loaded: " + fileName);
        }
        ((RefCountedContainer)((ObjectMap)this.assets.get((Object)type)).get((Object)fileName)).setRefCount(refCount);
    }

    public synchronized String getDiagnostics() {
        StringBuffer buffer = new StringBuffer();
        for (String fileName : this.assetTypes.keys()) {
            buffer.append(fileName);
            buffer.append(", ");
            Class type = (Class)this.assetTypes.get((Object)fileName);
            RefCountedContainer assetRef = (RefCountedContainer)((ObjectMap)this.assets.get((Object)type)).get((Object)fileName);
            Array dependencies = (Array)this.assetDependencies.get((Object)fileName);
            buffer.append(type.getName());
            buffer.append(", refs: ");
            buffer.append(assetRef.getRefCount());
            if (dependencies != null) {
                buffer.append(", deps: [");
                for (String dep : dependencies) {
                    buffer.append(dep);
                    buffer.append(",");
                }
                buffer.append("]");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public void finishLoading() {
        while (!this.update()) {
        }
    }

    public synchronized Array<String> getAssetNames() {
        return this.assetTypes.keys().toArray();
    }

    public synchronized Array<String> getDependencies(String fileName) {
        return (Array)this.assetDependencies.get((Object)fileName);
    }

    public synchronized Class getAssetType(String fileName) {
        return (Class)this.assetTypes.get((Object)fileName);
    }
}

