/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.typedarrays.client.Float32Array;
import com.google.gwt.typedarrays.client.Int16Array;
import com.google.gwt.typedarrays.client.Int32Array;
import com.google.gwt.typedarrays.client.Uint8Array;
import com.google.gwt.webgl.client.WebGLActiveInfo;
import com.google.gwt.webgl.client.WebGLBuffer;
import com.google.gwt.webgl.client.WebGLFramebuffer;
import com.google.gwt.webgl.client.WebGLProgram;
import com.google.gwt.webgl.client.WebGLRenderbuffer;
import com.google.gwt.webgl.client.WebGLRenderingContext;
import com.google.gwt.webgl.client.WebGLShader;
import com.google.gwt.webgl.client.WebGLTexture;
import com.google.gwt.webgl.client.WebGLUniformLocation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.HasArrayBufferView;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;

public class GwtGL20
implements GL20 {
    final Map<Integer, WebGLProgram> programs = new HashMap<Integer, WebGLProgram>();
    int nextProgramId = 1;
    final Map<Integer, WebGLShader> shaders = new HashMap<Integer, WebGLShader>();
    int nextShaderId = 1;
    final Map<Integer, WebGLBuffer> buffers = new HashMap<Integer, WebGLBuffer>();
    int nextBufferId = 1;
    final Map<Integer, WebGLFramebuffer> frameBuffers = new HashMap<Integer, WebGLFramebuffer>();
    int nextFrameBufferId = 1;
    final Map<Integer, WebGLRenderbuffer> renderBuffers = new HashMap<Integer, WebGLRenderbuffer>();
    int nextRenderBufferId = 1;
    final Map<Integer, WebGLTexture> textures = new HashMap<Integer, WebGLTexture>();
    int nextTextureId = 1;
    final Map<Integer, Map<Integer, WebGLUniformLocation>> uniforms = new HashMap<Integer, Map<Integer, WebGLUniformLocation>>();
    int nextUniformId = 1;
    int currProgram = 0;
    Float32Array floatBuffer = Float32Array.create(40000);
    Int16Array shortBuffer = Int16Array.create(12000);
    final WebGLRenderingContext gl;

    protected GwtGL20(WebGLRenderingContext gl) {
        this.gl = gl;
        this.gl.pixelStorei(37441, 0);
    }

    private void ensureCapacity(FloatBuffer buffer) {
        if (buffer.remaining() > this.floatBuffer.getLength()) {
            this.floatBuffer = Float32Array.create(buffer.remaining());
        }
    }

    private void ensureCapacity(ShortBuffer buffer) {
        if (buffer.remaining() > this.shortBuffer.getLength()) {
            this.shortBuffer = Int16Array.create(buffer.remaining());
        }
    }

    public Float32Array copy(FloatBuffer buffer) {
        if (GWT.isProdMode()) {
            return ((Float32Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
        }
        this.ensureCapacity(buffer);
        float[] array = buffer.array();
        int i = buffer.position();
        int j = 0;
        while (i < buffer.limit()) {
            this.floatBuffer.set(j, array[i]);
            ++i;
            ++j;
        }
        return this.floatBuffer.subarray(0, buffer.remaining());
    }

    public Int16Array copy(ShortBuffer buffer) {
        if (GWT.isProdMode()) {
            return ((Int16Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
        }
        this.ensureCapacity(buffer);
        short[] array = buffer.array();
        int i = buffer.position();
        int j = 0;
        while (i < buffer.limit()) {
            this.shortBuffer.set(j, (int)array[i]);
            ++i;
            ++j;
        }
        return this.shortBuffer.subarray(0, buffer.remaining());
    }

    private int allocateUniformLocationId(int program, WebGLUniformLocation location) {
        Map<Integer, WebGLUniformLocation> progUniforms = this.uniforms.get(program);
        if (progUniforms == null) {
            progUniforms = new HashMap<Integer, WebGLUniformLocation>();
            this.uniforms.put(program, progUniforms);
        }
        int id = this.nextUniformId++;
        progUniforms.put(id, location);
        return id;
    }

    private WebGLUniformLocation getUniformLocation(int location) {
        return this.uniforms.get(this.currProgram).get(location);
    }

    private int allocateShaderId(WebGLShader shader) {
        int id = this.nextShaderId++;
        this.shaders.put(id, shader);
        return id;
    }

    private void deallocateShaderId(int id) {
        this.shaders.remove(id);
    }

    private int allocateProgramId(WebGLProgram program) {
        int id = this.nextProgramId++;
        this.programs.put(id, program);
        return id;
    }

    private void deallocateProgramId(int id) {
        this.uniforms.remove(id);
        this.programs.remove(id);
    }

    private int allocateBufferId(WebGLBuffer buffer) {
        int id = this.nextBufferId++;
        this.buffers.put(id, buffer);
        return id;
    }

    private void deallocateBufferId(int id) {
        this.buffers.remove(id);
    }

    private int allocateFrameBufferId(WebGLFramebuffer frameBuffer) {
        int id = this.nextBufferId++;
        this.frameBuffers.put(id, frameBuffer);
        return id;
    }

    private void deallocateFrameBufferId(int id) {
        this.frameBuffers.remove(id);
    }

    private int allocateRenderBufferId(WebGLRenderbuffer renderBuffer) {
        int id = this.nextRenderBufferId++;
        this.renderBuffers.put(id, renderBuffer);
        return id;
    }

    private void deallocateRenderBufferId(int id) {
        this.renderBuffers.remove(id);
    }

    private int allocateTextureId(WebGLTexture texture) {
        int id = this.nextTextureId++;
        this.textures.put(id, texture);
        return id;
    }

    private void deallocateTextureId(int id) {
        this.textures.remove(id);
    }

    public void glActiveTexture(int texture) {
        this.gl.activeTexture(texture);
    }

    public void glBindTexture(int target, int texture) {
        this.gl.bindTexture(target, this.textures.get(texture));
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        this.gl.blendFunc(sfactor, dfactor);
    }

    public void glClear(int mask) {
        this.gl.clear(mask);
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        this.gl.clearColor(red, green, blue, alpha);
    }

    public void glClearDepthf(float depth) {
        this.gl.clearDepth(depth);
    }

    public void glClearStencil(int s) {
        this.gl.clearStencil(s);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        this.gl.colorMask(red, green, blue, alpha);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        throw new GdxRuntimeException("compressed textures not supported by GWT WebGL backend");
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        throw new GdxRuntimeException("compressed textures not supported by GWT WebGL backend");
    }

    public void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        this.gl.copyTexImage2D(target, level, internalformat, x, y, width, height, border);
    }

    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        this.gl.copyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    }

    public void glCullFace(int mode) {
        this.gl.cullFace(mode);
    }

    public void glDeleteTextures(int n, IntBuffer textures) {
        for (int i = 0; i < n; ++i) {
            int id = textures.get();
            WebGLTexture texture = this.textures.get(id);
            this.deallocateTextureId(id);
            this.gl.deleteTexture(texture);
        }
    }

    public void glDepthFunc(int func) {
        this.gl.depthFunc(func);
    }

    public void glDepthMask(boolean flag) {
        this.gl.depthMask(flag);
    }

    public void glDepthRangef(float zNear, float zFar) {
        this.gl.depthRange(zNear, zFar);
    }

    public void glDisable(int cap) {
        this.gl.disable(cap);
    }

    public void glDrawArrays(int mode, int first, int count) {
        this.gl.drawArrays(mode, first, count);
    }

    public void glDrawElements(int mode, int count, int type, Buffer indices) {
        this.gl.drawElements(mode, count, type, indices.position());
    }

    public void glEnable(int cap) {
        this.gl.enable(cap);
    }

    public void glFinish() {
        this.gl.finish();
    }

    public void glFlush() {
        this.gl.flush();
    }

    public void glFrontFace(int mode) {
        this.gl.frontFace(mode);
    }

    public void glGenTextures(int n, IntBuffer textures) {
        WebGLTexture texture = this.gl.createTexture();
        int id = this.allocateTextureId(texture);
        textures.put(id);
    }

    public int glGetError() {
        return this.gl.getError();
    }

    public void glGetIntegerv(int pname, IntBuffer params) {
        throw new GdxRuntimeException("glGetInteger not supported by GWT WebGL backend");
    }

    public String glGetString(int name) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glHint(int target, int mode) {
        this.gl.hint(target, mode);
    }

    public void glLineWidth(float width) {
        this.gl.lineWidth(width);
    }

    public void glPixelStorei(int pname, int param) {
        this.gl.pixelStorei(pname, param);
    }

    public void glPolygonOffset(float factor, float units) {
        this.gl.polygonOffset(factor, units);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        if (format != 6408 || type != 5121) {
            throw new GdxRuntimeException("Only format RGBA and type UNSIGNED_BYTE are currently supported for glReadPixels(...).");
        }
        if (!(pixels instanceof ByteBuffer)) {
            throw new GdxRuntimeException("Inputed pixels buffer needs to be of type ByteBuffer for glReadPixels(...).");
        }
        int size = 4 * width * height;
        Uint8Array buffer = Uint8Array.create(size);
        this.gl.readPixels(x, y, width, height, format, type, buffer);
        ByteBuffer pixelsByte = (ByteBuffer)pixels;
        for (int i = 0; i < size; ++i) {
            pixelsByte.put((byte)(buffer.get(i) & 0xFF));
        }
    }

    public void glScissor(int x, int y, int width, int height) {
        this.gl.scissor(x, y, width, height);
    }

    public void glStencilFunc(int func, int ref, int mask) {
        this.gl.stencilFunc(func, ref, mask);
    }

    public void glStencilMask(int mask) {
        this.gl.stencilMask(mask);
    }

    public void glStencilOp(int fail, int zfail, int zpass) {
        this.gl.stencilOp(fail, zfail, zpass);
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        Pixmap pixmap = Pixmap.pixmaps.get(((IntBuffer)pixels).get(0));
        this.gl.texImage2D(target, level, internalformat, format, type, pixmap.getCanvasElement());
    }

    public void glTexParameterf(int target, int pname, float param) {
        this.gl.texParameterf(target, pname, param);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        Pixmap pixmap = Pixmap.pixmaps.get(((IntBuffer)pixels).get(0));
        this.gl.texSubImage2D(target, level, xoffset, yoffset, width, height, pixmap.getCanvasElement());
    }

    public void glViewport(int x, int y, int width, int height) {
        this.gl.viewport(x, y, width, height);
    }

    public void glAttachShader(int program, int shader) {
        WebGLProgram glProgram = this.programs.get(program);
        WebGLShader glShader = this.shaders.get(shader);
        this.gl.attachShader(glProgram, glShader);
    }

    public void glBindAttribLocation(int program, int index, String name) {
        WebGLProgram glProgram = this.programs.get(program);
        this.gl.bindAttribLocation(glProgram, index, name);
    }

    public void glBindBuffer(int target, int buffer) {
        this.gl.bindBuffer(target, this.buffers.get(buffer));
    }

    public void glBindFramebuffer(int target, int framebuffer) {
        this.gl.bindFramebuffer(target, this.frameBuffers.get(framebuffer));
    }

    public void glBindRenderbuffer(int target, int renderbuffer) {
        this.gl.bindRenderbuffer(target, this.renderBuffers.get(renderbuffer));
    }

    public void glBlendColor(float red, float green, float blue, float alpha) {
        this.gl.blendColor(red, green, blue, alpha);
    }

    public void glBlendEquation(int mode) {
        this.gl.blendEquation(mode);
    }

    public void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        this.gl.blendEquationSeparate(modeRGB, modeAlpha);
    }

    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        this.gl.blendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public void glBufferData(int target, int size, Buffer data, int usage) {
        if (data instanceof FloatBuffer) {
            this.gl.bufferData(target, this.copy((FloatBuffer)data), usage);
        } else if (data instanceof ShortBuffer) {
            this.gl.bufferData(target, this.copy((ShortBuffer)data), usage);
        } else {
            throw new GdxRuntimeException("Can only cope with FloatBuffer and ShortBuffer at the moment");
        }
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        if (data instanceof FloatBuffer) {
            this.gl.bufferSubData(target, offset, this.copy((FloatBuffer)data));
        } else if (data instanceof ShortBuffer) {
            this.gl.bufferSubData(target, offset, this.copy((ShortBuffer)data));
        } else {
            throw new GdxRuntimeException("Can only cope with FloatBuffer and ShortBuffer at the moment");
        }
    }

    public int glCheckFramebufferStatus(int target) {
        return this.gl.checkFramebufferStatus(target);
    }

    public void glCompileShader(int shader) {
        WebGLShader glShader = this.shaders.get(shader);
        this.gl.compileShader(glShader);
    }

    public int glCreateProgram() {
        WebGLProgram program = this.gl.createProgram();
        return this.allocateProgramId(program);
    }

    public int glCreateShader(int type) {
        WebGLShader shader = this.gl.createShader(type);
        return this.allocateShaderId(shader);
    }

    public void glDeleteBuffers(int n, IntBuffer buffers) {
        for (int i = 0; i < n; ++i) {
            int id = buffers.get();
            WebGLBuffer buffer = this.buffers.get(id);
            this.deallocateBufferId(id);
            this.gl.deleteBuffer(buffer);
        }
    }

    public void glDeleteFramebuffers(int n, IntBuffer framebuffers) {
        for (int i = 0; i < n; ++i) {
            int id = framebuffers.get();
            WebGLFramebuffer fb = this.frameBuffers.get(id);
            this.deallocateFrameBufferId(id);
            this.gl.deleteFramebuffer(fb);
        }
    }

    public void glDeleteProgram(int program) {
        WebGLProgram prog = this.programs.get(program);
        this.deallocateProgramId(program);
        this.gl.deleteProgram(prog);
    }

    public void glDeleteRenderbuffers(int n, IntBuffer renderbuffers) {
        for (int i = 0; i < n; ++i) {
            int id = renderbuffers.get();
            WebGLRenderbuffer rb = this.renderBuffers.get(id);
            this.deallocateRenderBufferId(id);
            this.gl.deleteRenderbuffer(rb);
        }
    }

    public void glDeleteShader(int shader) {
        WebGLShader sh = this.shaders.get(shader);
        this.deallocateShaderId(shader);
        this.gl.deleteShader(sh);
    }

    public void glDetachShader(int program, int shader) {
        this.gl.detachShader(this.programs.get(program), this.shaders.get(shader));
    }

    public void glDisableVertexAttribArray(int index) {
        this.gl.disableVertexAttribArray(index);
    }

    public void glDrawElements(int mode, int count, int type, int indices) {
        this.gl.drawElements(mode, count, type, indices);
    }

    public void glEnableVertexAttribArray(int index) {
        this.gl.enableVertexAttribArray(index);
    }

    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        this.gl.framebufferRenderbuffer(target, attachment, renderbuffertarget, this.renderBuffers.get(renderbuffer));
    }

    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        this.gl.framebufferTexture2D(target, attachment, textarget, this.textures.get(texture), level);
    }

    public void glGenBuffers(int n, IntBuffer buffers) {
        for (int i = 0; i < n; ++i) {
            WebGLBuffer buffer = this.gl.createBuffer();
            int id = this.allocateBufferId(buffer);
            buffers.put(id);
        }
    }

    public void glGenerateMipmap(int target) {
        this.gl.generateMipmap(target);
    }

    public void glGenFramebuffers(int n, IntBuffer framebuffers) {
        for (int i = 0; i < n; ++i) {
            WebGLFramebuffer fb = this.gl.createFramebuffer();
            int id = this.allocateFrameBufferId(fb);
            framebuffers.put(id);
        }
    }

    public void glGenRenderbuffers(int n, IntBuffer renderbuffers) {
        for (int i = 0; i < n; ++i) {
            WebGLRenderbuffer rb = this.gl.createRenderbuffer();
            int id = this.allocateRenderBufferId(rb);
            renderbuffers.put(id);
        }
    }

    public String glGetActiveAttrib(int program, int index, IntBuffer size, Buffer type) {
        WebGLActiveInfo activeAttrib = this.gl.getActiveAttrib(this.programs.get(program), index);
        size.put(activeAttrib.getSize());
        ((IntBuffer)type).put(activeAttrib.getType());
        return activeAttrib.getName();
    }

    public String glGetActiveUniform(int program, int index, IntBuffer size, Buffer type) {
        WebGLActiveInfo activeUniform = this.gl.getActiveUniform(this.programs.get(program), index);
        size.put(activeUniform.getSize());
        ((IntBuffer)type).put(activeUniform.getType());
        return activeUniform.getName();
    }

    public void glGetAttachedShaders(int program, int maxcount, Buffer count, IntBuffer shaders) {
        throw new GdxRuntimeException("not implemented");
    }

    public int glGetAttribLocation(int program, String name) {
        WebGLProgram prog = this.programs.get(program);
        return this.gl.getAttribLocation(prog, name);
    }

    public void glGetBooleanv(int pname, Buffer params) {
        throw new GdxRuntimeException("glGetBoolean not supported by GWT WebGL backend");
    }

    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glGetFloatv(int pname, FloatBuffer params) {
        throw new GdxRuntimeException("glGetFloat not supported by GWT WebGL backend");
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glGetProgramiv(int program, int pname, IntBuffer params) {
        if (pname == 35712 || pname == 35714 || pname == 35715) {
            boolean result = this.gl.getProgramParameterb(this.programs.get(program), pname);
            params.put(result ? 1 : 0);
        } else {
            params.put(this.gl.getProgramParameteri(this.programs.get(program), pname));
        }
    }

    public String glGetProgramInfoLog(int program) {
        return this.gl.getProgramInfoLog(this.programs.get(program));
    }

    public void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glGetShaderiv(int shader, int pname, IntBuffer params) {
        if (pname == 35713 || pname == 35712) {
            boolean result = this.gl.getShaderParameterb(this.shaders.get(shader), pname);
            params.put(result ? 1 : 0);
        } else {
            int result = this.gl.getShaderParameteri(this.shaders.get(shader), pname);
            params.put(result);
        }
    }

    public String glGetShaderInfoLog(int shader) {
        return this.gl.getShaderInfoLog(this.shaders.get(shader));
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        throw new GdxRuntimeException("glGetShaderPrecisionFormat not supported by GWT WebGL backend");
    }

    public void glGetShaderSource(int shader, int bufsize, Buffer length, String source) {
        throw new GdxRuntimeException("glGetShaderSource not supported by GWT WebGL backend");
    }

    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        throw new GdxRuntimeException("glGetTexParameter not supported by GWT WebGL backend");
    }

    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        throw new GdxRuntimeException("glGetTexParameter not supported by GWT WebGL backend");
    }

    public void glGetUniformfv(int program, int location, FloatBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glGetUniformiv(int program, int location, IntBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public int glGetUniformLocation(int program, String name) {
        WebGLUniformLocation location = this.gl.getUniformLocation(this.programs.get(program), name);
        return this.allocateUniformLocationId(program, location);
    }

    public void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glGetVertexAttribPointerv(int index, int pname, Buffer pointer) {
        throw new GdxRuntimeException("glGetVertexAttribPointer not supported by GWT WebGL backend");
    }

    public boolean glIsBuffer(int buffer) {
        return this.gl.isBuffer(this.buffers.get(buffer));
    }

    public boolean glIsEnabled(int cap) {
        return this.gl.isEnabled(cap);
    }

    public boolean glIsFramebuffer(int framebuffer) {
        return this.gl.isFramebuffer(this.frameBuffers.get(framebuffer));
    }

    public boolean glIsProgram(int program) {
        return this.gl.isProgram(this.programs.get(program));
    }

    public boolean glIsRenderbuffer(int renderbuffer) {
        return this.gl.isRenderbuffer(this.renderBuffers.get(renderbuffer));
    }

    public boolean glIsShader(int shader) {
        return this.gl.isShader(this.shaders.get(shader));
    }

    public boolean glIsTexture(int texture) {
        return this.gl.isTexture(this.textures.get(texture));
    }

    public void glLinkProgram(int program) {
        this.gl.linkProgram(this.programs.get(program));
    }

    public void glReleaseShaderCompiler() {
        throw new GdxRuntimeException("not implemented");
    }

    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        this.gl.renderbufferStorage(target, internalformat, width, height);
    }

    public void glSampleCoverage(float value, boolean invert) {
        this.gl.sampleCoverage(value, invert);
    }

    public void glShaderBinary(int n, IntBuffer shaders, int binaryformat, Buffer binary, int length) {
        throw new GdxRuntimeException("glShaderBinary not supported by GWT WebGL backend");
    }

    public void glShaderSource(int shader, String source) {
        this.gl.shaderSource(this.shaders.get(shader), source);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        this.gl.stencilFuncSeparate(face, func, ref, mask);
    }

    public void glStencilMaskSeparate(int face, int mask) {
        this.gl.stencilMaskSeparate(face, mask);
    }

    public void glStencilOpSeparate(int face, int fail, int zfail, int zpass) {
        this.gl.stencilOpSeparate(face, fail, zfail, zpass);
    }

    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        this.gl.texParameterf(target, pname, params.get());
    }

    public void glTexParameteri(int target, int pname, int param) {
        this.gl.texParameterf(target, pname, param);
    }

    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        this.gl.texParameterf(target, pname, params.get());
    }

    public void glUniform1f(int location, float x) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform1f(loc, x);
    }

    public void glUniform1fv(int location, int count, FloatBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniform1fv(loc, ((Float32Array)((HasArrayBufferView)((Object)v)).getTypedArray()).subarray(v.position(), v.remaining()));
        } else {
            this.gl.uniform1fv(loc, v.array());
        }
    }

    public void glUniform1i(int location, int x) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform1i(loc, x);
    }

    public void glUniform1iv(int location, int count, IntBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniform1iv(loc, ((Int32Array)((HasArrayBufferView)((Object)v)).getTypedArray()).subarray(v.position(), v.remaining()));
        } else {
            this.gl.uniform1iv(loc, v.array());
        }
    }

    public void glUniform2f(int location, float x, float y) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform2f(loc, x, y);
    }

    public void glUniform2fv(int location, int count, FloatBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniform2fv(loc, ((Float32Array)((HasArrayBufferView)((Object)v)).getTypedArray()).subarray(v.position(), v.remaining()));
        } else {
            this.gl.uniform2fv(loc, v.array());
        }
    }

    public void glUniform2i(int location, int x, int y) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform2i(loc, x, y);
    }

    public void glUniform2iv(int location, int count, IntBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniform2iv(loc, ((Int32Array)((HasArrayBufferView)((Object)v)).getTypedArray()).subarray(v.position(), v.remaining()));
        } else {
            this.gl.uniform2iv(loc, v.array());
        }
    }

    public void glUniform3f(int location, float x, float y, float z) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform3f(loc, x, y, z);
    }

    public void glUniform3fv(int location, int count, FloatBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniform3fv(loc, ((Float32Array)((HasArrayBufferView)((Object)v)).getTypedArray()).subarray(v.position(), v.remaining()));
        } else {
            this.gl.uniform3fv(loc, v.array());
        }
    }

    public void glUniform3i(int location, int x, int y, int z) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform3i(loc, x, y, z);
    }

    public void glUniform3iv(int location, int count, IntBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniform3iv(loc, ((Int32Array)((HasArrayBufferView)((Object)v)).getTypedArray()).subarray(v.position(), v.remaining()));
        } else {
            this.gl.uniform3iv(loc, v.array());
        }
    }

    public void glUniform4f(int location, float x, float y, float z, float w) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform4f(loc, x, y, z, w);
    }

    public void glUniform4fv(int location, int count, FloatBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniform4fv(loc, ((Float32Array)((HasArrayBufferView)((Object)v)).getTypedArray()).subarray(v.position(), v.remaining()));
        } else {
            this.gl.uniform4fv(loc, v.array());
        }
    }

    public void glUniform4i(int location, int x, int y, int z, int w) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform4i(loc, x, y, z, w);
    }

    public void glUniform4iv(int location, int count, IntBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniform4iv(loc, ((Int32Array)((HasArrayBufferView)((Object)v)).getTypedArray()).subarray(v.position(), v.remaining()));
        } else {
            this.gl.uniform4iv(loc, v.array());
        }
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniformMatrix2fv(loc, transpose, ((Float32Array)((HasArrayBufferView)((Object)value)).getTypedArray()).subarray(value.position(), value.remaining()));
        } else {
            this.gl.uniformMatrix2fv(loc, transpose, value.array());
        }
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniformMatrix3fv(loc, transpose, ((Float32Array)((HasArrayBufferView)((Object)value)).getTypedArray()).subarray(value.position(), value.remaining()));
        } else {
            this.gl.uniformMatrix3fv(loc, transpose, value.array());
        }
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        if (GWT.isProdMode()) {
            this.gl.uniformMatrix4fv(loc, transpose, ((Float32Array)((HasArrayBufferView)((Object)value)).getTypedArray()).subarray(value.position(), value.remaining()));
        } else {
            this.gl.uniformMatrix4fv(loc, transpose, value.array());
        }
    }

    public void glUseProgram(int program) {
        this.currProgram = program;
        this.gl.useProgram(this.programs.get(program));
    }

    public void glValidateProgram(int program) {
        this.gl.validateProgram(this.programs.get(program));
    }

    public void glVertexAttrib1f(int indx, float x) {
        this.gl.vertexAttrib1f(indx, x);
    }

    public void glVertexAttrib1fv(int indx, FloatBuffer values) {
        if (GWT.isProdMode()) {
            this.gl.vertexAttrib1fv(indx, ((Float32Array)((HasArrayBufferView)((Object)values)).getTypedArray()).subarray(values.position(), values.remaining()));
        } else {
            this.gl.vertexAttrib1fv(indx, values.array());
        }
    }

    public void glVertexAttrib2f(int indx, float x, float y) {
        this.gl.vertexAttrib2f(indx, x, y);
    }

    public void glVertexAttrib2fv(int indx, FloatBuffer values) {
        if (GWT.isProdMode()) {
            this.gl.vertexAttrib2fv(indx, ((Float32Array)((HasArrayBufferView)((Object)values)).getTypedArray()).subarray(values.position(), values.remaining()));
        } else {
            this.gl.vertexAttrib2fv(indx, values.array());
        }
    }

    public void glVertexAttrib3f(int indx, float x, float y, float z) {
        this.gl.vertexAttrib3f(indx, x, y, z);
    }

    public void glVertexAttrib3fv(int indx, FloatBuffer values) {
        if (GWT.isProdMode()) {
            this.gl.vertexAttrib3fv(indx, ((Float32Array)((HasArrayBufferView)((Object)values)).getTypedArray()).subarray(values.position(), values.remaining()));
        } else {
            this.gl.vertexAttrib3fv(indx, values.array());
        }
    }

    public void glVertexAttrib4f(int indx, float x, float y, float z, float w) {
        this.gl.vertexAttrib4f(indx, x, y, z, w);
    }

    public void glVertexAttrib4fv(int indx, FloatBuffer values) {
        if (GWT.isProdMode()) {
            this.gl.vertexAttrib4fv(indx, ((Float32Array)((HasArrayBufferView)((Object)values)).getTypedArray()).subarray(values.position(), values.remaining()));
        } else {
            this.gl.vertexAttrib4fv(indx, values.array());
        }
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, Buffer ptr) {
        throw new GdxRuntimeException("not implemented, vertex arrays aren't support in WebGL it seems");
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        this.gl.vertexAttribPointer(indx, size, type, normalized, stride, ptr);
    }
}

