/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.ServerSocket;
import com.badlogic.gdx.net.ServerSocketHints;
import com.badlogic.gdx.net.Socket;
import com.badlogic.gdx.net.SocketHints;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;

public class GwtNet
implements Net {
    public void sendHttpRequest(Net.HttpRequest httpRequest, final Net.HttpResponseListener httpResultListener) {
        if (httpRequest.getUrl() == null) {
            httpResultListener.failed((Throwable)new GdxRuntimeException("can't process a HTTP request without URL set"));
            return;
        }
        final boolean is_get = httpRequest.getMethod() == "GET";
        final String value = httpRequest.getContent();
        final RequestBuilder builder = is_get ? new RequestBuilder(RequestBuilder.GET, httpRequest.getUrl() + "?" + value) : new RequestBuilder(RequestBuilder.POST, httpRequest.getUrl());
        Map content = httpRequest.getHeaders();
        Set keySet = content.keySet();
        for (String name : keySet) {
            builder.setHeader(name, (String)content.get(name));
        }
        builder.setTimeoutMillis(httpRequest.getTimeOut());
        try {
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        builder.sendRequest(is_get ? null : value, new RequestCallback(){

                            public void onResponseReceived(Request request, Response response) {
                                httpResultListener.handleHttpResponse((Net.HttpResponse)new HttpClientResponse(response));
                            }

                            public void onError(Request request, Throwable exception) {
                                httpResultListener.failed(exception);
                            }
                        });
                    }
                    catch (RequestException e) {
                        httpResultListener.failed((Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    httpResultListener.failed((Throwable)e);
                }
            });
        }
    }

    public ServerSocket newServerSocket(Net.Protocol protocol, int port, ServerSocketHints hints) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Socket newClientSocket(Net.Protocol protocol, String host, int port, SocketHints hints) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void openURI(String URI) {
        Window.open((String)URI, (String)"_blank", null);
    }

    private final class HttpClientResponse
    implements Net.HttpResponse {
        private Response response;
        private Net.HttpStatus status;

        public HttpClientResponse(Response response) {
            this.response = response;
            this.status = new Net.HttpStatus(response.getStatusCode());
        }

        public byte[] getResult() {
            return null;
        }

        public String getResultAsString() {
            return this.response.getText();
        }

        public InputStream getResultAsStream() {
            return null;
        }

        public Net.HttpStatus getStatus() {
            return this.status;
        }
    }
}

