/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.google.gwt.corp.localstorage.LocalStorage;
import java.util.HashMap;
import java.util.Map;

public class GwtPreferences
implements Preferences {
    final String prefix;
    ObjectMap<String, Object> values = new ObjectMap();

    GwtPreferences(String prefix) {
        this.prefix = prefix + ":";
        int prefixLength = this.prefix.length();
        try {
            for (int i = 0; i < LocalStorage.length(); ++i) {
                String key = LocalStorage.key(i);
                if (!key.startsWith(prefix)) continue;
                String value = LocalStorage.getItem(key);
                this.values.put((Object)key.substring(prefixLength, key.length() - 1), this.toObject(key, value));
            }
        }
        catch (Exception e) {
            this.values.clear();
        }
    }

    private Object toObject(String key, String value) {
        if (key.endsWith("b")) {
            return new Boolean(Boolean.parseBoolean(value));
        }
        if (key.endsWith("i")) {
            return new Integer(Integer.parseInt(value));
        }
        if (key.endsWith("l")) {
            return new Long(Long.parseLong(value));
        }
        if (key.endsWith("f")) {
            return new Float(Float.parseFloat(value));
        }
        return value;
    }

    private String toStorageKey(String key, Object value) {
        if (value instanceof Boolean) {
            return this.prefix + key + "b";
        }
        if (value instanceof Integer) {
            return this.prefix + key + "i";
        }
        if (value instanceof Long) {
            return this.prefix + key + "l";
        }
        if (value instanceof Float) {
            return this.prefix + key + "f";
        }
        return this.prefix + key + "s";
    }

    public void flush() {
        try {
            for (int i = 0; i < LocalStorage.length(); ++i) {
                String key = LocalStorage.key(i);
                if (!key.startsWith(this.prefix)) continue;
                LocalStorage.removeItem(key);
            }
            for (String key : this.values.keys()) {
                String storageKey = this.toStorageKey(key, this.values.get((Object)key));
                String storageValue = "" + this.values.get((Object)key).toString();
                LocalStorage.setItem(storageKey, storageValue);
            }
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Couldn't flush preferences");
        }
    }

    public void putBoolean(String key, boolean val) {
        this.values.put((Object)key, (Object)val);
    }

    public void putInteger(String key, int val) {
        this.values.put((Object)key, (Object)val);
    }

    public void putLong(String key, long val) {
        this.values.put((Object)key, (Object)val);
    }

    public void putFloat(String key, float val) {
        this.values.put((Object)key, (Object)Float.valueOf(val));
    }

    public void putString(String key, String val) {
        this.values.put((Object)key, (Object)val);
    }

    public void put(Map<String, ?> vals) {
        for (String key : vals.keySet()) {
            this.values.put((Object)key, vals.get(key));
        }
    }

    public boolean getBoolean(String key) {
        Boolean v = (Boolean)this.values.get((Object)key);
        return v == null ? false : v;
    }

    public int getInteger(String key) {
        Integer v = (Integer)this.values.get((Object)key);
        return v == null ? 0 : v;
    }

    public long getLong(String key) {
        Long v = (Long)this.values.get((Object)key);
        return v == null ? 0L : v;
    }

    public float getFloat(String key) {
        Float v = (Float)this.values.get((Object)key);
        return v == null ? 0.0f : v.floatValue();
    }

    public String getString(String key) {
        return (String)this.values.get((Object)key);
    }

    public boolean getBoolean(String key, boolean defValue) {
        Boolean res = (Boolean)this.values.get((Object)key);
        return res == null ? defValue : res;
    }

    public int getInteger(String key, int defValue) {
        Integer res = (Integer)this.values.get((Object)key);
        return res == null ? defValue : res;
    }

    public long getLong(String key, long defValue) {
        Long res = (Long)this.values.get((Object)key);
        return res == null ? defValue : res;
    }

    public float getFloat(String key, float defValue) {
        Float res = (Float)this.values.get((Object)key);
        return res == null ? defValue : res.floatValue();
    }

    public String getString(String key, String defValue) {
        String res = (String)this.values.get((Object)key);
        return res == null ? defValue : res;
    }

    public Map<String, ?> get() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.values.keys()) {
            map.put(key, this.values.get((Object)key));
        }
        return map;
    }

    public boolean contains(String key) {
        return this.values.containsKey((Object)key);
    }

    public void clear() {
        this.values.clear();
    }

    public void remove(String key) {
        this.values.remove((Object)key);
    }
}

