/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.backends.gwt.preloader.AssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.AudioLoader;
import com.badlogic.gdx.backends.gwt.preloader.BinaryLoader;
import com.badlogic.gdx.backends.gwt.preloader.ImageLoader;
import com.badlogic.gdx.backends.gwt.preloader.LoaderCallback;
import com.badlogic.gdx.backends.gwt.preloader.PreloaderBundle;
import com.badlogic.gdx.backends.gwt.preloader.TextLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.ImageElement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Preloader {
    public ObjectMap<String, ImageElement> images = new ObjectMap();
    public ObjectMap<String, Void> audio = new ObjectMap();
    public ObjectMap<String, String> texts = new ObjectMap();
    public ObjectMap<String, BinaryLoader.Blob> binaries = new ObjectMap();
    public final String baseUrl = GWT.getModuleBaseURL().replace(GWT.getModuleName() + "/", "") + "assets/";

    public Preloader() {
        GWT.create(PreloaderBundle.class);
    }

    public void preload(final String assetFileUrl, final PreloaderCallback callback) {
        new TextLoader(this.baseUrl + assetFileUrl, new LoaderCallback<String>(){

            @Override
            public void success(String result) {
                String[] lines = result.split("\n");
                Array<Asset> assets = new Array<Asset>();
                for (String line : lines) {
                    String[] tokens = line.split(":");
                    if (tokens.length != 2) continue;
                    AssetFilter.AssetType type = AssetFilter.AssetType.Text;
                    if (tokens[0].equals("i")) {
                        type = AssetFilter.AssetType.Image;
                    }
                    if (tokens[0].equals("b")) {
                        type = AssetFilter.AssetType.Binary;
                    }
                    if (tokens[0].equals("a")) {
                        type = AssetFilter.AssetType.Audio;
                    }
                    if (tokens[0].equals("d")) {
                        type = AssetFilter.AssetType.Directory;
                    }
                    assets.add(new Asset(tokens[1].trim(), type));
                }
                Preloader.this.loadNextAsset(assets, 0, callback);
            }

            @Override
            public void error() {
                callback.error(assetFileUrl);
            }
        });
    }

    private void loadNextAsset(final Array<Asset> assets, final int next, final PreloaderCallback callback) {
        if (next == assets.size) {
            callback.done();
            return;
        }
        final Asset asset = assets.get(next);
        if (asset.type == AssetFilter.AssetType.Text) {
            new TextLoader(this.baseUrl + asset.url, new LoaderCallback<String>(){

                @Override
                public void success(String result) {
                    Preloader.this.texts.put((Object)asset.url, (Object)result);
                    callback.loaded(asset.url, next + 1, assets.size);
                    Preloader.this.loadNextAsset(assets, next + 1, callback);
                }

                @Override
                public void error() {
                    callback.error(asset.url);
                    Preloader.this.loadNextAsset(assets, next + 1, callback);
                }
            });
        }
        if (asset.type == AssetFilter.AssetType.Image) {
            new ImageLoader(this.baseUrl + asset.url, new LoaderCallback<ImageElement>(){

                @Override
                public void success(ImageElement result) {
                    Preloader.this.images.put((Object)asset.url, (Object)result);
                    callback.loaded(asset.url, next + 1, assets.size);
                    Preloader.this.loadNextAsset(assets, next + 1, callback);
                }

                @Override
                public void error() {
                    callback.error(asset.url);
                    Preloader.this.loadNextAsset(assets, next + 1, callback);
                }
            });
        }
        if (asset.type == AssetFilter.AssetType.Binary) {
            new BinaryLoader(this.baseUrl + asset.url, new LoaderCallback<BinaryLoader.Blob>(){

                @Override
                public void success(BinaryLoader.Blob result) {
                    Preloader.this.binaries.put((Object)asset.url, (Object)result);
                    callback.loaded(asset.url, next + 1, assets.size);
                    Preloader.this.loadNextAsset(assets, next + 1, callback);
                }

                @Override
                public void error() {
                    callback.error(asset.url);
                    Preloader.this.loadNextAsset(assets, next + 1, callback);
                }
            });
        }
        if (asset.type == AssetFilter.AssetType.Audio) {
            new AudioLoader(this.baseUrl + asset.url, new LoaderCallback<Void>(){

                @Override
                public void success(Void result) {
                    Preloader.this.audio.put((Object)asset.url, null);
                    callback.loaded(asset.url, next + 1, assets.size);
                    Preloader.this.loadNextAsset(assets, next + 1, callback);
                }

                @Override
                public void error() {
                    callback.error(asset.url);
                    Preloader.this.loadNextAsset(assets, next + 1, callback);
                }
            });
        }
        if (asset.type == AssetFilter.AssetType.Directory) {
            this.loadNextAsset(assets, next + 1, callback);
        }
    }

    public InputStream read(String url) {
        if (this.texts.containsKey((Object)url)) {
            try {
                return new ByteArrayInputStream(((String)this.texts.get((Object)url)).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        if (this.images.containsKey((Object)url)) {
            return new ByteArrayInputStream(new byte[1]);
        }
        if (this.binaries.containsKey((Object)url)) {
            return ((BinaryLoader.Blob)this.binaries.get((Object)url)).read();
        }
        if (this.audio.containsKey((Object)url)) {
            return new ByteArrayInputStream(new byte[1]);
        }
        return null;
    }

    public boolean contains(String url) {
        return this.texts.containsKey((Object)url) || this.images.containsKey((Object)url) || this.binaries.containsKey((Object)url) || this.audio.containsKey((Object)url);
    }

    public boolean isText(String url) {
        return this.texts.containsKey((Object)url);
    }

    public boolean isImage(String url) {
        return this.images.containsKey((Object)url);
    }

    public boolean isBinary(String url) {
        return this.binaries.containsKey((Object)url);
    }

    public boolean isAudio(String url) {
        return this.audio.containsKey((Object)url);
    }

    public FileHandle[] list(String url) {
        throw new GdxRuntimeException("Not implemented");
    }

    public boolean isDirectory(String url) {
        throw new GdxRuntimeException("Not implemented");
    }

    public long length(String url) {
        if (this.texts.containsKey((Object)url)) {
            try {
                return ((String)this.texts.get((Object)url)).getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                return ((String)this.texts.get((Object)url)).getBytes().length;
            }
        }
        if (this.images.containsKey((Object)url)) {
            return 1L;
        }
        if (this.binaries.containsKey((Object)url)) {
            return ((BinaryLoader.Blob)this.binaries.get((Object)url)).length();
        }
        if (this.audio.containsKey((Object)url)) {
            return 1L;
        }
        return 0L;
    }

    private class Asset {
        String url;
        AssetFilter.AssetType type;

        public Asset(String url, AssetFilter.AssetType type) {
            this.url = url;
            this.type = type;
        }
    }

    public static interface PreloaderCallback {
        public void done();

        public void loaded(String var1, int var2, int var3);

        public void error(String var1);
    }
}

