/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.backends.gwt.GwtFileHandle;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.CanvasPixelArray;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.ImageElement;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;

public class Pixmap
implements Disposable {
    public static Map<Integer, Pixmap> pixmaps = new HashMap<Integer, Pixmap>();
    static int nextId = 0;
    int width;
    int height;
    Format format;
    Canvas canvas;
    Context2d context;
    int id;
    IntBuffer buffer;
    int r = 255;
    int g = 255;
    int b = 255;
    float a;
    String color = Pixmap.make(this.r, this.g, this.b, this.a);
    static Blending blending;
    CanvasPixelArray pixels;

    public Pixmap(FileHandle file) {
        GwtFileHandle gwtFile = (GwtFileHandle)file;
        ImageElement img = (ImageElement)gwtFile.preloader.images.get((Object)file.path());
        if (img == null) {
            throw new GdxRuntimeException("Couldn't load image '" + file.path() + "', file does not exist");
        }
        this.create(img.getWidth(), img.getHeight(), Format.RGBA8888);
        this.context.setGlobalCompositeOperation(Context2d.Composite.COPY);
        this.context.drawImage(img, 0.0, 0.0);
        this.context.setGlobalCompositeOperation(Pixmap.getComposite());
    }

    private static Context2d.Composite getComposite() {
        return blending == Blending.None ? Context2d.Composite.COPY : Context2d.Composite.SOURCE_OVER;
    }

    public Pixmap(ImageElement img) {
        this.create(img.getWidth(), img.getHeight(), Format.RGBA8888);
        this.context.drawImage(img, 0.0, 0.0);
    }

    public Pixmap(int width, int height, Format format) {
        this.create(width, height, format);
    }

    private void create(int width, int height, Format format2) {
        this.width = width;
        this.height = height;
        this.format = Format.RGBA8888;
        this.canvas = Canvas.createIfSupported();
        this.canvas.getCanvasElement().setWidth(width);
        this.canvas.getCanvasElement().setHeight(height);
        this.context = this.canvas.getContext2d();
        this.context.setGlobalCompositeOperation(Pixmap.getComposite());
        this.buffer = BufferUtils.newIntBuffer(1);
        this.id = nextId++;
        this.buffer.put(0, this.id);
        pixmaps.put(this.id, this);
    }

    public static String make(int r2, int g2, int b2, float a2) {
        return "rgba(" + r2 + "," + g2 + "," + b2 + "," + a2 + ")";
    }

    public static void setBlending(Blending blending) {
        Pixmap.blending = blending;
        Context2d.Composite composite = Pixmap.getComposite();
        for (Pixmap pixmap : pixmaps.values()) {
            pixmap.context.setGlobalCompositeOperation(composite);
        }
    }

    public static Blending getBlending() {
        return blending;
    }

    public static void setFilter(Filter filter) {
    }

    public Format getFormat() {
        return this.format;
    }

    public int getGLInternalFormat() {
        return 6408;
    }

    public int getGLFormat() {
        return 6408;
    }

    public int getGLType() {
        return 5121;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Buffer getPixels() {
        return this.buffer;
    }

    public void dispose() {
        pixmaps.remove(this.id);
    }

    public CanvasElement getCanvasElement() {
        return this.canvas.getCanvasElement();
    }

    public void setColor(int color) {
        this.a = (float)(color >>> 24 & 0xFF) / 255.0f;
        this.r = color >>> 16 & 0xFF;
        this.g = color >>> 8 & 0xFF;
        this.b = color & 0xFF;
        this.color = Pixmap.make(this.r, this.g, this.b, this.a);
        this.context.setFillStyle(this.color);
        this.context.setStrokeStyle(this.color);
    }

    public void setColor(float r, float g, float b, float a) {
        this.r = (int)(r * 255.0f);
        this.g = (int)(g * 255.0f);
        this.b = (int)(b * 255.0f);
        this.a = a;
        this.color = Pixmap.make(this.r, this.g, this.b, this.a);
        this.context.setFillStyle(this.color);
        this.context.setStrokeStyle(this.color);
    }

    public void setColor(Color color) {
        this.setColor(color.r, color.g, color.b, color.a);
    }

    public void fill() {
        this.context.fillRect(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.context.beginPath();
        this.context.moveTo((double)x, (double)y);
        this.context.lineTo((double)x2, (double)y2);
        this.context.stroke();
        this.context.closePath();
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.context.beginPath();
        this.context.rect((double)x, (double)y, (double)width, (double)height);
        this.context.stroke();
        this.context.closePath();
    }

    public void drawPixmap(Pixmap pixmap, int x, int y) {
        this.context.drawImage(pixmap.getCanvasElement(), (double)x, (double)y);
    }

    public void drawPixmap(Pixmap pixmap, int x, int y, int srcx, int srcy, int srcWidth, int srcHeight) {
        this.context.drawImage(pixmap.getCanvasElement(), (double)srcx, (double)srcy, (double)srcWidth, (double)srcHeight, (double)x, (double)y, (double)srcWidth, (double)srcHeight);
    }

    public void drawPixmap(Pixmap pixmap, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight) {
        this.context.drawImage(pixmap.getCanvasElement(), (double)srcx, (double)srcy, (double)srcWidth, (double)srcHeight, (double)dstx, (double)dsty, (double)dstWidth, (double)dstHeight);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.context.fillRect((double)x, (double)y, (double)width, (double)height);
    }

    public void drawCircle(int x, int y, int radius) {
        this.context.beginPath();
        this.context.arc((double)x, (double)y, (double)radius, 0.0, Math.PI * 2, false);
        this.context.stroke();
        this.context.closePath();
    }

    public void fillCircle(int x, int y, int radius) {
        this.context.beginPath();
        this.context.arc((double)x, (double)y, (double)radius, 0.0, Math.PI * 2, false);
        this.context.fill();
        this.context.closePath();
    }

    public int getPixel(int x, int y) {
        if (this.pixels == null) {
            this.pixels = this.context.getImageData(0.0, 0.0, (double)this.width, (double)this.height).getData();
        }
        int i = x * 4 + y * this.width * 4;
        int r = this.pixels.get(i + 0) & 0xFF;
        int g = this.pixels.get(i + 1) & 0xFF;
        int b = this.pixels.get(i + 2) & 0xFF;
        int a = this.pixels.get(i + 3) & 0xFF;
        return r << 24 | g << 16 | b << 8 | a;
    }

    public void drawPixel(int x, int y) {
        this.context.fillRect((double)x, (double)y, 1.0, 1.0);
    }

    public void drawPixel(int x, int y, int color) {
        this.setColor(color);
        this.drawPixel(x, y);
    }

    public static enum Filter {
        NearestNeighbour,
        BiLinear;

    }

    public static enum Blending {
        None,
        SourceOver;

    }

    public static enum Format {
        Alpha,
        Intensity,
        LuminanceAlpha,
        RGB565,
        RGBA4444,
        RGB888,
        RGBA8888;

    }
}

