/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointEdge;
import com.badlogic.gdx.physics.box2d.MassData;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.Transform;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.BodyType;

public class Body {
    final World world;
    public final org.jbox2d.dynamics.Body body;
    final Vec2 tmp = new Vec2();
    final Vec2 tmp2 = new Vec2();
    final ArrayList<Fixture> fixtures = new ArrayList();
    final ArrayList<JointEdge> joints = new ArrayList();
    Transform transform = new Transform();
    final Vector2 position = new Vector2();
    final Vector2 worldCenter = new Vector2();
    private final Vector2 localCenter = new Vector2();
    private final Vector2 linearVelocity = new Vector2();
    private final MassData massData = new MassData();
    private final org.jbox2d.collision.shapes.MassData massData2 = new org.jbox2d.collision.shapes.MassData();
    private final Vector2 worldPoint = new Vector2();
    private final Vector2 worldVector = new Vector2();
    public final Vector2 localPoint2 = new Vector2();
    public final Vector2 localVector = new Vector2();
    public final Vector2 linVelWorld = new Vector2();
    public final Vector2 linVelLoc = new Vector2();
    private Object userData;

    protected Body(World world, org.jbox2d.dynamics.Body body) {
        this.world = world;
        this.body = body;
    }

    public void setTransform(Vector2 position, float angle) {
        this.tmp.set(position.x, position.y);
        this.body.setTransform(this.tmp, angle);
    }

    public void setTransform(float x, float y, float angle) {
        this.tmp.set(x, y);
        this.body.setTransform(this.tmp, angle);
    }

    public Transform getTransform() {
        org.jbox2d.common.Transform trans = this.body.getTransform();
        this.transform.vals[0] = trans.p.x;
        this.transform.vals[1] = trans.p.y;
        this.transform.vals[2] = trans.q.c;
        this.transform.vals[3] = trans.q.s;
        return this.transform;
    }

    public Vector2 getPosition() {
        Vec2 pos = this.body.getPosition();
        this.position.set(pos.x, pos.y);
        return this.position;
    }

    public float getAngle() {
        return this.body.getAngle();
    }

    public Vector2 getWorldCenter() {
        Vec2 wc = this.body.getWorldCenter();
        return this.worldCenter.set(wc.x, wc.y);
    }

    public Vector2 getLocalCenter() {
        Vec2 lc = this.body.getLocalCenter();
        this.localCenter.set(lc.x, lc.y);
        return this.localCenter;
    }

    public void setLinearVelocity(Vector2 v) {
        this.tmp.set(v.x, v.y);
        this.body.setLinearVelocity(this.tmp);
    }

    public void setLinearVelocity(float vX, float vY) {
        this.tmp.set(vX, vY);
        this.body.setLinearVelocity(this.tmp);
    }

    public Vector2 getLinearVelocity() {
        Vec2 lv = this.body.getLinearVelocity();
        this.linearVelocity.set(lv.x, lv.y);
        return this.linearVelocity;
    }

    public void setAngularVelocity(float omega) {
        this.body.setAngularVelocity(omega);
    }

    public float getAngularVelocity() {
        return this.body.getAngularVelocity();
    }

    public void applyForce(Vector2 force, Vector2 point) {
        this.tmp.set(force.x, force.y);
        this.tmp2.set(point.x, point.y);
        this.body.applyForce(this.tmp, this.tmp2);
    }

    public void applyForce(float forceX, float forceY, float pointX, float pointY) {
        this.tmp.set(forceX, forceY);
        this.tmp2.set(pointX, pointY);
        this.body.applyForce(this.tmp, this.tmp2);
    }

    public void applyForceToCenter(Vector2 force) {
        this.tmp.set(force.x, force.y);
        this.body.applyForceToCenter(this.tmp);
    }

    public void applyForceToCenter(float forceX, float forceY) {
        this.tmp.set(forceX, forceY);
        this.body.applyForceToCenter(this.tmp);
    }

    public void applyTorque(float torque) {
        this.body.applyTorque(torque);
    }

    public void applyLinearImpulse(Vector2 impulse, Vector2 point) {
        this.tmp.set(impulse.x, impulse.y);
        this.tmp2.set(point.x, point.y);
        this.body.applyLinearImpulse(this.tmp, this.tmp2);
    }

    public void applyLinearImpulse(float impulseX, float impulseY, float pointX, float pointY) {
        this.tmp.set(impulseX, impulseY);
        this.tmp2.set(pointX, pointY);
        this.body.applyLinearImpulse(this.tmp, this.tmp2);
    }

    public void applyAngularImpulse(float impulse) {
        this.body.applyAngularImpulse(impulse);
    }

    public float getMass() {
        return this.body.getMass();
    }

    public float getInertia() {
        return this.body.getInertia();
    }

    public MassData getMassData() {
        this.body.getMassData(this.massData2);
        this.massData.center.set(this.massData2.center.x, this.massData2.center.y);
        this.massData.I = this.massData2.I;
        this.massData.mass = this.massData2.mass;
        return this.massData;
    }

    public void setMassData(MassData data) {
        this.massData2.center.set(data.center.x, data.center.y);
        this.massData2.I = data.I;
        this.massData2.mass = data.mass;
        this.body.setMassData(this.massData2);
    }

    public void resetMassData() {
        this.body.resetMassData();
    }

    public Vector2 getWorldPoint(Vector2 localPoint) {
        this.tmp.set(localPoint.x, localPoint.y);
        Vec2 wp = this.body.getWorldPoint(this.tmp);
        return this.worldPoint.set(wp.x, wp.y);
    }

    public Vector2 getWorldVector(Vector2 localVector) {
        this.tmp.set(localVector.x, localVector.y);
        Vec2 wv = this.body.getWorldVector(this.tmp);
        return this.worldVector.set(wv.x, wv.y);
    }

    public Vector2 getLocalPoint(Vector2 worldPoint) {
        this.tmp.set(worldPoint.x, worldPoint.y);
        Vec2 lp = this.body.getLocalPoint(this.tmp);
        return this.localPoint2.set(lp.x, lp.y);
    }

    public Vector2 getLocalVector(Vector2 worldVector) {
        this.tmp.set(worldVector.x, worldVector.y);
        Vec2 lv = this.body.getLocalVector(this.tmp);
        return this.localVector.set(lv.x, lv.y);
    }

    public Vector2 getLinearVelocityFromWorldPoint(Vector2 worldPoint) {
        this.tmp.set(worldPoint.x, worldPoint.y);
        Vec2 lv = this.body.getLinearVelocityFromWorldPoint(this.tmp);
        return this.linVelWorld.set(lv.x, lv.y);
    }

    public Vector2 getLinearVelocityFromLocalPoint(Vector2 localPoint) {
        this.tmp.set(localPoint.x, localPoint.y);
        Vec2 lv = this.body.getLinearVelocityFromLocalPoint(this.tmp);
        return this.linVelLoc.set(lv.x, lv.y);
    }

    public float getLinearDamping() {
        return this.body.getLinearDamping();
    }

    public void setLinearDamping(float linearDamping) {
        this.body.setLinearDamping(linearDamping);
    }

    public float getAngularDamping() {
        return this.body.getAngularDamping();
    }

    public void setAngularDamping(float angularDamping) {
        this.body.setAngularDamping(angularDamping);
    }

    public void setType(BodyDef.BodyType type) {
        BodyType t = BodyType.DYNAMIC;
        if (type == BodyDef.BodyType.DynamicBody) {
            t = BodyType.DYNAMIC;
        }
        if (type == BodyDef.BodyType.KinematicBody) {
            t = BodyType.KINEMATIC;
        }
        if (type == BodyDef.BodyType.StaticBody) {
            t = BodyType.STATIC;
        }
        this.body.setType(t);
    }

    public BodyDef.BodyType getType() {
        BodyType type = this.body.getType();
        if (type == BodyType.DYNAMIC) {
            return BodyDef.BodyType.DynamicBody;
        }
        if (type == BodyType.KINEMATIC) {
            return BodyDef.BodyType.KinematicBody;
        }
        if (type == BodyType.STATIC) {
            return BodyDef.BodyType.StaticBody;
        }
        return BodyDef.BodyType.DynamicBody;
    }

    public void setBullet(boolean flag) {
        this.body.setBullet(flag);
    }

    public boolean isBullet() {
        return this.body.isBullet();
    }

    public void setSleepingAllowed(boolean flag) {
        this.body.setSleepingAllowed(flag);
    }

    public boolean isSleepingAllowed() {
        return this.body.isSleepingAllowed();
    }

    public void setAwake(boolean flag) {
        this.body.setAwake(flag);
    }

    public boolean isAwake() {
        return this.body.isAwake();
    }

    public void setActive(boolean flag) {
        this.body.setActive(flag);
    }

    public boolean isActive() {
        return this.body.isActive();
    }

    public void setFixedRotation(boolean flag) {
        this.body.setFixedRotation(flag);
    }

    public boolean isFixedRotation() {
        return this.body.isFixedRotation();
    }

    public Fixture createFixture(FixtureDef def) {
        org.jbox2d.dynamics.FixtureDef fd = def.toJBox2d();
        org.jbox2d.dynamics.Fixture f = this.body.createFixture(fd);
        Fixture fixture = new Fixture(this, f);
        this.fixtures.add(fixture);
        this.world.fixtures.put((Object)f, (Object)fixture);
        return fixture;
    }

    public Fixture createFixture(Shape shape, float density) {
        org.jbox2d.dynamics.Fixture f = this.body.createFixture(shape.shape, density);
        Fixture fixture = new Fixture(this, f);
        this.fixtures.add(fixture);
        this.world.fixtures.put((Object)f, (Object)fixture);
        return fixture;
    }

    public void destroyFixture(Fixture fixture) {
        this.body.destroyFixture(fixture.fixture);
        this.fixtures.remove(fixture);
        this.world.fixtures.remove((Object)fixture.fixture);
    }

    public ArrayList<Fixture> getFixtureList() {
        return this.fixtures;
    }

    public ArrayList<JointEdge> getJointList() {
        org.jbox2d.dynamics.joints.JointEdge jointEdge = this.body.getJointList();
        this.joints.clear();
        while (jointEdge != null) {
            JointEdge edge = new JointEdge((Body)this.world.bodies.get((Object)jointEdge.other), (Joint)this.world.joints.get((Object)jointEdge.joint));
            this.joints.add(edge);
            jointEdge = jointEdge.next;
        }
        return this.joints;
    }

    public float getGravityScale() {
        return this.body.getGravityScale();
    }

    public void setGravityScale(float scale) {
        this.body.setGravityScale(scale);
    }

    public World getWorld() {
        return this.world;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }
}

