/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Shape;
import org.jbox2d.common.Vec2;

public class ChainShape
extends Shape {
    org.jbox2d.collision.shapes.ChainShape shape;
    boolean isLooped = false;

    public ChainShape() {
        super(new org.jbox2d.collision.shapes.ChainShape());
        this.shape = (org.jbox2d.collision.shapes.ChainShape)((Shape)this).shape;
    }

    ChainShape(org.jbox2d.collision.shapes.ChainShape shape) {
        super(shape);
        this.shape = shape;
    }

    @Override
    public Shape.Type getType() {
        return Shape.Type.Chain;
    }

    public void createLoop(Vector2[] vertices) {
        Vec2[] v = new Vec2[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            v[i] = new Vec2(vertices[i].x, vertices[i].y);
        }
        this.shape.createLoop(v, v.length);
        this.isLooped = true;
    }

    public void createChain(Vector2[] vertices) {
        Vec2[] v = new Vec2[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            v[i] = new Vec2(vertices[i].x, vertices[i].y);
        }
        this.shape.createChain(v, v.length);
        this.isLooped = false;
    }

    public void setPrevVertex(Vector2 prevVertex) {
        this.shape.setPrevVertex(new Vec2(prevVertex.x, prevVertex.y));
    }

    public void setPrevVertex(float prevVertexX, float prevVertexY) {
        this.shape.setPrevVertex(new Vec2(prevVertexX, prevVertexY));
    }

    public void setNextVertex(Vector2 nextVertex) {
        this.shape.setNextVertex(new Vec2(nextVertex.x, nextVertex.y));
    }

    public void setNextVertex(float nextVertexX, float nextVertexY) {
        this.shape.setNextVertex(new Vec2(nextVertexX, nextVertexY));
    }

    public int getVertexCount() {
        return this.shape.m_count;
    }

    public void getVertex(int index, Vector2 vertex) {
        Vec2 v = this.shape.m_vertices[index];
        vertex.set(v.x, v.y);
    }

    @Override
    public float getRadius() {
        return this.shape.getRadius();
    }

    @Override
    public void setRadius(float radius) {
        this.shape.setRadius(radius);
    }

    @Override
    public int getChildCount() {
        return this.shape.getChildCount();
    }

    public boolean isLooped() {
        return this.isLooped;
    }
}

