/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.EdgeShape;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Vec2;

public class Fixture {
    org.jbox2d.dynamics.Fixture fixture;
    private Body body;
    protected Shape shape;
    protected Object userData;
    private final Filter filter = new Filter();
    final Vec2 tmp = new Vec2();

    protected Fixture(Body body, org.jbox2d.dynamics.Fixture fixture) {
        this.body = body;
        this.fixture = fixture;
    }

    protected void reset(Body body, org.jbox2d.dynamics.Fixture fixture) {
        this.body = body;
        this.fixture = fixture;
        this.shape = null;
        this.userData = null;
    }

    public Shape.Type getType() {
        ShapeType type = this.fixture.getType();
        if (type == ShapeType.CIRCLE) {
            return Shape.Type.Circle;
        }
        if (type == ShapeType.EDGE) {
            return Shape.Type.Edge;
        }
        if (type == ShapeType.POLYGON) {
            return Shape.Type.Polygon;
        }
        if (type == ShapeType.CHAIN) {
            return Shape.Type.Chain;
        }
        return Shape.Type.Circle;
    }

    public Shape getShape() {
        if (this.shape == null) {
            org.jbox2d.collision.shapes.Shape shape2 = this.fixture.getShape();
            ShapeType type = shape2.getType();
            if (type == ShapeType.CHAIN) {
                this.shape = new ChainShape((org.jbox2d.collision.shapes.ChainShape)shape2);
            }
            if (type == ShapeType.CIRCLE) {
                this.shape = new CircleShape((org.jbox2d.collision.shapes.CircleShape)shape2);
            }
            if (type == ShapeType.EDGE) {
                this.shape = new EdgeShape((org.jbox2d.collision.shapes.EdgeShape)shape2);
            }
            if (type == ShapeType.POLYGON) {
                this.shape = new PolygonShape((org.jbox2d.collision.shapes.PolygonShape)shape2);
            }
        }
        return this.shape;
    }

    public void setSensor(boolean sensor) {
        this.fixture.setSensor(sensor);
    }

    public boolean isSensor() {
        return this.fixture.isSensor();
    }

    public void setFilterData(Filter filter) {
        org.jbox2d.dynamics.Filter f = new org.jbox2d.dynamics.Filter();
        f.categoryBits = filter.categoryBits;
        f.groupIndex = filter.groupIndex;
        f.maskBits = filter.maskBits;
        this.fixture.setFilterData(f);
    }

    public Filter getFilterData() {
        org.jbox2d.dynamics.Filter f = this.fixture.getFilterData();
        this.filter.categoryBits = (short)f.categoryBits;
        this.filter.maskBits = (short)f.maskBits;
        this.filter.groupIndex = (short)f.groupIndex;
        return this.filter;
    }

    public void refilter() {
        this.fixture.refilter();
    }

    public Body getBody() {
        return this.body;
    }

    public boolean testPoint(Vector2 p) {
        this.tmp.set(p.x, p.y);
        return this.fixture.testPoint(this.tmp);
    }

    public boolean testPoint(float x, float y) {
        this.tmp.set(x, y);
        return this.fixture.testPoint(this.tmp);
    }

    public void setDensity(float density) {
        this.fixture.setDensity(density);
    }

    public float getDensity() {
        return this.fixture.getDensity();
    }

    public float getFriction() {
        return this.fixture.getFriction();
    }

    public void setFriction(float friction) {
        this.fixture.setFriction(friction);
    }

    public float getRestitution() {
        return this.fixture.getRestitution();
    }

    public void setRestitution(float restitution) {
        this.fixture.setRestitution(restitution);
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Object getUserData() {
        return this.userData;
    }
}

