/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.JointEdge;
import com.badlogic.gdx.physics.box2d.World;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.joints.JointType;

public abstract class Joint {
    World world;
    org.jbox2d.dynamics.joints.Joint joint;
    JointEdge jointEdgeA;
    JointEdge jointEdgeB;
    final Vec2 tmp = new Vec2();
    private final Vector2 anchorA = new Vector2();
    private final Vector2 anchorB = new Vector2();
    private final Vector2 reactionForce = new Vector2();

    protected Joint(World world, org.jbox2d.dynamics.joints.Joint joint) {
        this.world = world;
        this.joint = joint;
    }

    public JointDef.JointType getType() {
        JointType type2 = this.joint.getType();
        if (type2 == JointType.DISTANCE) {
            return JointDef.JointType.DistanceJoint;
        }
        if (type2 == JointType.FRICTION) {
            return JointDef.JointType.FrictionJoint;
        }
        if (type2 == JointType.GEAR) {
            return JointDef.JointType.GearJoint;
        }
        if (type2 == JointType.MOUSE) {
            return JointDef.JointType.MouseJoint;
        }
        if (type2 == JointType.PRISMATIC) {
            return JointDef.JointType.PrismaticJoint;
        }
        if (type2 == JointType.PULLEY) {
            return JointDef.JointType.PulleyJoint;
        }
        if (type2 == JointType.REVOLUTE) {
            return JointDef.JointType.RevoluteJoint;
        }
        if (type2 == JointType.ROPE) {
            return JointDef.JointType.RopeJoint;
        }
        if (type2 == JointType.UNKNOWN) {
            return JointDef.JointType.Unknown;
        }
        if (type2 == JointType.WELD) {
            return JointDef.JointType.WeldJoint;
        }
        if (type2 == JointType.WHEEL) {
            return JointDef.JointType.WheelJoint;
        }
        return JointDef.JointType.Unknown;
    }

    public Body getBodyA() {
        return (Body)this.world.bodies.get((Object)this.joint.m_bodyA);
    }

    public Body getBodyB() {
        return (Body)this.world.bodies.get((Object)this.joint.m_bodyB);
    }

    public Vector2 getAnchorA() {
        this.joint.getAnchorA(this.tmp);
        return this.anchorA.set(this.tmp.x, this.tmp.y);
    }

    public Vector2 getAnchorB() {
        this.joint.getAnchorB(this.tmp);
        return this.anchorB.set(this.tmp.x, this.tmp.y);
    }

    public Vector2 getReactionForce(float inv_dt) {
        this.joint.getReactionForce(inv_dt, this.tmp);
        return this.reactionForce.set(this.tmp.x, this.tmp.y);
    }

    public float getReactionTorque(float inv_dt) {
        return this.joint.getReactionTorque(inv_dt);
    }

    public boolean isActive() {
        return this.joint.IsActive();
    }
}

