/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactFilter;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.DestructionListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.QueryCallback;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.physics.box2d.joints.DistanceJoint;
import com.badlogic.gdx.physics.box2d.joints.FrictionJoint;
import com.badlogic.gdx.physics.box2d.joints.MouseJoint;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJoint;
import com.badlogic.gdx.physics.box2d.joints.PulleyJoint;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJoint;
import com.badlogic.gdx.physics.box2d.joints.WeldJoint;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jbox2d.collision.AABB;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.JointEdge;

public final class World
implements Disposable {
    org.jbox2d.dynamics.World world;
    Vec2 tmp = new Vec2();
    Vector2 tmp2 = new Vector2();
    ObjectMap<org.jbox2d.dynamics.Body, Body> bodies = new ObjectMap();
    ObjectMap<org.jbox2d.dynamics.Fixture, Fixture> fixtures = new ObjectMap();
    ObjectMap<org.jbox2d.dynamics.joints.Joint, Joint> joints = new ObjectMap();
    Contact tmpContact = new Contact(this);
    Manifold tmpManifold = new Manifold();
    ContactImpulse tmpImpulse = new ContactImpulse();
    AABB aabb = new AABB();
    ArrayList<Contact> contacts = new ArrayList();
    Vec2 point1 = new Vec2();
    Vec2 point2 = new Vec2();
    Vector2 point = new Vector2();
    Vector2 normal = new Vector2();

    public World(Vector2 gravity, boolean doSleep) {
        this.world = new org.jbox2d.dynamics.World(this.tmp.set(gravity.x, gravity.y));
        this.world.setAllowSleep(doSleep);
    }

    public void setDestructionListener(DestructionListener listener) {
    }

    public void setContactFilter(final ContactFilter filter) {
        if (filter != null) {
            this.world.setContactFilter(new org.jbox2d.callbacks.ContactFilter(){

                @Override
                public boolean shouldCollide(org.jbox2d.dynamics.Fixture fixtureA, org.jbox2d.dynamics.Fixture fixtureB) {
                    return filter.shouldCollide((Fixture)World.this.fixtures.get((Object)fixtureA), (Fixture)World.this.fixtures.get((Object)fixtureB));
                }
            });
        } else {
            this.world.setContactFilter(new org.jbox2d.callbacks.ContactFilter());
        }
    }

    public void setContactListener(final ContactListener listener) {
        if (listener != null) {
            this.world.setContactListener(new org.jbox2d.callbacks.ContactListener(){

                @Override
                public void beginContact(org.jbox2d.dynamics.contacts.Contact contact) {
                    World.this.tmpContact.contact = contact;
                    listener.beginContact(World.this.tmpContact);
                }

                @Override
                public void endContact(org.jbox2d.dynamics.contacts.Contact contact) {
                    World.this.tmpContact.contact = contact;
                    listener.endContact(World.this.tmpContact);
                }

                @Override
                public void preSolve(org.jbox2d.dynamics.contacts.Contact contact, org.jbox2d.collision.Manifold oldManifold) {
                    World.this.tmpContact.contact = contact;
                    World.this.tmpManifold.manifold = oldManifold;
                    listener.preSolve(World.this.tmpContact, World.this.tmpManifold);
                }

                @Override
                public void postSolve(org.jbox2d.dynamics.contacts.Contact contact, org.jbox2d.callbacks.ContactImpulse impulse) {
                    World.this.tmpContact.contact = contact;
                    World.this.tmpImpulse.impulse = impulse;
                    listener.postSolve(World.this.tmpContact, World.this.tmpImpulse);
                }
            });
        } else {
            this.world.setContactListener(null);
        }
    }

    public Body createBody(BodyDef def) {
        org.jbox2d.dynamics.BodyDef bd = new org.jbox2d.dynamics.BodyDef();
        bd.active = def.active;
        bd.allowSleep = def.allowSleep;
        bd.angle = def.angle;
        bd.angularDamping = def.angularDamping;
        bd.angularVelocity = def.angularVelocity;
        bd.awake = def.awake;
        bd.bullet = def.bullet;
        bd.fixedRotation = def.fixedRotation;
        bd.gravityScale = def.gravityScale;
        bd.linearDamping = def.linearDamping;
        bd.linearVelocity.set(def.linearVelocity.x, def.linearVelocity.y);
        bd.position.set(def.position.x, def.position.y);
        if (def.type == BodyDef.BodyType.DynamicBody) {
            bd.type = BodyType.DYNAMIC;
        }
        if (def.type == BodyDef.BodyType.StaticBody) {
            bd.type = BodyType.STATIC;
        }
        if (def.type == BodyDef.BodyType.KinematicBody) {
            bd.type = BodyType.KINEMATIC;
        }
        org.jbox2d.dynamics.Body b = this.world.createBody(bd);
        Body body = new Body(this, b);
        this.bodies.put((Object)b, (Object)body);
        return body;
    }

    public void destroyBody(Body body) {
        this.world.destroyBody(body.body);
        this.bodies.remove((Object)body.body);
        for (Fixture fixture : body.fixtures) {
            this.fixtures.remove((Object)fixture.fixture);
        }
        JointEdge jointEdge = body.body.getJointList();
        while (jointEdge != null) {
            this.joints.remove((Object)jointEdge.joint);
        }
    }

    public Joint createJoint(JointDef def) {
        org.jbox2d.dynamics.joints.JointDef jd = def.toJBox2d();
        org.jbox2d.dynamics.joints.Joint j = this.world.createJoint(jd);
        Joint joint = null;
        if (def.type == JointDef.JointType.DistanceJoint) {
            joint = new DistanceJoint(this, (org.jbox2d.dynamics.joints.DistanceJoint)j);
        }
        if (def.type == JointDef.JointType.FrictionJoint) {
            joint = new FrictionJoint(this, (org.jbox2d.dynamics.joints.FrictionJoint)j);
        }
        if (def.type == JointDef.JointType.MouseJoint) {
            joint = new MouseJoint(this, (org.jbox2d.dynamics.joints.MouseJoint)j);
        }
        if (def.type == JointDef.JointType.PrismaticJoint) {
            joint = new PrismaticJoint(this, (org.jbox2d.dynamics.joints.PrismaticJoint)j);
        }
        if (def.type == JointDef.JointType.PulleyJoint) {
            joint = new PulleyJoint(this, (org.jbox2d.dynamics.joints.PulleyJoint)j);
        }
        if (def.type == JointDef.JointType.RevoluteJoint) {
            joint = new RevoluteJoint(this, (org.jbox2d.dynamics.joints.RevoluteJoint)j);
        }
        if (def.type == JointDef.JointType.WeldJoint) {
            joint = new WeldJoint(this, (org.jbox2d.dynamics.joints.WeldJoint)j);
        }
        if (joint == null) {
            throw new GdxRuntimeException("Joint type '" + (Object)((Object)def.type) + "' not yet supported by GWT backend");
        }
        this.joints.put((Object)j, (Object)joint);
        return joint;
    }

    public void destroyJoint(Joint joint) {
        this.world.destroyJoint(joint.joint);
        this.joints.remove((Object)joint.joint);
    }

    public void step(float timeStep, int velocityIterations, int positionIterations) {
        this.world.step(timeStep, velocityIterations, positionIterations);
    }

    public void clearForces() {
        this.world.clearForces();
    }

    public void setWarmStarting(boolean flag) {
        this.world.setWarmStarting(flag);
    }

    public void setContinuousPhysics(boolean flag) {
        this.world.setContinuousPhysics(flag);
    }

    public int getProxyCount() {
        return this.world.getProxyCount();
    }

    public int getBodyCount() {
        return this.world.getBodyCount();
    }

    public int getJointCount() {
        return this.world.getJointCount();
    }

    public int getContactCount() {
        return this.world.getContactCount();
    }

    public void setGravity(Vector2 gravity) {
        this.world.setGravity(this.tmp.set(gravity.x, gravity.y));
    }

    public Vector2 getGravity() {
        Vec2 gravity = this.world.getGravity();
        return this.tmp2.set(gravity.x, gravity.y);
    }

    public boolean isLocked() {
        return this.world.isLocked();
    }

    public void setAutoClearForces(boolean flag) {
        this.world.setAutoClearForces(flag);
    }

    public boolean getAutoClearForces() {
        return this.world.getAutoClearForces();
    }

    public void QueryAABB(final QueryCallback callback, float lowerX, float lowerY, float upperX, float upperY) {
        this.aabb.lowerBound.set(lowerX, lowerY);
        this.aabb.upperBound.set(upperX, upperY);
        this.world.queryAABB(new org.jbox2d.callbacks.QueryCallback(){

            @Override
            public boolean reportFixture(org.jbox2d.dynamics.Fixture f) {
                Fixture fixture = (Fixture)World.this.fixtures.get((Object)f);
                return callback.reportFixture(fixture);
            }
        }, this.aabb);
    }

    public List<Contact> getContactList() {
        org.jbox2d.dynamics.contacts.Contact contactList = this.world.getContactList();
        this.contacts.clear();
        while (contactList != null) {
            Contact contact = new Contact(this, contactList);
            this.contacts.add(contact);
            contactList = contactList.m_next;
        }
        return this.contacts;
    }

    public Iterator<Body> getBodies() {
        return this.bodies.values().iterator();
    }

    public Iterator<Joint> getJoints() {
        return this.joints.values().iterator();
    }

    public void dispose() {
    }

    public static void setVelocityThreshold(float threshold) {
        Settings.velocityThreshold = threshold;
    }

    public static float getVelocityThreshold() {
        return Settings.velocityThreshold;
    }

    public void rayCast(final RayCastCallback callback, Vector2 point1, Vector2 point2) {
        this.world.raycast(new org.jbox2d.callbacks.RayCastCallback(){

            @Override
            public float reportFixture(org.jbox2d.dynamics.Fixture f, Vec2 p, Vec2 n, float fraction) {
                return callback.reportRayFixture((Fixture)World.this.fixtures.get((Object)f), World.this.point.set(p.x, p.y), World.this.normal.set(n.x, n.y), fraction);
            }
        }, this.point1.set(point1.x, point1.y), this.point2.set(point2.x, point2.y));
    }
}

