/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d.joints;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.JointDef;
import org.jbox2d.dynamics.joints.JointType;

public class FrictionJointDef
extends JointDef {
    public final Vector2 localAnchorA = new Vector2();
    public final Vector2 localAnchorB = new Vector2();
    public float maxForce = 0.0f;
    public float maxTorque = 0.0f;

    public FrictionJointDef() {
        this.type = JointDef.JointType.FrictionJoint;
    }

    public void initialize(Body bodyA, Body bodyB, Vector2 anchor) {
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.localAnchorA.set(bodyA.getLocalPoint(anchor));
        this.localAnchorB.set(bodyB.getLocalPoint(anchor));
    }

    @Override
    public org.jbox2d.dynamics.joints.JointDef toJBox2d() {
        org.jbox2d.dynamics.joints.FrictionJointDef jd = new org.jbox2d.dynamics.joints.FrictionJointDef();
        jd.bodyA = this.bodyA.body;
        jd.bodyB = this.bodyB.body;
        jd.collideConnected = this.collideConnected;
        jd.localAnchorA.set(this.localAnchorA.x, this.localAnchorA.y);
        jd.localAnchorB.set(this.localAnchorB.x, this.localAnchorB.y);
        jd.maxForce = this.maxForce;
        jd.maxTorque = this.maxTorque;
        jd.type = JointType.FRICTION;
        return jd;
    }
}

