/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d.joints;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.JointDef;
import org.jbox2d.dynamics.joints.JointType;

public class PrismaticJointDef
extends JointDef {
    public final Vector2 localAnchorA = new Vector2();
    public final Vector2 localAnchorB = new Vector2();
    public final Vector2 localAxisA = new Vector2(1.0f, 0.0f);
    public float referenceAngle = 0.0f;
    public boolean enableLimit = false;
    public float lowerTranslation = 0.0f;
    public float upperTranslation = 0.0f;
    public boolean enableMotor = false;
    public float maxMotorForce = 0.0f;
    public float motorSpeed = 0.0f;

    public PrismaticJointDef() {
        this.type = JointDef.JointType.PrismaticJoint;
    }

    public void initialize(Body bodyA, Body bodyB, Vector2 anchor, Vector2 axis) {
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.localAnchorA.set(bodyA.getLocalPoint(anchor));
        this.localAnchorB.set(bodyB.getLocalPoint(anchor));
        this.localAxisA.set(bodyA.getLocalVector(axis));
        this.referenceAngle = bodyB.getAngle() - bodyA.getAngle();
    }

    @Override
    public org.jbox2d.dynamics.joints.JointDef toJBox2d() {
        org.jbox2d.dynamics.joints.PrismaticJointDef jd = new org.jbox2d.dynamics.joints.PrismaticJointDef();
        jd.bodyA = this.bodyA.body;
        jd.bodyB = this.bodyB.body;
        jd.collideConnected = this.collideConnected;
        jd.enableLimit = this.enableLimit;
        jd.enableMotor = this.enableMotor;
        jd.localAnchorA.set(this.localAnchorA.x, this.localAnchorA.y);
        jd.localAnchorB.set(this.localAnchorB.x, this.localAnchorB.y);
        jd.localAxisA.set(this.localAxisA.x, this.localAxisA.y);
        jd.lowerTranslation = this.lowerTranslation;
        jd.maxMotorForce = this.maxMotorForce;
        jd.motorSpeed = this.motorSpeed;
        jd.referenceAngle = this.referenceAngle;
        jd.type = JointType.PRISMATIC;
        jd.upperTranslation = this.upperTranslation;
        return jd;
    }
}

