/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d.joints;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.JointDef;
import org.jbox2d.dynamics.joints.JointType;

public class RevoluteJointDef
extends JointDef {
    public final Vector2 localAnchorA = new Vector2();
    public final Vector2 localAnchorB = new Vector2();
    public float referenceAngle = 0.0f;
    public boolean enableLimit = false;
    public float lowerAngle = 0.0f;
    public float upperAngle = 0.0f;
    public boolean enableMotor = false;
    public float motorSpeed = 0.0f;
    public float maxMotorTorque = 0.0f;

    public RevoluteJointDef() {
        this.type = JointDef.JointType.RevoluteJoint;
    }

    public void initialize(Body bodyA, Body bodyB, Vector2 anchor) {
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.localAnchorA.set(bodyA.getLocalPoint(anchor));
        this.localAnchorB.set(bodyB.getLocalPoint(anchor));
        this.referenceAngle = bodyB.getAngle() - bodyA.getAngle();
    }

    @Override
    public org.jbox2d.dynamics.joints.JointDef toJBox2d() {
        org.jbox2d.dynamics.joints.RevoluteJointDef jd = new org.jbox2d.dynamics.joints.RevoluteJointDef();
        jd.bodyA = this.bodyA.body;
        jd.bodyB = this.bodyB.body;
        jd.collideConnected = this.collideConnected;
        jd.enableLimit = this.enableLimit;
        jd.enableMotor = this.enableMotor;
        jd.localAnchorA.set(this.localAnchorA.x, this.localAnchorA.y);
        jd.localAnchorB.set(this.localAnchorB.x, this.localAnchorB.y);
        jd.lowerAngle = this.lowerAngle;
        jd.maxMotorTorque = this.maxMotorTorque;
        jd.motorSpeed = this.motorSpeed;
        jd.referenceAngle = this.referenceAngle;
        jd.type = JointType.REVOLUTE;
        jd.upperAngle = this.upperAngle;
        return jd;
    }
}

