/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gwtref.client;

import com.badlogic.gwtref.client.ReflectionCache;
import com.badlogic.gwtref.client.Type;
import java.security.AccessControlException;

public class Field {
    final String name;
    final Class enclosingType;
    final Class type;
    final boolean isFinal;
    final boolean isDefaultAccess;
    final boolean isPrivate;
    final boolean isProtected;
    final boolean isPublic;
    final boolean isStatic;
    final boolean isTransient;
    final boolean isVolatile;
    boolean accessible;
    final String getter;
    final String setter;

    Field(String name, Class enclosingType, Class type, boolean isFinal, boolean isDefaultAccess, boolean isPrivate, boolean isProtected, boolean isPublic, boolean isStatic, boolean isTransient, boolean isVolatile, String getter, String setter) {
        this.name = name;
        this.enclosingType = enclosingType;
        this.type = type;
        this.isFinal = isFinal;
        this.isDefaultAccess = isDefaultAccess;
        this.isPrivate = isPrivate;
        this.isProtected = isProtected;
        this.isPublic = isPublic;
        this.isStatic = isStatic;
        this.isTransient = isTransient;
        this.isVolatile = isVolatile;
        this.getter = getter;
        this.setter = setter;
        this.accessible = isPublic;
    }

    public Object get(Object obj) throws IllegalAccessException {
        return ReflectionCache.instance.get(this, obj);
    }

    public void set(Object obj, Object value) throws IllegalAccessException {
        ReflectionCache.instance.set(this, obj, value);
    }

    public String getName() {
        return this.name;
    }

    public Type getEnclosingType() {
        return ReflectionCache.instance.forName(this.enclosingType.getName());
    }

    public Type getType() {
        return ReflectionCache.instance.forName(this.type.getName());
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public void setAccessible(boolean accessible) throws AccessControlException {
        this.accessible = accessible;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isDefaultAccess() {
        return this.isDefaultAccess;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public String toString() {
        return "Field [name=" + this.name + ", enclosingType=" + this.enclosingType + ", type=" + this.type + ", isFinal=" + this.isFinal + ", isDefaultAccess=" + this.isDefaultAccess + ", isPrivate=" + this.isPrivate + ", isProtected=" + this.isProtected + ", isPublic=" + this.isPublic + ", isStatic=" + this.isStatic + ", isTransient=" + this.isTransient + ", isVolatile=" + this.isVolatile + ", accessible=" + this.accessible + ", getter=" + this.getter + ", setter=" + this.setter + "]";
    }
}

